/*
 * Decompiled with CFR 0.152.
 */
package net.svisvi.jigsawpp.compat;

import java.util.List;
import java.util.Optional;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.forge.ForgeTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotTooltipCallback;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.fluids.FluidStack;
import net.svisvi.jigsawpp.item.init.ModItems;
import net.svisvi.jigsawpp.item.pilule.AbstractPiluleItem;
import net.svisvi.jigsawpp.item.purgen_recipe_helpers.AbstractPurgenRecipeHelperItem;
import net.svisvi.jigsawpp.recipe.PurgenFactoryRecipe;

public class PurgenFactoryCategory
implements IRecipeCategory<PurgenFactoryRecipe> {
    public static final ResourceLocation UID = new ResourceLocation("jigsaw_pp", "purgen_factory");
    public static final ResourceLocation TEXTURE = new ResourceLocation("jigsaw_pp", "textures/gui/purgen_factory_recipe_gui.png");
    public static final RecipeType<PurgenFactoryRecipe> PURGEN_FACTORY_TYPE = new RecipeType(UID, PurgenFactoryRecipe.class);
    private final IDrawable background;
    private final IDrawable icon;

    public PurgenFactoryCategory(IGuiHelper helper) {
        this.background = helper.createDrawable(TEXTURE, 0, 0, 176, 85);
        this.icon = helper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)ModItems.PURGEN_FACTORY.get()));
    }

    public RecipeType<PurgenFactoryRecipe> getRecipeType() {
        return PURGEN_FACTORY_TYPE;
    }

    public Component getTitle() {
        return Component.m_237115_((String)"recipe.jigsaw_pp.purgen_factory");
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, PurgenFactoryRecipe recipe, IFocusGroup focuses) {
        builder.addSlot(RecipeIngredientRole.INPUT, 26, 6).addIngredients((Ingredient)recipe.m_7527_().get(0));
        builder.addSlot(RecipeIngredientRole.INPUT, 26, 24).addIngredients((Ingredient)recipe.m_7527_().get(1));
        ItemStack output_stack = recipe.m_8043_(null);
        AbstractPiluleItem.setDurationBuff(recipe.getAdditionalTime(null), output_stack);
        AbstractPiluleItem.setPurity(recipe.getPurity(null) / 4, output_stack);
        PotionUtils.m_43552_((ItemStack)output_stack, recipe.getEffects());
        builder.addSlot(RecipeIngredientRole.OUTPUT, 152, 60).addItemStack(output_stack);
        builder.addSlot(RecipeIngredientRole.RENDER_ONLY, 80, 96).addItemStack(new ItemStack((ItemLike)ModItems.PURGEN_FACTORY_BIG_THUMB.get()));
        builder.addSlot(RecipeIngredientRole.INPUT, 152, 29).addItemStack(new ItemStack((ItemLike)ModItems.EMPTY_PILULE.get()));
        ItemStack additionalTimeStack = new ItemStack((ItemLike)ModItems.PURGEN_RECIPE_HELPER_CLOCK.get());
        AbstractPurgenRecipeHelperItem.setToDisplay("int", additionalTimeStack);
        AbstractPurgenRecipeHelperItem.setInt(recipe.getAdditionalTime(null), additionalTimeStack);
        ItemStack purityStack = new ItemStack((ItemLike)ModItems.PURGEN_RECIPE_HELPER_PURITY.get());
        AbstractPurgenRecipeHelperItem.setToDisplay("int", purityStack);
        AbstractPurgenRecipeHelperItem.setInt(recipe.getPurity(null), purityStack);
        ItemStack tntStack = new ItemStack((ItemLike)ModItems.PURGEN_RECIPE_HELPER_TNT.get());
        AbstractPurgenRecipeHelperItem.setToDisplay("float_alt", tntStack);
        AbstractPurgenRecipeHelperItem.setFloatAlt(recipe.getMalChance(null), tntStack);
        builder.addSlot(RecipeIngredientRole.RENDER_ONLY, 134, 60).addItemStack(tntStack);
        ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.OUTPUT, 52, 11).addIngredient((IIngredientType)ForgeTypes.FLUID_STACK, (Object)recipe.getFluidStack())).addTooltipCallback(PurgenFactoryCategory.addFluidTooltip(recipe.getFluidStack().getAmount()));
    }

    public static IRecipeSlotTooltipCallback addFluidTooltip(int mbAmount) {
        return (view, tooltip) -> {
            Optional displayed = view.getDisplayedIngredient((IIngredientType)ForgeTypes.FLUID_STACK);
            if (displayed.isEmpty()) {
                return;
            }
            FluidStack fluidStack = (FluidStack)displayed.get();
            int amount = mbAmount == -1 ? fluidStack.getAmount() : mbAmount;
            MutableComponent text = Component.m_237113_((String)String.valueOf(amount)).m_7220_((Component)Component.m_237115_((String)"jigsaw_pp.tooltip.liquid.mb")).m_130940_(ChatFormatting.GOLD);
            if (tooltip.isEmpty()) {
                tooltip.add(0, text);
            } else {
                List siblings = ((Component)tooltip.get(0)).m_7360_();
                siblings.add(Component.m_237113_((String)" "));
                siblings.add(text);
            }
        };
    }
}

