/*
 * Decompiled with CFR 0.152.
 */
package net.svisvi.jigsawpp.entity.beaver_zombie;

import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.registries.ForgeRegistries;
import net.svisvi.jigsawpp.entity.projectile.BeaverzookaEntity;

public class BeaverZombieEatTreeGoal
extends Goal {
    private static final int EAT_ANIMATION_TICKS = 40;
    private final Mob mob;
    private final Level level;
    private int eatAnimationTick;

    public BeaverZombieEatTreeGoal(Mob pMob) {
        this.mob = pMob;
        this.level = pMob.m_9236_();
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK, Goal.Flag.JUMP));
    }

    public boolean m_8036_() {
        if (this.mob.m_217043_().m_188503_(5) != 0) {
            return false;
        }
        BlockPos blockpos = BeaverZombieEatTreeGoal.getLookPos((Entity)this.mob);
        BlockPos downPos = this.mob.m_20183_().m_7495_();
        BlockPos blockPosDown = this.getLookPosDown(blockpos);
        return this.isBlockWood(blockpos) || this.isBlockWood(downPos) || this.isBlockWood(blockPosDown) || this.hasWoodenBlockUp(4);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isBlockWood(BlockPos pos) {
        BlockState state = this.level.m_8055_(pos);
        if (BeaverzookaEntity.notReplaceableTags.stream().anyMatch(arg_0 -> ((BlockState)state).m_204336_(arg_0))) return false;
        if (!BeaverzookaEntity.replaceableTags.stream().anyMatch(arg_0 -> ((BlockState)state).m_204336_(arg_0))) return false;
        return true;
    }

    private BlockPos getLookPosDown(BlockPos pos) {
        int x = pos.m_123341_();
        int y = pos.m_123342_();
        int z = pos.m_123343_();
        int yd = y - 1;
        return new BlockPos(x, yd, z);
    }

    public void m_8056_() {
        this.eatAnimationTick = this.m_183277_(10);
        this.level.m_7605_((Entity)this.mob, (byte)10);
        this.mob.m_21573_().m_26573_();
    }

    public void m_8041_() {
        this.eatAnimationTick = 0;
    }

    public boolean m_8045_() {
        return this.eatAnimationTick > 0;
    }

    public int getEatAnimationTick() {
        return this.eatAnimationTick;
    }

    public void m_8037_() {
        this.eatAnimationTick = Math.max(0, this.eatAnimationTick - 1);
        if (this.eatAnimationTick == this.m_183277_(2)) {
            BlockPos blockpos = BeaverZombieEatTreeGoal.getLookPos((Entity)this.mob);
            BlockPos downPos = this.mob.m_20183_().m_7495_();
            if (this.isBlockWood(blockpos)) {
                if (this.isBlockWood(this.getLookPosDown(blockpos))) {
                    this.breakBlockHorizontaly(this.getLookPosDown(blockpos));
                } else {
                    this.breakBlockHorizontaly(blockpos);
                }
            } else if (this.hasWoodenBlockUp(4)) {
                for (int i = 1; i < 4; ++i) {
                    if (!this.isBlockWood(this.mob.m_20183_().m_6630_(i))) continue;
                    this.breakBlockVerticaly(this.mob.m_20183_().m_6630_(i));
                    break;
                }
            } else if (this.isBlockWood(downPos)) {
                this.breakBlockVerticaly(downPos);
            }
        }
    }

    private boolean hasWoodenBlockUp(int distance) {
        boolean b = false;
        for (int i = 1; i < distance; ++i) {
            if (!this.isBlockWood(this.mob.m_20183_().m_6630_(i))) continue;
            b = true;
            break;
        }
        return b;
    }

    public void breakBlockVerticaly(BlockPos downPos) {
        if (ForgeEventFactory.getMobGriefingEvent((Level)this.level, (Entity)this.mob)) {
            this.level.m_46796_(2001, downPos, Block.m_49956_((BlockState)this.level.m_8055_(downPos).m_60734_().m_49966_()));
            this.level.m_7731_(downPos, Blocks.f_50016_.m_49966_(), 2);
            if (!this.level.m_5776_()) {
                this.level.m_5594_(null, downPos, (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("entity.player.burp")), SoundSource.BLOCKS, 1.0f, -1.0f);
            } else {
                this.level.m_245747_(downPos, (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("entity.player.burp")), SoundSource.BLOCKS, 1.0f, -1.0f, false);
            }
        }
    }

    public void breakBlockHorizontaly(BlockPos blockpos) {
        if (ForgeEventFactory.getMobGriefingEvent((Level)this.level, (Entity)this.mob)) {
            this.level.m_46796_(2001, blockpos, Block.m_49956_((BlockState)this.level.m_8055_(blockpos).m_60734_().m_49966_()));
            this.level.m_7731_(blockpos, Blocks.f_50016_.m_49966_(), 2);
            if (!this.level.m_5776_()) {
                this.level.m_5594_(null, blockpos, (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("entity.player.burp")), SoundSource.BLOCKS, 1.0f, -1.0f);
            } else {
                this.level.m_245747_(blockpos, (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("entity.player.burp")), SoundSource.BLOCKS, 1.0f, -1.0f, false);
            }
        }
    }

    public static BlockPos getLookPos(Entity entity) {
        BlockPos pPos = new BlockPos(entity.m_9236_().m_45547_(new ClipContext(entity.m_20299_(1.0f), entity.m_20299_(1.0f).m_82549_(entity.m_20252_(1.0f).m_82490_(3.0)), ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, entity)).m_82425_().m_123341_(), entity.m_9236_().m_45547_(new ClipContext(entity.m_20299_(1.0f), entity.m_20299_(1.0f).m_82549_(entity.m_20252_(1.0f).m_82490_(3.0)), ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, entity)).m_82425_().m_123342_(), entity.m_9236_().m_45547_(new ClipContext(entity.m_20299_(1.0f), entity.m_20299_(1.0f).m_82549_(entity.m_20252_(1.0f).m_82490_(3.0)), ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, entity)).m_82425_().m_123343_());
        return pPos;
    }
}

