/*
 * Decompiled with CFR 0.152.
 */
package net.svisvi.jigsawpp.entity.beaver_zombie;

import com.mojang.serialization.DynamicOps;
import java.util.Random;
import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.animal.Turtle;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.monster.ZombieVillager;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.ForgeConfig;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.registries.ForgeRegistries;
import net.svisvi.jigsawpp.entity.beaver_zombie.BeaverZombieAttackGoal;
import net.svisvi.jigsawpp.entity.beaver_zombie.BeaverZombieEatTreeGoal;
import net.svisvi.jigsawpp.entity.beaver_zombie.BeaverZombieGoToWoodGoal;
import net.svisvi.jigsawpp.entity.blabbit.BlabbitEntity;
import net.svisvi.jigsawpp.entity.moss_elephant.MossElephantEntity;
import net.svisvi.jigsawpp.item.init.ModItems;

public class BeaverZombieEntity
extends Monster {
    private static final UUID SPEED_MODIFIER_BABY_UUID = UUID.fromString("B9766B59-9566-4402-BC1F-2EE2A276D836");
    private static final AttributeModifier SPEED_MODIFIER_BABY = new AttributeModifier(SPEED_MODIFIER_BABY_UUID, "Baby speed boost", 0.5, AttributeModifier.Operation.MULTIPLY_BASE);
    private static final EntityDataAccessor<Boolean> DATA_BABY_ID = SynchedEntityData.m_135353_(Zombie.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> DATA_SPECIAL_TYPE_ID = SynchedEntityData.m_135353_(Zombie.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> DATA_DROWNED_CONVERSION_ID = SynchedEntityData.m_135353_(Zombie.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final float ZOMBIE_LEADER_CHANCE = 0.05f;
    public static final int REINFORCEMENT_ATTEMPTS = 50;
    public static final int REINFORCEMENT_RANGE_MAX = 40;
    public static final int REINFORCEMENT_RANGE_MIN = 7;
    protected static final float BABY_EYE_HEIGHT_ADJUSTMENT = 0.81f;
    private static final float BREAK_DOOR_CHANCE = 0.1f;
    private static final Predicate<Difficulty> DOOR_BREAKING_PREDICATE = p_34284_ -> p_34284_ == Difficulty.HARD;
    private boolean canBreakDoors;
    private int inWaterTime;
    private int conversionTime;

    public BeaverZombieEntity(EntityType<? extends Monster> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.addBehaviourGoals();
    }

    protected void addBehaviourGoals() {
        this.f_21345_.m_25352_(2, (Goal)new BeaverZombieAttackGoal(this, 1.0, false));
        this.f_21345_.m_25352_(7, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(2, (Goal)new BeaverZombieEatTreeGoal((Mob)this));
        this.f_21345_.m_25352_(6, (Goal)new BeaverZombieGoToWoodGoal((PathfinderMob)this, 1.0, 10));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, AbstractVillager.class, false));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, true));
        this.f_21346_.m_25352_(5, (Goal)new NearestAttackableTargetGoal((Mob)this, Turtle.class, 10, true, false, Turtle.f_30122_));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, BlabbitEntity.class, true));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, MossElephantEntity.class, true));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22277_, 35.0).m_22268_(Attributes.f_22279_, (double)0.23f).m_22268_(Attributes.f_22281_, 3.0).m_22268_(Attributes.f_22284_, 2.0).m_22266_(Attributes.f_22287_);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.m_20088_().m_135372_(DATA_BABY_ID, (Object)false);
        this.m_20088_().m_135372_(DATA_SPECIAL_TYPE_ID, (Object)0);
        this.m_20088_().m_135372_(DATA_DROWNED_CONVERSION_ID, (Object)false);
    }

    public boolean isUnderWaterConverting() {
        return (Boolean)this.m_20088_().m_135370_(DATA_DROWNED_CONVERSION_ID);
    }

    public boolean canBreakDoors() {
        return this.canBreakDoors;
    }

    protected boolean supportsBreakDoorGoal() {
        return true;
    }

    public boolean m_6162_() {
        return (Boolean)this.m_20088_().m_135370_(DATA_BABY_ID);
    }

    public int m_213860_() {
        if (this.m_6162_()) {
            this.f_21364_ = (int)((double)this.f_21364_ * 2.5);
        }
        return super.m_213860_();
    }

    public void m_6863_(boolean pChildZombie) {
        this.m_20088_().m_135381_(DATA_BABY_ID, (Object)pChildZombie);
        if (this.m_9236_() != null && !this.m_9236_().f_46443_) {
            AttributeInstance attributeinstance = this.m_21051_(Attributes.f_22279_);
            attributeinstance.m_22130_(SPEED_MODIFIER_BABY);
            if (pChildZombie) {
                attributeinstance.m_22118_(SPEED_MODIFIER_BABY);
            }
        }
    }

    public void m_7350_(EntityDataAccessor<?> pKey) {
        if (DATA_BABY_ID.equals(pKey)) {
            this.m_6210_();
        }
        super.m_7350_(pKey);
    }

    protected boolean convertsInWater() {
        return true;
    }

    public void m_8119_() {
        super.m_8119_();
    }

    public void m_8107_() {
        if (this.m_6084_()) {
            boolean flag;
            boolean bl = flag = this.isSunSensitive() && this.m_21527_();
            if (flag) {
                ItemStack itemstack = this.m_6844_(EquipmentSlot.HEAD);
                if (!itemstack.m_41619_()) {
                    if (itemstack.m_41763_()) {
                        itemstack.m_41721_(itemstack.m_41773_() + this.f_19796_.m_188503_(2));
                        if (itemstack.m_41773_() >= itemstack.m_41776_()) {
                            this.m_21166_(EquipmentSlot.HEAD);
                            this.m_8061_(EquipmentSlot.HEAD, ItemStack.f_41583_);
                        }
                    }
                    flag = false;
                }
                if (flag) {
                    this.m_20254_(8);
                }
            }
        }
        super.m_8107_();
    }

    private void startUnderWaterConversion(int pConversionTime) {
        this.conversionTime = pConversionTime;
        this.m_20088_().m_135381_(DATA_DROWNED_CONVERSION_ID, (Object)true);
    }

    protected boolean isSunSensitive() {
        return true;
    }

    public boolean m_7327_(Entity pEntity) {
        boolean flag = super.m_7327_(pEntity);
        if (flag) {
            float f = this.m_9236_().m_6436_(this.m_20183_()).m_19056_();
            if (this.m_21205_().m_41619_() && this.m_6060_() && this.f_19796_.m_188501_() < f * 0.3f) {
                pEntity.m_20254_(2 * (int)f);
            }
        }
        return flag;
    }

    protected SoundEvent m_7515_() {
        return this.getRandomSoundEvents();
    }

    private SoundEvent getRandomSoundEvents() {
        Random rand = new Random();
        int i = rand.nextInt(1, 3);
        switch (i) {
            case 1: {
                return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("jigsaw_pp:beaverzombie_ambient_1"));
            }
            case 2: {
                return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("jigsaw_pp:beaverzombie_ambient_2"));
            }
            case 3: {
                return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("jigsaw_pp:beaverzombie_ambient_5"));
            }
        }
        return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("jigsaw_pp:beaverzombie_ambient_1"));
    }

    protected SoundEvent m_7975_(DamageSource pDamageSource) {
        return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("jigsaw_pp:beaverzombie_ambient_3"));
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("jigsaw_pp:beaverzombie_ambient_4"));
    }

    protected SoundEvent getStepSound() {
        return SoundEvents.f_12614_;
    }

    protected void m_7355_(BlockPos pPos, BlockState pBlock) {
        this.m_5496_(this.getStepSound(), 0.15f, 1.0f);
    }

    public MobType m_6336_() {
        return MobType.f_21641_;
    }

    protected void m_213945_(RandomSource pRandom, DifficultyInstance pDifficulty) {
        super.m_213945_(pRandom, pDifficulty);
        float f = pRandom.m_188501_();
        float f2 = this.m_9236_().m_46791_() == Difficulty.HARD ? 0.05f : 0.01f;
        if (f < f2) {
            int i = pRandom.m_188503_(3);
            if (i == 0) {
                this.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.f_42383_));
            } else {
                this.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.f_42384_));
            }
        }
    }

    public void m_7380_(CompoundTag pCompound) {
        super.m_7380_(pCompound);
        pCompound.m_128379_("IsBaby", this.m_6162_());
        pCompound.m_128379_("CanBreakDoors", this.canBreakDoors());
        pCompound.m_128405_("InWaterTime", this.m_20069_() ? this.inWaterTime : -1);
        pCompound.m_128405_("DrownedConversionTime", this.isUnderWaterConverting() ? this.conversionTime : -1);
    }

    public void m_7378_(CompoundTag pCompound) {
        super.m_7378_(pCompound);
        this.m_6863_(pCompound.m_128471_("IsBaby"));
        this.inWaterTime = pCompound.m_128451_("InWaterTime");
        if (pCompound.m_128425_("DrownedConversionTime", 99) && pCompound.m_128451_("DrownedConversionTime") > -1) {
            this.startUnderWaterConversion(pCompound.m_128451_("DrownedConversionTime"));
        }
    }

    public boolean m_214076_(ServerLevel pLevel, LivingEntity pEntity) {
        boolean flag = super.m_214076_(pLevel, pEntity);
        if ((pLevel.m_46791_() == Difficulty.NORMAL || pLevel.m_46791_() == Difficulty.HARD) && pEntity instanceof Villager) {
            Villager villager = (Villager)pEntity;
            if (ForgeEventFactory.canLivingConvert((LivingEntity)pEntity, (EntityType)EntityType.f_20530_, timer -> {})) {
                if (pLevel.m_46791_() != Difficulty.HARD && this.f_19796_.m_188499_()) {
                    return flag;
                }
                ZombieVillager zombievillager = (ZombieVillager)villager.m_21406_(EntityType.f_20530_, false);
                if (zombievillager != null) {
                    zombievillager.m_6518_((ServerLevelAccessor)pLevel, pLevel.m_6436_(zombievillager.m_20183_()), MobSpawnType.CONVERSION, (SpawnGroupData)new Zombie.ZombieGroupData(false, true), (CompoundTag)null);
                    zombievillager.m_34375_(villager.m_7141_());
                    zombievillager.m_34391_((Tag)villager.m_35517_().m_262795_((DynamicOps)NbtOps.f_128958_));
                    zombievillager.m_34411_(villager.m_6616_().m_45388_());
                    zombievillager.m_34373_(villager.m_7809_());
                    ForgeEventFactory.onLivingConvert((LivingEntity)pEntity, (LivingEntity)zombievillager);
                    if (!this.m_20067_()) {
                        pLevel.m_5898_((Player)null, 1026, this.m_20183_(), 0);
                    }
                    flag = false;
                }
            }
        }
        return flag;
    }

    protected float m_6431_(Pose pPose, EntityDimensions pSize) {
        return this.m_6162_() ? 0.93f : 1.74f;
    }

    public boolean m_7252_(ItemStack pStack) {
        return pStack.m_150930_(Items.f_42521_) && this.m_6162_() && this.m_20159_() ? false : super.m_7252_(pStack);
    }

    public boolean m_7243_(ItemStack pStack) {
        return pStack.m_150930_(Items.f_151056_) ? false : super.m_7243_(pStack);
    }

    @Nullable
    public SpawnGroupData finalizeSpawn(Level level, DifficultyInstance pDifficulty, MobSpawnType pReason, @Nullable SpawnGroupData pSpawnData, @Nullable CompoundTag pDataTag) {
        return pSpawnData;
    }

    public static boolean getSpawnAsBabyOdds(RandomSource pRandom) {
        return (double)pRandom.m_188501_() < (Double)ForgeConfig.SERVER.zombieBabyChance.get();
    }

    protected void handleAttributes(float pDifficulty) {
        this.randomizeReinforcementsChance();
        this.m_21051_(Attributes.f_22278_).m_22125_(new AttributeModifier("Random spawn bonus", this.f_19796_.m_188500_() * (double)0.05f, AttributeModifier.Operation.ADDITION));
        double d0 = this.f_19796_.m_188500_() * 1.5 * (double)pDifficulty;
        if (d0 > 1.0) {
            this.m_21051_(Attributes.f_22277_).m_22125_(new AttributeModifier("Random zombie-spawn bonus", d0, AttributeModifier.Operation.MULTIPLY_TOTAL));
        }
        if (this.f_19796_.m_188501_() < pDifficulty * 0.05f) {
            this.m_21051_(Attributes.f_22287_).m_22125_(new AttributeModifier("Leader zombie bonus", this.f_19796_.m_188500_() * 0.25 + 0.5, AttributeModifier.Operation.ADDITION));
            this.m_21051_(Attributes.f_22276_).m_22125_(new AttributeModifier("Leader zombie bonus", this.f_19796_.m_188500_() * 3.0 + 1.0, AttributeModifier.Operation.MULTIPLY_TOTAL));
        }
    }

    protected void randomizeReinforcementsChance() {
        this.m_21051_(Attributes.f_22287_).m_22100_(this.f_19796_.m_188500_() * (Double)ForgeConfig.SERVER.zombieBaseSummonChance.get());
    }

    public double m_6049_() {
        return this.m_6162_() ? 0.0 : -0.45;
    }

    protected void m_7472_(DamageSource pSource, int pLooting, boolean pRecentlyHit) {
        ItemStack stack;
        Random rand;
        ItemStack itemstack;
        Creeper creeper;
        super.m_7472_(pSource, pLooting, pRecentlyHit);
        Entity entity = pSource.m_7639_();
        if (entity instanceof Creeper && (creeper = (Creeper)entity).m_32313_() && !(itemstack = this.getSkull()).m_41619_()) {
            creeper.m_32314_();
            this.m_19983_(itemstack);
        }
        if ((rand = new Random()).nextInt(1, 100) < 40 && (stack = new ItemStack((ItemLike)ModItems.BEAWEED_DUST.get())) != null) {
            this.m_19983_(stack);
        }
        if (rand.nextInt(1, 100) < 70 && (stack = new ItemStack((ItemLike)ModItems.BEAWEED_SEEDS.get())) != null) {
            this.m_19983_(stack);
        }
        stack = new ItemStack((ItemLike)Items.f_42583_);
        this.m_19983_(stack);
    }

    protected ItemStack getSkull() {
        return new ItemStack((ItemLike)Items.f_42681_);
    }
}

