/*
 * Decompiled with CFR 0.152.
 */
package net.svisvi.jigsawpp.entity.beaver_zombie;

import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.BlockState;
import net.svisvi.jigsawpp.entity.projectile.BeaverzookaEntity;

public class BeaverZombieGoToWoodGoal
extends Goal {
    private static final int GIVE_UP_TICKS = 1200;
    private static final int STAY_TICKS = 1200;
    private static final int INTERVAL_TICKS = 200;
    protected final PathfinderMob mob;
    public final double speedModifier;
    protected int nextStartTick;
    protected int tryTicks;
    private int maxStayTicks;
    protected BlockPos blockPos = BlockPos.f_121853_;
    private boolean reachedTarget;
    private final int searchRange;
    private final int verticalSearchRange;
    protected int verticalSearchStart;

    public BeaverZombieGoToWoodGoal(PathfinderMob pMob, double pSpeedModifier, int pSearchRange) {
        this(pMob, pSpeedModifier, pSearchRange, 1);
    }

    public BeaverZombieGoToWoodGoal(PathfinderMob pMob, double pSpeedModifier, int pSearchRange, int pVerticalSearchRange) {
        this.mob = pMob;
        this.speedModifier = pSpeedModifier;
        this.searchRange = pSearchRange;
        this.verticalSearchStart = 0;
        this.verticalSearchRange = pVerticalSearchRange;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.JUMP));
    }

    public boolean m_8036_() {
        if (this.nextStartTick > 0) {
            --this.nextStartTick;
            return false;
        }
        this.nextStartTick = this.nextStartTick(this.mob);
        return this.findNearestBlock();
    }

    protected int nextStartTick(PathfinderMob pCreature) {
        return BeaverZombieGoToWoodGoal.m_186073_((int)(200 + pCreature.m_217043_().m_188503_(200)));
    }

    public boolean m_8045_() {
        return this.tryTicks >= -this.maxStayTicks && this.tryTicks <= 1200 && this.isValidTarget((LevelReader)this.mob.m_9236_(), this.blockPos);
    }

    public void m_8056_() {
        this.moveMobToBlock();
        this.tryTicks = 0;
        this.maxStayTicks = this.mob.m_217043_().m_188503_(this.mob.m_217043_().m_188503_(1200) + 1200) + 1200;
    }

    protected void moveMobToBlock() {
        this.mob.m_21573_().m_26519_((double)this.blockPos.m_123341_() + 0.5, (double)(this.blockPos.m_123342_() + 1), (double)this.blockPos.m_123343_() + 0.5, this.speedModifier);
    }

    public double acceptedDistance() {
        return 1.0;
    }

    protected BlockPos getMoveToTarget() {
        return this.blockPos.m_7494_();
    }

    public boolean m_183429_() {
        return true;
    }

    public void m_8037_() {
        BlockPos $$0 = this.getMoveToTarget();
        if (!$$0.m_203195_((Position)this.mob.m_20182_(), this.acceptedDistance())) {
            this.reachedTarget = false;
            ++this.tryTicks;
            if (this.shouldRecalculatePath()) {
                this.mob.m_21573_().m_26519_((double)$$0.m_123341_() + 0.5, (double)$$0.m_123342_(), (double)$$0.m_123343_() + 0.5, this.speedModifier);
            }
        } else {
            this.reachedTarget = true;
            --this.tryTicks;
        }
    }

    public boolean shouldRecalculatePath() {
        return this.tryTicks % 40 == 0;
    }

    protected boolean isReachedTarget() {
        return this.reachedTarget;
    }

    protected boolean findNearestBlock() {
        int $$0 = this.searchRange;
        int $$1 = this.verticalSearchRange;
        BlockPos $$2 = this.mob.m_20183_();
        BlockPos.MutableBlockPos $$3 = new BlockPos.MutableBlockPos();
        int $$4 = this.verticalSearchStart;
        while ($$4 <= $$1) {
            for (int $$5 = 0; $$5 < $$0; ++$$5) {
                int $$6 = 0;
                while ($$6 <= $$5) {
                    int $$7;
                    int n = $$7 = $$6 < $$5 && $$6 > -$$5 ? $$5 : 0;
                    while ($$7 <= $$5) {
                        $$3.m_122154_((Vec3i)$$2, $$6, $$4 - 1, $$7);
                        if (this.mob.m_21444_((BlockPos)$$3) && this.isValidTarget((LevelReader)this.mob.m_9236_(), (BlockPos)$$3)) {
                            this.blockPos = $$3;
                            return true;
                        }
                        $$7 = $$7 > 0 ? -$$7 : 1 - $$7;
                    }
                    $$6 = $$6 > 0 ? -$$6 : 1 - $$6;
                }
            }
            $$4 = $$4 > 0 ? -$$4 : 1 - $$4;
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean isValidTarget(LevelReader level, BlockPos blockpos) {
        BlockState state = level.m_8055_(blockpos);
        if (BeaverzookaEntity.notReplaceableTags.stream().anyMatch(arg_0 -> ((BlockState)state).m_204336_(arg_0))) return false;
        if (!BeaverzookaEntity.replaceableTags.stream().anyMatch(arg_0 -> ((BlockState)state).m_204336_(arg_0))) return false;
        return true;
    }
}

