/*
 * Decompiled with CFR 0.152.
 */
package net.svisvi.jigsawpp.entity.blabbit;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Shearable;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Rabbit;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.IForgeShearable;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.registries.ForgeRegistries;
import net.svisvi.jigsawpp.entity.beaver_zombie.BeaverZombieEntity;
import net.svisvi.jigsawpp.entity.blabbit.BlabbitGoals;
import net.svisvi.jigsawpp.item.init.ModItems;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BlabbitEntity
extends Monster
implements IForgeShearable,
Shearable {
    private static final EntityDataAccessor<Boolean> JUMPING = SynchedEntityData.m_135353_(BlabbitEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> FORCE_JUMP = SynchedEntityData.m_135353_(BlabbitEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> FEAR = SynchedEntityData.m_135353_(BlabbitEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public final AnimationState idleAnimationState = new AnimationState();
    private int idleAnimationTimeout = 0;
    public final AnimationState jumpAnimationState = new AnimationState();
    private int jumpAnimationTimeout = 0;
    private int jumpAnimationSwitcher = 0;
    private final ItemStackHandler itemHandler = new ItemStackHandler(2);
    public static final Set<Item> FOODS = new HashSet<Item>();

    public BlabbitEntity(EntityType<? extends Monster> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.f_21342_ = new BlabbitGoals.BlabbitMoveControl(this);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(JUMPING, (Object)false);
        this.f_19804_.m_135372_(FORCE_JUMP, (Object)false);
        this.f_19804_.m_135372_(FEAR, (Object)false);
    }

    public void setJumping_1(boolean jumping) {
        this.f_19804_.m_135381_(JUMPING, (Object)jumping);
    }

    public boolean isJumping_1() {
        return (Boolean)this.f_19804_.m_135370_(JUMPING);
    }

    public void setForceJump(boolean jumping) {
        this.f_19804_.m_135381_(FORCE_JUMP, (Object)jumping);
    }

    public boolean isForceJumping() {
        return (Boolean)this.f_19804_.m_135370_(FORCE_JUMP);
    }

    public void setFear(boolean jumping) {
        this.f_19804_.m_135381_(FEAR, (Object)jumping);
    }

    public boolean isFear() {
        return (Boolean)this.f_19804_.m_135370_(FEAR);
    }

    public double m_262793_(LivingEntity pEntity) {
        if (pEntity == null) {
            return 1488.0;
        }
        return Math.max(this.m_20238_(pEntity.m_262803_()), this.m_20238_(pEntity.m_20182_()));
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.m_9236_().m_5776_()) {
            this.setupAnimationStates();
        }
        if ((double)(this.m_21223_() / this.m_21233_()) < 0.4) {
            this.setFear(true);
        } else {
            this.setFear(false);
        }
    }

    private void setupAnimationStates() {
        if (this.idleAnimationTimeout <= 0) {
            this.idleAnimationTimeout = this.f_19796_.m_188503_(40) + 80;
            this.idleAnimationState.m_216977_(this.f_19797_);
        } else {
            --this.idleAnimationTimeout;
        }
        if (this.isJumping_1() && this.jumpAnimationTimeout <= 0) {
            this.jumpAnimationTimeout = 10;
            this.jumpAnimationState.m_216977_(this.f_19797_);
        } else {
            --this.jumpAnimationTimeout;
        }
        if (!this.isJumping_1()) {
            this.jumpAnimationState.m_216973_();
        }
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(2, (Goal)new BlabbitGoals.BlabbitAttackGoal((PathfinderMob)this, 1.3, true){

            @Override
            public boolean m_8036_() {
                BlabbitEntity entity_;
                BlabbitEntity entity = BlabbitEntity.this;
                if (entity instanceof BlabbitEntity && (entity_ = entity).isFear()) {
                    return false;
                }
                return super.m_8036_();
            }

            @Override
            public boolean m_8045_() {
                BlabbitEntity entity_;
                BlabbitEntity entity = BlabbitEntity.this;
                if (entity instanceof BlabbitEntity && (entity_ = entity).isFear()) {
                    return false;
                }
                return super.m_8045_();
            }
        });
        this.f_21345_.m_25352_(4, (Goal)new BlabbitGoals.BlabbitRandomDirectionGoal(this));
        this.f_21345_.m_25352_(5, (Goal)new BlabbitGoals.BlabbitKeepOnJumpingGoal(this));
        this.f_21346_.m_25352_(1, (Goal)new NearestAttackableTargetGoal((Mob)this, BeaverZombieEntity.class, 10, true, false, p_289461_ -> Math.abs(p_289461_.m_20186_() - this.m_20186_()) <= 4.0));
        this.f_21346_.m_25352_(3, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]){

            public boolean m_8036_() {
                BlabbitEntity entity_;
                BlabbitEntity entity = BlabbitEntity.this;
                if (entity instanceof BlabbitEntity && (entity_ = entity).isFear()) {
                    return false;
                }
                return super.m_8036_();
            }

            public boolean m_8045_() {
                BlabbitEntity entity_;
                BlabbitEntity entity = BlabbitEntity.this;
                if (entity instanceof BlabbitEntity && (entity_ = entity).isFear()) {
                    return false;
                }
                return super.m_8045_();
            }
        });
        this.f_21345_.m_25352_(1, (Goal)new PanicGoal((PathfinderMob)this, 2.2){

            public boolean m_8036_() {
                BlabbitEntity entity = BlabbitEntity.this;
                if (entity instanceof BlabbitEntity) {
                    BlabbitEntity entity_ = entity;
                    return super.m_8036_() && entity_.isFear();
                }
                return false;
            }

            public boolean m_8045_() {
                BlabbitEntity entity = BlabbitEntity.this;
                if (entity instanceof BlabbitEntity) {
                    BlabbitEntity entity_ = entity;
                    return super.m_8045_() && entity_.isFear();
                }
                return false;
            }
        });
    }

    protected boolean isDealsDamage() {
        return true;
    }

    protected int getJumpDelay() {
        return this.f_19796_.m_188503_(20) + 10;
    }

    protected SoundEvent getJumpSound() {
        return SoundEvents.f_12387_;
    }

    protected float m_6121_() {
        return 0.4f;
    }

    float getSoundPitch() {
        float f = 0.8f;
        return ((this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.2f + 1.0f) * f;
    }

    protected void m_6135_() {
        super.m_6135_();
        this.setJumping_1(true);
    }

    public boolean m_142535_(float pFallDistance, float pMultiplier, DamageSource pSource) {
        Random random;
        this.setJumping_1(false);
        if (this.isForceJumping()) {
            this.setForceJump(false);
            this.forceJumpDamage((LevelAccessor)this.m_9236_(), this.m_20182_());
        }
        if ((double)(random = new Random()).nextInt() > 0.9 && (this.m_5912_() || this.f_20889_ > 0)) {
            this.setForceJump(true);
        }
        return super.m_142535_(pFallDistance, pMultiplier, pSource);
    }

    protected float m_6118_() {
        float k = 0.42f;
        if (this.m_21523_()) {
            k = 0.32f;
        } else if (this.isFear()) {
            k = 1.02f;
        } else if (this.isForceJumping()) {
            k = 0.72f;
        } else if (this.f_20889_ > 0) {
            k = 0.62f;
        }
        return k * this.m_20098_() + this.m_285755_();
    }

    public void forceJumpDamage(LevelAccessor world, Vec3 vec3) {
        Level _level;
        BlockPos pPos = BlockPos.m_274561_((double)vec3.f_82479_, (double)vec3.f_82480_, (double)vec3.f_82481_);
        if (world instanceof Level) {
            _level = (Level)world;
            if (!_level.m_5776_()) {
                _level.m_5594_(null, pPos, (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("entity.husk.converted_to_zombie")), SoundSource.HOSTILE, 1.0f, 1.0f);
            } else {
                _level.m_245747_(pPos, (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("entity.husk.converted_to_zombie")), SoundSource.HOSTILE, 1.0f, 1.0f, false);
            }
        }
        if (world instanceof ServerLevel) {
            _level = (ServerLevel)world;
            _level.m_8767_((ParticleOptions)ParticleTypes.f_123772_, (double)pPos.m_123341_(), (double)pPos.m_123342_(), (double)pPos.m_123343_(), 40, 1.5, 0.2, 1.5, 0.2);
        }
        Vec3 _center = vec3;
        List<Entity> _entfound = world.m_6443_(Entity.class, new AABB(_center, _center).m_82400_(2.0), e -> true).stream().sorted(Comparator.comparingDouble(_entcnd -> _entcnd.m_20238_(_center))).toList();
        for (Entity entityiterator : _entfound) {
            if (entityiterator == this) continue;
            entityiterator.m_6469_(new DamageSource((Holder)world.m_9598_().m_175515_(Registries.f_268580_).m_246971_(DamageTypes.f_268566_), (Entity)this), 8.0f);
        }
    }

    public boolean m_6779_(LivingEntity pTarget) {
        return pTarget instanceof Player && this.m_9236_().m_46791_() == Difficulty.PEACEFUL ? false : pTarget.m_142066_();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean init(EntityType<? extends BlabbitEntity> pType, ServerLevelAccessor pLevel, MobSpawnType pSpawnType, BlockPos pPos, RandomSource pRandom) {
        ResourceKey resourceKey;
        int y = pPos.m_123342_();
        if (!BlabbitEntity.m_219013_(pType, (ServerLevelAccessor)pLevel, (MobSpawnType)pSpawnType, (BlockPos)pPos, (RandomSource)pRandom)) return false;
        if (y > 40) return false;
        if (pLevel instanceof Level) {
            Level _lvl = (Level)pLevel;
            resourceKey = _lvl.m_46472_();
        } else if (pLevel instanceof WorldGenLevel) {
            WorldGenLevel _wgl = (WorldGenLevel)pLevel;
            resourceKey = _wgl.m_6018_().m_46472_();
        } else {
            resourceKey = Level.f_46428_;
        }
        if (resourceKey != Level.f_46428_) return false;
        return true;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Animal.m_21183_().m_22268_(Attributes.f_22277_, 20.0).m_22268_(Attributes.f_22276_, 200.0).m_22268_(Attributes.f_22279_, 0.32).m_22268_(Attributes.f_22285_, (double)0.1f).m_22268_(Attributes.f_22282_, 2.0).m_22268_(Attributes.f_22281_, 8.0).m_22268_(Attributes.f_22278_, (double)0.1f);
    }

    public MobType m_6336_() {
        return MobType.f_21640_;
    }

    public SoundEvent m_7975_(DamageSource ds) {
        return this.getRandomSound();
    }

    public SoundEvent m_5592_() {
        return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("jigsaw_pp:blabbit_live_2"));
    }

    public SoundEvent m_7515_() {
        return this.getRandomSound();
    }

    public SoundEvent getRandomSound() {
        Random random = new Random();
        int rand = random.nextInt(4);
        return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("jigsaw_pp:blabbit_live_" + Integer.toString(rand)));
    }

    public boolean m_6469_(DamageSource damagesource, float amount) {
        if (damagesource.m_276093_(DamageTypes.f_268671_)) {
            return false;
        }
        if (damagesource.m_276093_(DamageTypes.f_268585_)) {
            return false;
        }
        if (damagesource.m_276093_(DamageTypes.f_268450_)) {
            return false;
        }
        if (damagesource.m_276093_(DamageTypes.f_268482_)) {
            return false;
        }
        return super.m_6469_(damagesource, amount);
    }

    public boolean m_7337_(Entity entity) {
        return false;
    }

    public boolean m_5829_() {
        return false;
    }

    public boolean m_6094_() {
        return true;
    }

    protected void m_7324_(Entity entityIn) {
    }

    protected void m_6138_() {
    }

    public void m_6075_() {
        super.m_6075_();
    }

    public boolean m_6573_(Player pPlayer) {
        return !this.m_21523_() && this.isFear();
    }

    public Vec3 m_7939_() {
        return new Vec3(0.0, (double)(0.6f * this.m_20192_()) - 0.35, (double)(this.m_20205_() * 0.4f) - 0.2);
    }

    protected double m_5823_() {
        return 1.5;
    }

    public boolean isFood(ItemStack pStack) {
        return FOODS.contains(pStack.m_41720_());
    }

    public boolean isShearable(@NotNull ItemStack item, Level level, BlockPos pos) {
        return this.m_21523_();
    }

    @NotNull
    public List<ItemStack> onSheared(@Nullable Player player, @NotNull ItemStack item, Level level, BlockPos pos, int fortune) {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        list.add(new ItemStack((ItemLike)ModItems.BLABBALL.get(), 2));
        if (this.m_21523_()) {
            list.add(new ItemStack((ItemLike)Items.f_42655_, 1));
        }
        if (!level.m_5776_()) {
            level.m_5594_(null, pos, SoundEvents.f_12344_, SoundSource.NEUTRAL, 1.0f, 1.0f);
            level.m_5594_(null, pos, SoundEvents.f_12602_, SoundSource.NEUTRAL, 1.0f, 1.0f);
        } else {
            level.m_245747_(pos, SoundEvents.f_12344_, SoundSource.NEUTRAL, 1.0f, 1.0f, false);
            level.m_245747_(pos, SoundEvents.f_12602_, SoundSource.NEUTRAL, 1.0f, 1.0f, false);
        }
        if (level instanceof ServerLevel) {
            ServerLevel _level = (ServerLevel)level;
            _level.m_8767_((ParticleOptions)ParticleTypes.f_123813_, (double)pos.m_123341_(), (double)(pos.m_123342_() + 1), (double)pos.m_123343_(), 12, 0.5, 0.5, 0.5, 0.0);
        }
        Rabbit rabbit = (Rabbit)EntityType.f_20517_.m_20615_(level);
        rabbit.m_20035_(pos, 0.0f, 0.0f);
        rabbit.m_6518_((ServerLevelAccessor)level, level.m_6436_(this.m_20097_()), MobSpawnType.CONVERSION, (SpawnGroupData)null, (CompoundTag)null);
        level.m_7967_((Entity)rabbit);
        this.m_146870_();
        return list;
    }

    public InteractionResult m_6071_(Player pPlayer, InteractionHand pHand) {
        pPlayer.m_21120_(pHand);
        return super.m_6071_(pPlayer, pHand);
    }

    public final InteractionResult m_6096_(Player pPlayer, InteractionHand pHand) {
        if (!this.m_6084_()) {
            return InteractionResult.PASS;
        }
        if (this.m_21524_() == pPlayer && pPlayer.m_21120_(pHand).m_41619_()) {
            this.m_21455_(true, !pPlayer.m_150110_().f_35937_);
            this.m_146852_(GameEvent.f_223708_, (Entity)pPlayer);
            return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
        }
        InteractionResult interactionresult = this.m_21499_(pPlayer, pHand);
        if (interactionresult.m_19077_()) {
            this.m_146852_(GameEvent.f_223708_, (Entity)pPlayer);
            return interactionresult;
        }
        interactionresult = this.m_6071_(pPlayer, pHand);
        if (interactionresult.m_19077_()) {
            this.m_146852_(GameEvent.f_223708_, (Entity)pPlayer);
            return interactionresult;
        }
        return InteractionResult.PASS;
    }

    public void m_5851_(SoundSource pCategory) {
        this.m_9236_().m_6269_((Player)null, (Entity)this, SoundEvents.f_12344_, pCategory, 1.0f, 1.0f);
        int i = 2;
        for (int j = 0; j < i; ++j) {
            ItemEntity itementity = this.m_20000_((ItemLike)ModItems.BLABBALL.get(), 1);
            if (itementity == null) continue;
            itementity.m_20256_(itementity.m_20184_().m_82520_((double)((this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.1f), (double)(this.f_19796_.m_188501_() * 0.05f), (double)((this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.1f)));
        }
        Rabbit rabbit = (Rabbit)EntityType.f_20517_.m_20615_(this.m_9236_());
        rabbit.m_20035_(rabbit.m_20097_(), 0.0f, 0.0f);
        rabbit.m_6518_((ServerLevelAccessor)this.m_9236_(), this.m_9236_().m_6436_(this.m_20097_()), MobSpawnType.CONVERSION, (SpawnGroupData)null, (CompoundTag)null);
        this.m_9236_().m_7967_((Entity)rabbit);
        this.m_146870_();
    }

    public boolean m_6220_() {
        return true;
    }

    static {
        FOODS.add(Items.f_42619_);
        FOODS.add(Items.f_42677_);
    }
}

