/*
 * Decompiled with CFR 0.152.
 */
package net.svisvi.jigsawpp.entity.blabbit;

import java.util.EnumSet;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.svisvi.jigsawpp.entity.blabbit.BlabbitEntity;

public class BlabbitGoals {

    static class BlabbitKeepOnJumpingGoal
    extends Goal {
        private final BlabbitEntity blabbit;

        public BlabbitKeepOnJumpingGoal(BlabbitEntity pBlabbit) {
            this.blabbit = pBlabbit;
            this.m_7021_(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            return !this.blabbit.m_20159_();
        }

        public void m_8037_() {
            MoveControl movecontrol = this.blabbit.m_21566_();
            if (movecontrol instanceof BlabbitMoveControl) {
                BlabbitMoveControl slime$slimemovecontrol = (BlabbitMoveControl)movecontrol;
                slime$slimemovecontrol.setWantedMovement(3.0);
            }
        }
    }

    static class BlabbitRandomDirectionGoal
    extends Goal {
        private final BlabbitEntity blabbit;
        private float chosenDegrees;
        private int nextRandomizeTime;

        public BlabbitRandomDirectionGoal(BlabbitEntity pBlabbit) {
            this.blabbit = pBlabbit;
            this.m_7021_(EnumSet.of(Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            return this.blabbit.m_5448_() == null && (this.blabbit.m_20096_() || this.blabbit.m_20069_() || this.blabbit.m_20077_() || this.blabbit.m_21023_(MobEffects.f_19620_)) && this.blabbit.m_21566_() instanceof BlabbitMoveControl;
        }

        public void m_8037_() {
            MoveControl movecontrol;
            if (--this.nextRandomizeTime <= 0) {
                this.nextRandomizeTime = this.m_183277_(40 + this.blabbit.m_217043_().m_188503_(60));
                this.chosenDegrees = this.blabbit.m_217043_().m_188503_(360);
            }
            if ((movecontrol = this.blabbit.m_21566_()) instanceof BlabbitMoveControl) {
                BlabbitMoveControl slime$slimemovecontrol = (BlabbitMoveControl)movecontrol;
                slime$slimemovecontrol.setDirection(this.chosenDegrees, false);
            }
        }
    }

    static class BlabbitMoveControl
    extends MoveControl {
        private float yRot;
        private int jumpDelay;
        private final BlabbitEntity blabbit;
        private boolean isAggressive;

        public BlabbitMoveControl(BlabbitEntity pBlabbit) {
            super((Mob)pBlabbit);
            this.blabbit = pBlabbit;
            this.yRot = 180.0f * pBlabbit.m_146908_() / (float)Math.PI;
        }

        public void setDirection(float pYRot, boolean pAggressive) {
            this.yRot = pYRot;
            this.isAggressive = pAggressive;
        }

        public void setWantedMovement(double pSpeed) {
            this.f_24978_ = pSpeed;
            this.f_24981_ = MoveControl.Operation.MOVE_TO;
        }

        public void m_8126_() {
            this.f_24974_.m_146922_(this.m_24991_(this.f_24974_.m_146908_(), this.yRot, 90.0f));
            this.f_24974_.f_20885_ = this.f_24974_.m_146908_();
            this.f_24974_.f_20883_ = this.f_24974_.m_146908_();
            if (this.f_24981_ != MoveControl.Operation.MOVE_TO) {
                this.f_24974_.m_21564_(0.0f);
            } else {
                this.f_24981_ = MoveControl.Operation.WAIT;
                if (this.f_24974_.m_20096_()) {
                    this.f_24974_.m_7910_((float)(this.f_24978_ * this.f_24974_.m_21133_(Attributes.f_22279_)));
                    if (this.jumpDelay-- <= 0) {
                        this.jumpDelay = this.blabbit.getJumpDelay();
                        if (this.isAggressive) {
                            this.jumpDelay /= 3;
                        }
                        this.blabbit.m_21569_().m_24901_();
                        this.blabbit.m_5496_(this.blabbit.getJumpSound(), this.blabbit.m_6121_(), this.blabbit.getSoundPitch());
                    } else {
                        this.blabbit.f_20900_ = 0.0f;
                        this.blabbit.f_20902_ = 0.0f;
                        this.f_24974_.m_7910_(0.0f);
                    }
                } else {
                    this.f_24974_.m_7910_((float)(this.f_24978_ * this.f_24974_.m_21133_(Attributes.f_22279_)));
                }
            }
        }
    }

    static class BlabbitAttackGoal
    extends MeleeAttackGoal {
        private final BlabbitEntity blabbit;
        private int attackDelay = 10;
        private int ticksUntilNextAttack = 10;
        private boolean shouldCountTillNextAttack = false;
        private int growTiredTimer;

        public BlabbitAttackGoal(PathfinderMob pMob, double pSpeedModifier, boolean pFollowingTargetEvenIfNotSeen) {
            super(pMob, pSpeedModifier, pFollowingTargetEvenIfNotSeen);
            this.blabbit = (BlabbitEntity)pMob;
            this.m_7021_(EnumSet.of(Goal.Flag.LOOK));
        }

        protected void m_6739_(LivingEntity pEnemy, double pDistToEnemySqr) {
            double d0 = this.m_6639_(pEnemy);
            if (pDistToEnemySqr <= d0) {
                this.m_25563_();
                this.f_25540_.m_7327_((Entity)pEnemy);
            }
        }

        public boolean m_8036_() {
            return super.m_8036_();
        }

        public void m_8056_() {
            this.growTiredTimer = BlabbitAttackGoal.m_186073_((int)300);
            this.attackDelay = 40;
            this.ticksUntilNextAttack = 40;
            this.f_25540_.m_21561_(true);
            super.m_8056_();
        }

        public boolean m_8045_() {
            return super.m_8045_();
        }

        public boolean m_183429_() {
            return true;
        }

        public void m_8037_() {
            MoveControl movecontrol;
            LivingEntity livingentity = this.blabbit.m_5448_();
            if (livingentity != null) {
                this.blabbit.m_21391_((Entity)livingentity, 10.0f, 10.0f);
            }
            if ((movecontrol = this.blabbit.m_21566_()) instanceof BlabbitMoveControl) {
                BlabbitMoveControl slime$slimemovecontrol = (BlabbitMoveControl)movecontrol;
                slime$slimemovecontrol.setDirection(this.blabbit.m_146908_(), this.blabbit.isDealsDamage());
            }
            if (this.shouldCountTillNextAttack) {
                this.ticksUntilNextAttack = Math.max(this.ticksUntilNextAttack - 1, 0);
            }
            double d0 = this.f_25540_.m_262793_(livingentity);
            this.m_6739_(livingentity, d0);
        }

        protected double m_6639_(LivingEntity entity) {
            if (entity == null) {
                return 0.0;
            }
            return this.f_25540_.m_20205_() * this.f_25540_.m_20205_() + entity.m_20205_();
        }
    }
}

