/*
 * Decompiled with CFR 0.152.
 */
package net.svisvi.jigsawpp.entity.emitters;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.logging.LogUtils;
import java.util.Comparator;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.commands.arguments.ParticleArgument;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.TraceableEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.svisvi.jigsawpp.entity.init.ModEntities;
import net.svisvi.jigsawpp.particles.ModParticleTypes;
import net.svisvi.jigsawpp.procedures.ut.NuclearShroom;
import org.slf4j.Logger;

public class AbstractEmitterEntity
extends Entity
implements TraceableEntity {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final EntityDataAccessor<Float> DATA_RADIUS = SynchedEntityData.m_135353_(AbstractEmitterEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Integer> DATA_DURATION = SynchedEntityData.m_135353_(AbstractEmitterEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> DATA_WAITING = SynchedEntityData.m_135353_(AbstractEmitterEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<ParticleOptions> DATA_PARTICLE = SynchedEntityData.m_135353_(AbstractEmitterEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135036_);
    private static final EntityDataAccessor<Boolean> DEBUG_MODE = SynchedEntityData.m_135353_(AbstractEmitterEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final float DEFAULT_RADIUS = 2.5f;
    private static final int DEFAULT_DURATION = 6000;
    private static final ParticleOptions DEFAULT_PARTICLE = (ParticleOptions)ModParticleTypes.POOP.get();
    private static final float MIN_RADIUS = 0.5f;
    private static final float MAX_RADIUS = 32.0f;
    private static final float DEFAULT_DENSITY = 35.0f;
    private int waitTime = 0;
    private float radiusOnUse;
    private float radiusPerTick;
    public float particleSpeed = 0.01f;
    public float density = 35.0f;
    public boolean affectOwner = true;
    @Nullable
    private LivingEntity owner;
    @Nullable
    private UUID ownerUUID;
    @Nullable
    public Item bottle;
    public boolean suckable = true;
    public boolean bottlePickable = true;

    public AbstractEmitterEntity(EntityType<? extends AbstractEmitterEntity> type, Level level, ParticleOptions particleOptions, float radiuss, int durra) {
        super(type, level);
        this.f_19794_ = true;
        this.setParticle(particleOptions);
        this.setRadius(radiuss);
        this.setDuration(durra);
        this.setDebugMode(false);
        this.setAffectOwner(true);
        this.setSuckable(true);
        this.setBottlePickable(true);
    }

    public AbstractEmitterEntity(EntityType<? extends AbstractEmitterEntity> type, Level level) {
        this(type, level, DEFAULT_PARTICLE, 2.5f, 6000);
    }

    public AbstractEmitterEntity(Level level, double x, double y, double z) {
        this(level, x, y, z, DEFAULT_PARTICLE, 2.5f, 6000);
    }

    public AbstractEmitterEntity(Level level, double x, double y, double z, ParticleOptions particleOptions, float radiuss, int durra) {
        this((EntityType<? extends AbstractEmitterEntity>)((EntityType)ModEntities.ABSTRACT_EMITTER.get()), level, particleOptions, radiuss, durra);
        this.m_6034_(x, y, z);
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(DATA_RADIUS, (Object)Float.valueOf(2.5f));
        this.f_19804_.m_135372_(DATA_DURATION, (Object)6000);
        this.f_19804_.m_135372_(DATA_WAITING, (Object)false);
        this.f_19804_.m_135372_(DATA_PARTICLE, (Object)DEFAULT_PARTICLE);
        this.f_19804_.m_135372_(DEBUG_MODE, (Object)false);
    }

    public boolean isDebugMode() {
        return (Boolean)this.f_19804_.m_135370_(DEBUG_MODE);
    }

    public void setDebugMode(boolean debug) {
        this.f_19804_.m_135381_(DEBUG_MODE, (Object)debug);
        if (debug) {
            this.setDuration(Integer.MAX_VALUE);
            LOGGER.info("Emitter debug mode enabled - will not despawn");
        }
    }

    public int getDuration() {
        return (Integer)this.f_19804_.m_135370_(DATA_DURATION);
    }

    public void setDuration(int duration) {
        if (!this.m_9236_().f_46443_) {
            this.f_19804_.m_135381_(DATA_DURATION, (Object)Math.max(0, duration));
        }
    }

    public int getRemainingTime() {
        return this.isDebugMode() ? Integer.MAX_VALUE : this.getDuration() - this.f_19797_;
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.m_9236_().f_46443_) {
            return;
        }
        this.spawnParticles(this.getParticleCount(), this.particleSpeed);
        if (this.radiusPerTick != 0.0f) {
            float newRadius = this.getRadius() + this.radiusPerTick;
            if (newRadius < 0.5f) {
                this.m_146870_();
                return;
            }
            this.setRadius(newRadius);
        }
        if (this.f_19797_ % 1 == 0) {
            this.applyEffects();
        }
        if (!this.isDebugMode() && this.getRemainingTime() <= 0) {
            this.die();
        }
    }

    public void die() {
        this.m_146870_();
    }

    public void spawnParticles(int count, float speed) {
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            NuclearShroom.sendFarParticles(serverLevel, this.getParticle(), this.m_20185_(), this.m_20186_(), this.m_20189_(), this.getRadius(), this.getRadius(), this.getRadius(), count, speed);
        }
    }

    public void applyEffects() {
        Level level = this.m_9236_();
        Vec3 _center = this.m_20182_();
        List<Entity> _entfound = level.m_6443_(Entity.class, new AABB(_center, _center).m_82400_((double)(this.getRadius() * 2.0f)), e -> true).stream().sorted(Comparator.comparingDouble(_entcnd -> _entcnd.m_20238_(_center))).toList();
        for (Entity entityiterator : _entfound) {
            LivingEntity _entity;
            if (!(entityiterator instanceof LivingEntity) || (_entity = (LivingEntity)entityiterator).m_9236_().m_5776_() || !this.isAffectOwner() && _entity == this.getOwner()) continue;
            this.effectForEach(_entity);
        }
    }

    public void effectForEach(LivingEntity entity) {
    }

    public InteractionResult m_6096_(Player pPlayer, InteractionHand pHand) {
        if (!this.m_9236_().m_5776_() && this.getBottle() != null && this.isBottlePickable() && this.isSuckable()) {
            ItemStack itemstack = pPlayer.m_21120_(pHand);
            if (itemstack.m_150930_(Items.f_42590_)) {
                pPlayer.m_5496_(SoundEvents.f_11771_, 1.0f, 1.0f);
                ItemStack itemstack1 = new ItemStack((ItemLike)this.getBottle(), 1);
                itemstack.m_41774_(1);
                pPlayer.m_36356_(itemstack1);
                this.suckOver();
                return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
            }
            return super.m_6096_(pPlayer, pHand);
        }
        return super.m_6096_(pPlayer, pHand);
    }

    public void suckOver() {
        this.m_146870_();
    }

    public boolean isSuckable() {
        return this.suckable;
    }

    public void setSuckable(boolean suckable) {
        this.suckable = suckable;
    }

    public boolean isBottlePickable() {
        return this.bottlePickable;
    }

    public void setBottlePickable(boolean bottlePickable) {
        this.bottlePickable = bottlePickable;
    }

    @Nullable
    public Item getBottle() {
        return this.bottle;
    }

    public void setBottle(@Nullable Item bottle) {
        this.bottle = bottle;
    }

    public float getRadius() {
        return ((Float)this.f_19804_.m_135370_(DATA_RADIUS)).floatValue();
    }

    public void setRadius(float radius) {
        if (!this.m_9236_().f_46443_) {
            this.f_19804_.m_135381_(DATA_RADIUS, (Object)Float.valueOf(Mth.m_14036_((float)radius, (float)0.5f, (float)32.0f)));
        }
    }

    public ParticleOptions getParticle() {
        return (ParticleOptions)this.f_19804_.m_135370_(DATA_PARTICLE);
    }

    public void setParticle(ParticleOptions particle) {
        if (!this.m_9236_().f_46443_) {
            this.f_19804_.m_135381_(DATA_PARTICLE, (Object)particle);
        }
    }

    public boolean isWaiting() {
        return (Boolean)this.f_19804_.m_135370_(DATA_WAITING);
    }

    public void setWaiting(boolean waiting) {
        if (!this.m_9236_().f_46443_) {
            this.f_19804_.m_135381_(DATA_WAITING, (Object)waiting);
        }
    }

    public float getDensity() {
        return this.density;
    }

    public void setDensity(float density) {
        this.density = density;
    }

    public int getParticleCount() {
        return (int)(this.getDensity() * this.getRadius());
    }

    public float getParticleSpeed() {
        return this.particleSpeed;
    }

    public void setParticleSpeed(float particleSpeed) {
        this.particleSpeed = particleSpeed;
    }

    public boolean isAffectOwner() {
        return this.affectOwner;
    }

    public void setAffectOwner(boolean affectOwner) {
        this.affectOwner = affectOwner;
    }

    @Nullable
    public LivingEntity getOwner() {
        Entity entity;
        if (this.owner == null && this.ownerUUID != null && this.m_9236_() instanceof ServerLevel && (entity = ((ServerLevel)this.m_9236_()).m_8791_(this.ownerUUID)) instanceof LivingEntity) {
            this.owner = (LivingEntity)entity;
        }
        return this.owner;
    }

    public void setOwner(@Nullable LivingEntity owner) {
        this.owner = owner;
        this.ownerUUID = owner != null ? owner.m_20148_() : null;
    }

    protected void m_7378_(CompoundTag tag) {
        this.setRadius(tag.m_128457_("Radius"));
        this.setDuration(tag.m_128451_("Duration"));
        this.setDebugMode(tag.m_128471_("DebugMode"));
        this.setAffectOwner(tag.m_128471_("AffectOwner"));
        if (tag.m_128425_("Particle", 8)) {
            try {
                ParticleOptions particle = ParticleArgument.m_247456_((StringReader)new StringReader(tag.m_128461_("Particle")), (HolderLookup)BuiltInRegistries.f_257034_.m_255303_());
                this.setParticle(particle);
            }
            catch (CommandSyntaxException e) {
                LOGGER.error("Failed to parse particle type: {}", (Object)tag.m_128461_("Particle"), (Object)e);
                this.setParticle(DEFAULT_PARTICLE);
            }
        }
        if (tag.m_128403_("Owner")) {
            this.ownerUUID = tag.m_128342_("Owner");
        }
    }

    protected void m_7380_(CompoundTag tag) {
        tag.m_128350_("Radius", this.getRadius());
        tag.m_128405_("Duration", this.getDuration());
        tag.m_128359_("Particle", this.getParticle().m_5942_());
        tag.m_128379_("DebugMode", this.isDebugMode());
        tag.m_128379_("AffectOwner", this.isAffectOwner());
        if (this.ownerUUID != null) {
            tag.m_128362_("Owner", this.ownerUUID);
        }
    }

    public PushReaction m_7752_() {
        return PushReaction.IGNORE;
    }

    public EntityDimensions m_6972_(Pose pose) {
        return EntityDimensions.m_20395_((float)(this.getRadius() * 2.0f), (float)0.5f);
    }

    public void m_6210_() {
        double x = this.m_20185_();
        double y = this.m_20186_();
        double z = this.m_20189_();
        super.m_6210_();
        this.m_6034_(x, y, z);
    }

    public void m_7350_(EntityDataAccessor<?> key) {
        if (DATA_RADIUS.equals(key)) {
            this.m_6210_();
        }
        super.m_7350_(key);
    }

    public void setLifetimeSeconds(float seconds) {
        this.setDuration((int)(seconds * 20.0f));
    }

    public void setLifetimeMinutes(float minutes) {
        this.setDuration((int)(minutes * 1200.0f));
    }
}

