/*
 * Decompiled with CFR 0.152.
 */
package net.svisvi.jigsawpp.entity.emitters;

import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.svisvi.jigsawpp.entity.emitters.GasEmitterEntity;
import net.svisvi.jigsawpp.entity.init.ModEntities;
import net.svisvi.jigsawpp.gas.AbstractGasClass;
import net.svisvi.jigsawpp.gas.BrownHoleGasClass;
import net.svisvi.jigsawpp.particles.ModParticleTypes;
import net.svisvi.jigsawpp.procedures.ut.NuclearShroom;

public class BrownHoleGasEmitterEntity
extends GasEmitterEntity {
    public static final AbstractGasClass DEFAULT_GAS = new BrownHoleGasClass();
    public AbstractGasClass gas = DEFAULT_GAS;
    private static final float DEFAULT_RADIUS = 2.5f;
    private static final int DEFAULT_DURATION = 6000;

    public BrownHoleGasEmitterEntity(EntityType<? extends BrownHoleGasEmitterEntity> type, Level level, ParticleOptions particleOptions, float radiuss, int durra, AbstractGasClass gassy) {
        super((EntityType<? extends GasEmitterEntity>)type, level);
        this.f_19794_ = true;
        this.setParticle(gassy.getParticle());
        this.setRadius(radiuss);
        this.setDuration(durra);
        this.setGas(gassy);
        this.setDebugMode(false);
    }

    @Override
    public float getDensity() {
        return 50.0f;
    }

    public BrownHoleGasEmitterEntity(EntityType<? extends BrownHoleGasEmitterEntity> type, Level level) {
        this(type, level, BrownHoleGasEmitterEntity.DEFAULT_GAS.particle, 2.5f, 6000, DEFAULT_GAS);
    }

    public BrownHoleGasEmitterEntity(Level level, double x, double y, double z) {
        this(level, x, y, z, BrownHoleGasEmitterEntity.DEFAULT_GAS.particle, 2.5f, 6000, DEFAULT_GAS);
    }

    public BrownHoleGasEmitterEntity(Level level, double x, double y, double z, ParticleOptions particleOptions, float radiuss, int durra, AbstractGasClass gassy) {
        this((EntityType<? extends BrownHoleGasEmitterEntity>)((EntityType)ModEntities.BROWNHOLE_GAS_EMITTER.get()), level, particleOptions, radiuss, durra, gassy);
        this.m_6034_(x, y, z);
    }

    public BrownHoleGasEmitterEntity(Level level, double x, double y, double z, float radiuss, int durra, AbstractGasClass gassy) {
        this(level, x, y, z, gassy.getParticle(), radiuss, durra, gassy);
    }

    public BrownHoleGasEmitterEntity(Level level, double x, double y, double z, float radiuss, int durra) {
        this(level, x, y, z, DEFAULT_GAS.getParticle(), radiuss, durra, DEFAULT_GAS);
    }

    @Override
    public void setGas(AbstractGasClass gas) {
        this.gas = gas;
    }

    @Override
    public AbstractGasClass getGas() {
        return this.gas;
    }

    @Override
    public ParticleOptions getParticle() {
        return this.getGas().getParticle();
    }

    @Override
    public void spawnParticles(int count, float speed) {
        super.spawnParticles(count, speed);
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            NuclearShroom.sendFarParticles(serverLevel, (ParticleOptions)ModParticleTypes.POOP_CLOUD.get(), this.m_20185_(), this.m_20186_(), this.m_20189_(), 1.0, 1.0, 1.0, 200, 0.0);
            NuclearShroom.sendFarParticles(serverLevel, (ParticleOptions)ModParticleTypes.POOP_BUBBLE.get(), this.m_20185_(), this.m_20186_(), this.m_20189_(), 1.5, 1.5, 1.5, 200, 0.0);
        }
    }

    @Override
    public void effectForEach(LivingEntity entity) {
        super.effectForEach(entity);
        AbstractGasClass gass = this.getGas();
        if (gass.gasApplyCondition((Entity)entity)) {
            gass.gasApplyEffect((Entity)entity);
        }
    }
}

