/*
 * Decompiled with CFR 0.152.
 */
package net.svisvi.jigsawpp.entity.emitters;

import java.util.Random;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.ItemSupplier;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.PlayMessages;
import net.minecraftforge.registries.ForgeRegistries;
import net.svisvi.jigsawpp.entity.emitters.AbstractEmitterEntity;
import net.svisvi.jigsawpp.entity.init.ModEntities;

@OnlyIn(value=Dist.CLIENT, _interface=ItemSupplier.class)
public class EmitterProjectile
extends AbstractArrow
implements ItemSupplier {
    public AbstractEmitterEntity emitter;
    public float radius = 1.0f;
    public int maxLifeTime = 200;

    public void setMaxLifeTime(int maxLifeTime) {
        this.maxLifeTime = maxLifeTime;
    }

    public int getMaxLifeTime() {
        return this.maxLifeTime;
    }

    public int getRemainingTime() {
        return this.getMaxLifeTime() - this.f_19797_;
    }

    public EmitterProjectile(PlayMessages.SpawnEntity packet, Level world) {
        super((EntityType)ModEntities.EMITTER_PROJECTILE.get(), world);
    }

    public EmitterProjectile(EntityType<? extends EmitterProjectile> type, Level world) {
        super(type, world);
    }

    public EmitterProjectile(EntityType<? extends EmitterProjectile> type, double x, double y, double z, Level world) {
        super(type, x, y, z, world);
    }

    public EmitterProjectile(EntityType<? extends EmitterProjectile> type, LivingEntity entity, Level world) {
        super(type, entity, world);
    }

    public AbstractEmitterEntity getEmitter() {
        return this.emitter;
    }

    public void setEmitter(AbstractEmitterEntity hemitter) {
        hemitter.setDebugMode(true);
        hemitter.setAffectOwner(false);
        hemitter.setRadius(this.getRadius());
        hemitter.setDuration(400);
        Entity entity = this.m_19749_();
        if (entity instanceof LivingEntity) {
            LivingEntity le = (LivingEntity)entity;
            hemitter.setOwner(le);
        }
        this.emitter = hemitter;
    }

    public void setEmitter(AbstractEmitterEntity hemitter, boolean defaultSetup) {
        if (defaultSetup) {
            this.setEmitter(hemitter);
        } else {
            this.emitter = hemitter;
        }
    }

    public float getRadius() {
        return this.radius;
    }

    public void setRadius(float radius) {
        this.radius = radius;
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return super.m_5654_();
    }

    @OnlyIn(value=Dist.CLIENT)
    public ItemStack m_7846_() {
        return new ItemStack((ItemLike)Items.f_41852_);
    }

    protected ItemStack m_7941_() {
        return new ItemStack((ItemLike)Items.f_41852_);
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.getRemainingTime() <= 0) {
            this.die();
        }
        if (this.getEmitter() != null) {
            this.getEmitter().m_6034_(this.m_20185_(), this.m_20186_(), this.m_20189_());
            this.getEmitter().m_8119_();
        }
        if (this.f_36703_) {
            this.die();
        }
    }

    public void die() {
        this.m_146870_();
    }

    public static EmitterProjectile shoot(Level world, LivingEntity entity, Random random, float power, double damage, int knockback) {
        EmitterProjectile entityarrow = new EmitterProjectile((EntityType<? extends EmitterProjectile>)((EntityType)ModEntities.EMITTER_PROJECTILE.get()), entity, world);
        entityarrow.m_6686_(entity.m_20252_((float)1.0f).f_82479_, entity.m_20252_((float)1.0f).f_82480_, entity.m_20252_((float)1.0f).f_82481_, power * 2.0f, 0.0f);
        entityarrow.m_20225_(true);
        entityarrow.m_36762_(false);
        entityarrow.m_36781_(damage);
        entityarrow.m_36735_(knockback);
        world.m_7967_((Entity)entityarrow);
        world.m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("entity.ghast.shoot")), SoundSource.PLAYERS, 1.0f, 1.0f / (random.nextFloat() * 0.5f + 1.0f) + power / 2.0f);
        return entityarrow;
    }

    public static EmitterProjectile shoot(LivingEntity entity, LivingEntity target) {
        EmitterProjectile entityarrow = new EmitterProjectile((EntityType<? extends EmitterProjectile>)((EntityType)ModEntities.EMITTER_PROJECTILE.get()), entity, entity.m_9236_());
        double dx = target.m_20185_() - entity.m_20185_();
        double dy = target.m_20186_() + (double)target.m_20192_() - 1.1;
        double dz = target.m_20189_() - entity.m_20189_();
        entityarrow.m_6686_(dx, dy - entityarrow.m_20186_() + Math.hypot(dx, dz) * (double)0.2f, dz, 1.0f, 12.0f);
        entityarrow.m_20225_(true);
        entityarrow.m_36781_(1.0);
        entityarrow.m_36735_(1);
        entityarrow.m_36762_(false);
        entity.m_9236_().m_7967_((Entity)entityarrow);
        entity.m_9236_().m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("entity.ghast.shoot")), SoundSource.PLAYERS, 1.0f, 1.0f / (new Random().nextFloat() * 0.5f + 1.0f));
        return entityarrow;
    }

    public static EmitterProjectile shoot(Level world, LivingEntity entity, Random random, float power, double damage, int knockback, AbstractEmitterEntity emit, boolean default_emitter) {
        EmitterProjectile pr = EmitterProjectile.shoot(world, entity, random, power, damage, knockback);
        pr.setEmitter(emit, default_emitter);
        return pr;
    }
}

