/*
 * Decompiled with CFR 0.152.
 */
package net.svisvi.jigsawpp.entity.emitters;

import java.util.Arrays;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.svisvi.jigsawpp.entity.emitters.AbstractEmitterEntity;
import net.svisvi.jigsawpp.entity.init.ModEntities;
import net.svisvi.jigsawpp.gas.AbstractGasClass;
import net.svisvi.jigsawpp.gas.EffectGasClass;
import org.jetbrains.annotations.Nullable;

public class GasEmitterEntity
extends AbstractEmitterEntity {
    public static final AbstractGasClass DEFAULT_GAS = new EffectGasClass(Arrays.asList(new MobEffectInstance(MobEffects.f_19607_, 60, 0)));
    public AbstractGasClass gas = DEFAULT_GAS;
    private static final float DEFAULT_RADIUS = 2.5f;
    private static final int DEFAULT_DURATION = 6000;

    public GasEmitterEntity(EntityType<? extends GasEmitterEntity> type, Level level, ParticleOptions particleOptions, float radiuss, int durra, AbstractGasClass gassy) {
        super(type, level);
        this.f_19794_ = true;
        this.setParticle(gassy.getParticle());
        this.setRadius(radiuss);
        this.setDuration(durra);
        this.setGas(gassy);
        this.setDebugMode(false);
    }

    public GasEmitterEntity(EntityType<? extends GasEmitterEntity> type, Level level) {
        this(type, level, GasEmitterEntity.DEFAULT_GAS.particle, 2.5f, 6000, DEFAULT_GAS);
    }

    public GasEmitterEntity(Level level, double x, double y, double z) {
        this(level, x, y, z, GasEmitterEntity.DEFAULT_GAS.particle, 2.5f, 6000, DEFAULT_GAS);
    }

    public GasEmitterEntity(Level level, double x, double y, double z, ParticleOptions particleOptions, float radiuss, int durra, AbstractGasClass gassy) {
        this((EntityType<? extends GasEmitterEntity>)((EntityType)ModEntities.GAS_EMITTER.get()), level, particleOptions, radiuss, durra, gassy);
        this.m_6034_(x, y, z);
    }

    public GasEmitterEntity(Level level, double x, double y, double z, float radiuss, int durra, AbstractGasClass gassy) {
        this(level, x, y, z, gassy.getParticle(), radiuss, durra, gassy);
    }

    public GasEmitterEntity(Level level, double x, double y, double z, float radiuss, int durra) {
        this(level, x, y, z, DEFAULT_GAS.getParticle(), radiuss, durra, DEFAULT_GAS);
    }

    public void setGas(AbstractGasClass gas) {
        this.gas = gas;
    }

    public AbstractGasClass getGas() {
        return this.gas;
    }

    @Override
    public ParticleOptions getParticle() {
        return this.getGas().getParticle();
    }

    @Override
    public void effectForEach(LivingEntity entity) {
        super.effectForEach(entity);
        AbstractGasClass gass = this.getGas();
        if (gass.gasApplyCondition((Entity)entity)) {
            gass.gasApplyEffect((Entity)entity);
        }
    }

    @Override
    public void setOwner(@Nullable LivingEntity owner) {
        this.getGas().setOwner(owner);
        super.setOwner(owner);
    }
}

