/*
 * Decompiled with CFR 0.152.
 */
package net.svisvi.jigsawpp.entity.gentleman;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.BossEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PlayMessages;
import net.minecraftforge.registries.ForgeRegistries;
import net.svisvi.jigsawpp.entity.emitters.BrownHoleGasEmitterEntity;
import net.svisvi.jigsawpp.entity.emitters.PoopGasEmitterEntity;
import net.svisvi.jigsawpp.entity.gentleman.GentleManGoals;
import net.svisvi.jigsawpp.entity.init.ModEntities;
import net.svisvi.jigsawpp.gamerules.ModGameRules;

public class GentleManEntity
extends Monster {
    protected byte phase = 1;
    public static final Component spawnTntAtPlayerComponent = Component.m_237115_((String)"entity.gentleman.chat.spawntnt");
    public static final Component shootPurgenPiluleComponent = Component.m_237115_((String)"entity.gentleman.chat.pilule_shoot");
    public static final Component purgenManSummonComponent = Component.m_237115_((String)"entity.gentleman.chat.phase1");
    public static final Component purgenmanphase2component = Component.m_237115_((String)"entity.gentleman.chat.phase2");
    public static final Component purgenmanphase3component = Component.m_237115_((String)"entity.gentleman.chat.phase3");
    public static final Component purgenmanDeathcomponent = Component.m_237115_((String)"entity.gentleman.chat.death");
    private final ServerBossEvent bossEvent = new ServerBossEvent(this.m_5446_(), BossEvent.BossBarColor.RED, BossEvent.BossBarOverlay.NOTCHED_10);

    public GentleManEntity(PlayMessages.SpawnEntity packet, Level world) {
        this((EntityType<? extends Monster>)((EntityType)ModEntities.GENTLEMAN.get()), world);
    }

    public GentleManEntity(EntityType<? extends Monster> type, Level world) {
        super(type, world);
        this.f_21364_ = 10;
        this.m_21557_(false);
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public MobType m_6336_() {
        return MobType.f_21640_;
    }

    public void m_7355_(BlockPos pos, BlockState blockIn) {
        this.m_5496_((SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("entity.ravager.step")), 0.15f, 1.0f);
    }

    public SoundEvent m_5592_() {
        return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("entity.ravager.death"));
    }

    public void onAddedToWorld() {
        MinecraftServer server;
        super.onAddedToWorld();
        if (!this.m_9236_().m_5776_() && (server = this.m_9236_().m_7654_()) != null) {
            server.m_6846_().m_240416_(purgenManSummonComponent, false);
        }
    }

    public boolean m_6469_(DamageSource source, float amount) {
        return super.m_6469_(source, amount);
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Mob.m_21552_();
        builder = builder.m_22268_(Attributes.f_22279_, 0.7);
        builder = builder.m_22268_(Attributes.f_22276_, 300.0);
        builder = builder.m_22268_(Attributes.f_22284_, 25.0);
        builder = builder.m_22268_(Attributes.f_22281_, 10.0);
        builder = builder.m_22268_(Attributes.f_22277_, 32.0);
        builder = builder.m_22268_(Attributes.f_22278_, 0.4);
        builder = builder.m_22268_(Attributes.f_22282_, 1.5);
        return builder;
    }

    public void m_6667_(DamageSource pDamageSource) {
        super.m_6667_(pDamageSource);
        if (!this.m_9236_().m_5776_()) {
            ((GameRules.BooleanValue)this.m_9236_().m_46469_().m_46170_(ModGameRules.APOOCALYPSE)).m_46246_(true, this.m_9236_().m_7654_());
            double radius = 15.0 + this.f_19796_.m_188500_() * 10.0;
            double angle = this.f_19796_.m_188500_() * Math.PI * 2.0;
            double randomX = this.m_20185_() + radius * Math.cos(angle);
            double randomZ = this.m_20189_() + radius * Math.sin(angle);
            double randomY = this.m_9236_().m_6924_(Heightmap.Types.MOTION_BLOCKING, (int)Math.floor(randomX), (int)Math.floor(randomZ));
            BrownHoleGasEmitterEntity bHGasEmitter = new BrownHoleGasEmitterEntity(this.m_9236_(), randomX, randomY, randomZ, 2.0f, 32400);
            this.m_9236_().m_7967_((Entity)bHGasEmitter);
            MinecraftServer server = this.m_9236_().m_7654_();
            if (server != null) {
                server.m_6846_().m_240416_(purgenmanDeathcomponent, false);
            }
        }
    }

    public CompoundTag serializeNBT() {
        CompoundTag pCompoundTag = new CompoundTag();
        return pCompoundTag;
    }

    public void m_8024_() {
        super.m_8024_();
        this.bossEvent.m_142711_(this.m_21223_() / this.m_21233_());
    }

    public void m_6593_(@Nullable Component name) {
        super.m_6593_(name);
        this.bossEvent.m_6456_(this.m_5446_());
    }

    public void m_6457_(ServerPlayer player) {
        super.m_6457_(player);
        this.bossEvent.m_6543_(player);
    }

    public void m_6452_(ServerPlayer player) {
        super.m_6452_(player);
        this.bossEvent.m_6539_(player);
    }

    public void m_7380_(CompoundTag pCompoundTag) {
        super.m_7380_(pCompoundTag);
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
    }

    public boolean m_6573_(Player pPlayer) {
        return !this.m_21523_();
    }

    public Vec3 m_7939_() {
        return new Vec3(0.0, (double)(0.6f * this.m_20192_()) - 0.35, (double)(this.m_20205_() * 0.4f) - 0.2);
    }

    protected double m_5823_() {
        return 1.5;
    }

    public byte getPhase() {
        return this.phase;
    }

    public void setPhase(byte pPhase) {
        this.phase = pPhase;
    }

    private void shoot(LivingEntity pEntity, Level pLevel, Projectile pProjectile, float pVelocity, float pInaccuracy) {
        if (!this.m_9236_().m_5776_()) {
            pProjectile.m_37251_((Entity)pEntity, pEntity.m_146909_(), pEntity.m_146908_(), 0.0f, pVelocity, pInaccuracy);
            this.m_9236_().m_7967_((Entity)pProjectile);
        }
    }

    protected void m_8099_() {
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]){

            public boolean m_8036_() {
                return super.m_8036_();
            }
        });
        this.f_21345_.m_25352_(3, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(4, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 100.0f));
        this.f_21345_.m_25352_(5, (Goal)new GentleManGoals.FirstGentlemanPhase((PathfinderMob)this, 0.7, true, 1));
        this.f_21345_.m_25352_(5, (Goal)new GentleManGoals.SecondGentlemanPhase((PathfinderMob)this, 0.999999999, true, 2));
        this.f_21345_.m_25352_(5, (Goal)new GentleManGoals.ThirdGentlemanPhase((PathfinderMob)this, 0.7, true, 3));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.m_21223_() < this.m_21233_() / 1.5f && this.phase < 2) {
            this.phase = (byte)2;
            MinecraftServer server = this.m_9236_().m_7654_();
            if (server != null) {
                server.m_6846_().m_240416_(purgenmanphase2component, false);
            }
        } else if (this.m_21223_() < this.m_21233_() / 3.0f && this.phase < 3) {
            this.phase = (byte)3;
            MinecraftServer server = this.m_9236_().m_7654_();
            if (server != null) {
                server.m_6846_().m_240416_(purgenmanphase3component, false);
            }
        }
        if (this.m_5448_() != null && this.isInFluidType()) {
            if (!this.m_9236_().m_5776_()) {
                this.m_9236_().m_7967_((Entity)new PoopGasEmitterEntity(this.m_9236_(), this.m_20185_(), this.m_20186_(), this.m_20189_(), 2.0f, 60));
            }
            this.m_6021_(this.m_5448_().m_20185_(), this.m_5448_().m_20186_() + 0.5, this.m_5448_().m_20189_());
        }
    }
}

