/*
 * Decompiled with CFR 0.152.
 */
package net.svisvi.jigsawpp.entity.gentleman;

import java.util.EnumSet;
import java.util.List;
import java.util.Random;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import net.svisvi.jigsawpp.entity.drist_tnt.PrimedDristTnt;
import net.svisvi.jigsawpp.entity.emitters.FartGasEmitterEntity;
import net.svisvi.jigsawpp.entity.emitters.PoopGasEmitterEntity;
import net.svisvi.jigsawpp.entity.gentleman.GentleManEntity;
import net.svisvi.jigsawpp.entity.projectile.PurgenPiluleProjectile;
import net.svisvi.jigsawpp.entity.projectile.granadeProjectiles.AbstractGrenadeProjectile;
import net.svisvi.jigsawpp.entity.projectile.granadeProjectiles.GassyGrenadeProjectile;
import net.svisvi.jigsawpp.entity.projectile.granadeProjectiles.PonosGrenadeProjectile;
import net.svisvi.jigsawpp.entity.projectile.granadeProjectiles.PurgenGrenadeProjectile;
import net.svisvi.jigsawpp.item.init.ModItems;

public class GentleManGoals {

    public static class ThirdGentlemanPhase
    extends AbstractGentlemanPhase {
        private int gassyAttackCouldown = 0;

        public ThirdGentlemanPhase(PathfinderMob pMob, double pSpeedModifier, boolean pFollowingTargetEvenIfNotSeen, byte pCanUsePhase) {
            super(pMob, pSpeedModifier, pFollowingTargetEvenIfNotSeen, pCanUsePhase);
        }

        protected void m_6739_(LivingEntity pEnemy, double pDistToEnemySqr) {
            if (this.gassyAttackCouldown % 60 == 0 && this.gentleman.m_9236_().m_45930_((Entity)this.gentleman, 3.0) != null) {
                this.gassyAttackCouldown = 0;
                this.gentlemanGassy(this.gentleman.m_9236_(), (LivingEntity)this.gentleman);
            } else {
                ++this.gassyAttackCouldown;
            }
            if (random.nextDouble() <= 0.2) {
                this.spawnGrenades(5);
            }
            if (random.nextDouble() <= 0.1) {
                for (int i = 0; i <= 5; ++i) {
                    this.spawnTntAtPlayerPosition(pEnemy);
                }
            }
            if (random.nextDouble() <= 0.05) {
                this.teleportToTarget();
            }
        }
    }

    public static class SecondGentlemanPhase
    extends AbstractGentlemanPhase {
        private int gassyAttackCouldown = 0;

        public SecondGentlemanPhase(PathfinderMob pMob, double pSpeedModifier, boolean pFollowingTargetEvenIfNotSeen, byte pCanUsePhase) {
            super(pMob, pSpeedModifier, pFollowingTargetEvenIfNotSeen, pCanUsePhase);
        }

        protected void m_6739_(LivingEntity pEnemy, double pDistToEnemySqr) {
            if (this.gentleman.m_21120_(InteractionHand.MAIN_HAND) != new ItemStack((ItemLike)ModItems.BEAVER_KNIFE.get())) {
                this.gentleman.m_21008_(InteractionHand.MAIN_HAND, new ItemStack((ItemLike)ModItems.BEAVER_KNIFE.get()));
            }
            super.m_6739_(pEnemy, pDistToEnemySqr);
            if (this.gassyAttackCouldown % 60 == 0 && this.gentleman.m_9236_().m_45930_((Entity)this.gentleman, 3.0) != null) {
                this.gassyAttackCouldown = 0;
                this.gentlemanGassy(this.gentleman.m_9236_(), (LivingEntity)this.gentleman);
            } else {
                ++this.gassyAttackCouldown;
            }
            if (random.nextDouble() <= 0.005 && !this.gentleman.m_9236_().m_5776_()) {
                MinecraftServer server;
                if (!this.gentleman.m_9236_().m_5776_() && (server = this.gentleman.m_9236_().m_7654_()) != null) {
                    server.m_6846_().m_240416_(GentleManEntity.shootPurgenPiluleComponent, false);
                }
                PurgenPiluleProjectile bombr = new PurgenPiluleProjectile(this.gentleman.m_9236_());
                bombr.setArmor_piercing(true);
                PurgenPiluleProjectile.shoot(this.gentleman.m_9236_(), (LivingEntity)this.gentleman, 4.5f, 0.0f, new ItemStack((ItemLike)ModItems.CRYSTAL_PURGEN_PILULE.get()));
            }
            if (random.nextDouble() <= 0.01) {
                this.spawnGrenades(5);
            }
            if (random.nextDouble() <= 0.007) {
                this.spawnTntAtPlayerPosition(pEnemy);
            }
            if (random.nextDouble() <= 0.05) {
                this.teleportToTarget();
            }
        }
    }

    public static class FirstGentlemanPhase
    extends AbstractGentlemanPhase {
        private int gassyAttackCouldown = 0;

        public FirstGentlemanPhase(PathfinderMob pMob, double pSpeedModifier, boolean pFollowingTargetEvenIfNotSeen, byte pCanUsePhase) {
            super(pMob, pSpeedModifier, pFollowingTargetEvenIfNotSeen, pCanUsePhase);
        }

        protected void m_6739_(LivingEntity pEnemy, double pDistToEnemySqr) {
            super.m_6739_(pEnemy, pDistToEnemySqr);
            if (this.gassyAttackCouldown % 60 == 0 && this.gentleman.m_9236_().m_45930_((Entity)this.gentleman, 3.0) != null) {
                this.gassyAttackCouldown = 0;
                this.gentlemanGassy(this.gentleman.m_9236_(), (LivingEntity)this.gentleman);
            } else {
                ++this.gassyAttackCouldown;
            }
            if (random.nextDouble() <= 0.05) {
                this.teleportToTarget();
            }
        }
    }

    public static abstract class AbstractGentlemanPhase
    extends MeleeAttackGoal {
        protected final GentleManEntity gentleman;
        protected byte canUsePhase;
        protected static final Random random = new Random();
        protected static int ticksTillNextMagicNumber;
        protected static Component phaseComponent;
        protected static boolean ifPhaseComponentWasUsed;

        public AbstractGentlemanPhase(PathfinderMob pMob, double pSpeedModifier, boolean pFollowingTargetEvenIfNotSeen, byte pCanUsePhase) {
            super(pMob, pSpeedModifier, pFollowingTargetEvenIfNotSeen);
            this.gentleman = (GentleManEntity)pMob;
            this.m_7021_(EnumSet.of(Goal.Flag.LOOK));
            this.canUsePhase = pCanUsePhase;
        }

        public boolean m_8036_() {
            return this.getCanUsePhase() == this.gentleman.getPhase() && super.m_8036_();
        }

        public static void setPhaseComponent(Component phaseComponent) {
            AbstractGentlemanPhase.phaseComponent = phaseComponent;
        }

        public static Component getPhaseComponent() {
            return phaseComponent;
        }

        public void teleportToTarget() {
            LivingEntity target = this.gentleman.m_5448_();
            if (!this.gentleman.m_9236_().m_5776_()) {
                this.gentleman.m_9236_().m_7967_((Entity)new PoopGasEmitterEntity(this.gentleman.m_9236_(), this.gentleman.m_20185_(), this.gentleman.m_20186_(), this.gentleman.m_20189_(), 2.0f, 60));
            }
            if (target != null) {
                this.gentleman.m_6021_(target.m_20185_(), target.m_20186_() + 0.2, target.m_20189_());
            }
        }

        public byte getCanUsePhase() {
            return this.canUsePhase;
        }

        public void setCanUsePhase(byte pCanUsePhase) {
            this.canUsePhase = pCanUsePhase;
        }

        public void spawnGrenades(int maxThrowItemCount) {
            if (!this.gentleman.m_9236_().f_46443_) {
                for (int i = 0; i <= maxThrowItemCount; ++i) {
                    this.gentleman.m_5496_(SoundEvents.f_11798_, 1.0f, random.nextFloat(0.5f, 1.0f));
                    AbstractGrenadeProjectile grenade = this.getRandomGrenade(this.gentleman.m_9236_(), (LivingEntity)this.gentleman);
                    this.gentleman.m_21008_(InteractionHand.MAIN_HAND, new ItemStack((ItemLike)this.grenadeItem(grenade), 1));
                    grenade.m_6034_(this.gentleman.m_20185_(), this.gentleman.m_20188_() - 0.1, this.gentleman.m_20189_());
                    grenade.m_5602_((Entity)this.gentleman);
                    grenade.setAffectOwner(false);
                    grenade.setInstaboom(true);
                    double xVel = random.nextDouble(-1.0, 1.0) * 0.5;
                    double yVel = 0.5 + random.nextDouble() * 0.5;
                    double zVel = random.nextDouble(-1.0, 1.0) * 0.5;
                    grenade.m_20334_(xVel, yVel, zVel);
                    this.gentleman.m_6674_(InteractionHand.MAIN_HAND);
                    this.gentleman.m_9236_().m_7967_((Entity)grenade);
                }
            }
        }

        public void m_8037_() {
            super.m_8037_();
        }

        protected Item grenadeItem(AbstractGrenadeProjectile pGrenade) {
            Item gItem = null;
            if (pGrenade instanceof GassyGrenadeProjectile) {
                gItem = (Item)ModItems.GASSY_GRENADE.get();
            }
            if (pGrenade instanceof PurgenGrenadeProjectile) {
                gItem = (Item)ModItems.PURGEN_GRENADE.get();
            }
            if (pGrenade instanceof PonosGrenadeProjectile) {
                gItem = (Item)ModItems.PONOS_GRENADE.get();
            }
            return gItem;
        }

        protected AbstractGrenadeProjectile getRandomGrenade(Level pLevel, LivingEntity pLivingEntity) {
            return switch (random.nextInt(0, 3)) {
                case 0 -> new GassyGrenadeProjectile(pLevel, pLivingEntity);
                case 1 -> new PurgenGrenadeProjectile(pLevel, pLivingEntity);
                case 2 -> new PonosGrenadeProjectile(pLevel, pLivingEntity);
                default -> new PonosGrenadeProjectile(pLevel, pLivingEntity);
            };
        }

        protected void spawnTntAtPlayerPosition(LivingEntity pEnemy) {
            if (!this.gentleman.m_9236_().m_5776_()) {
                int radius = 30;
                AABB box = new AABB(this.gentleman.m_20185_() - (double)radius, this.gentleman.m_20186_() - (double)radius, this.gentleman.m_20189_() - (double)radius, this.gentleman.m_20185_() + (double)radius, this.gentleman.m_20186_() + (double)radius, this.gentleman.m_20189_() + (double)radius);
                List players = this.gentleman.m_9236_().m_45976_(Player.class, box);
                MinecraftServer server = this.gentleman.m_9236_().m_7654_();
                if (server != null && (double)this.gentleman.m_9236_().f_46441_.m_188501_() >= 0.7) {
                    server.m_6846_().m_240416_(GentleManEntity.spawnTntAtPlayerComponent, false);
                }
                for (Player player : players) {
                    PrimedDristTnt tnt = new PrimedDristTnt(this.gentleman.m_9236_(), player.m_20185_() + 0.5, player.m_20186_() + 0.5, player.m_20189_() + 0.5, (LivingEntity)this.gentleman);
                    tnt.setFuse(40);
                    this.gentleman.m_9236_().m_7967_((Entity)tnt);
                    this.gentleman.m_9236_().m_6263_((Player)null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_12512_, SoundSource.BLOCKS, 1.0f, 1.0f);
                    this.gentleman.m_9236_().m_142346_((Entity)this.gentleman, GameEvent.f_157776_, player.m_20183_());
                }
            }
        }

        protected void gentlemanGassy(Level pLevel, LivingEntity pEntity) {
            pEntity.m_5496_(SoundEvents.f_11833_, 1.0f, 1.0f);
            if (!pLevel.m_5776_()) {
                FartGasEmitterEntity gasEmitterEntity = new FartGasEmitterEntity(pLevel, pEntity.m_20185_(), pEntity.m_20186_(), pEntity.m_20189_(), 2.0f, 100);
                gasEmitterEntity.setOwner(pEntity);
                gasEmitterEntity.setAffectOwner(false);
                pLevel.m_7967_((Entity)gasEmitterEntity);
            }
        }
    }
}

