/*
 * Decompiled with CFR 0.152.
 */
package net.svisvi.jigsawpp.entity.moss_elephant;

import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Cow;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.ThrownPotion;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.registries.ForgeRegistries;
import net.svisvi.jigsawpp.entity.beaver_zombie.BeaverZombieEntity;
import net.svisvi.jigsawpp.entity.init.ModEntities;
import net.svisvi.jigsawpp.item.init.ModItems;
import net.svisvi.jigsawpp.recipe.ElephantingRecipe;

public class MossElephantEntity
extends Animal {
    public final AnimationState idleAnimationState = new AnimationState();
    private int idleAnimationTimeout = 0;
    private final ItemStackHandler itemHandler = new ItemStackHandler(2);
    private static final Set<ResourceLocation> SPAWN_BIOMES = Set.of(new ResourceLocation("beach"), new ResourceLocation("swamp"));
    private int craftingCooldown = 0;

    public MossElephantEntity(EntityType<? extends Animal> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    public static void init() {
        SpawnPlacements.m_21754_((EntityType)((EntityType)ModEntities.MOSS_ELEPHANT.get()), (SpawnPlacements.Type)SpawnPlacements.Type.NO_RESTRICTIONS, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Mob::m_217057_);
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.m_9236_().m_5776_()) {
            this.setupAnimationStates();
        }
    }

    private void setupAnimationStates() {
        if (this.idleAnimationTimeout <= 0) {
            this.idleAnimationTimeout = this.f_19796_.m_188503_(40) + 80;
            this.idleAnimationState.m_216977_(this.f_19797_);
        } else {
            --this.idleAnimationTimeout;
        }
    }

    protected void m_267689_(float pPartialTick) {
        super.m_267689_(pPartialTick);
        float f = this.m_20089_() == Pose.STANDING ? Math.min(pPartialTick * 6.0f, 1.0f) : 0.0f;
        this.f_267362_.m_267566_(f, 0.2f);
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new AvoidEntityGoal((PathfinderMob)this, Cow.class, 12.0f, 1.0, 1.2));
        this.f_21345_.m_25352_(1, (Goal)new AvoidEntityGoal((PathfinderMob)this, BeaverZombieEntity.class, 12.0f, 1.0, 1.2));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Animal.m_21183_().m_22268_(Attributes.f_22277_, 20.0).m_22268_(Attributes.f_22276_, 70.0).m_22268_(Attributes.f_22279_, 0.2).m_22268_(Attributes.f_22285_, (double)0.1f).m_22268_(Attributes.f_22282_, 0.5).m_22268_(Attributes.f_22281_, 0.0).m_22268_(Attributes.f_22278_, 1000.0);
    }

    public MobType m_6336_() {
        return MobType.f_21640_;
    }

    @Nullable
    public AgeableMob m_142606_(ServerLevel pLevel, AgeableMob pOtherPartner) {
        return null;
    }

    public SoundEvent m_7975_(DamageSource ds) {
        return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("block.moss.place"));
    }

    public SoundEvent m_5592_() {
        return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("block.moss.break"));
    }

    public boolean m_6469_(DamageSource damagesource, float amount) {
        if (damagesource.m_276093_(DamageTypes.f_268631_)) {
            return false;
        }
        if (damagesource.m_7640_() instanceof AbstractArrow) {
            return false;
        }
        if (damagesource.m_7640_() instanceof ThrownPotion || damagesource.m_7640_() instanceof AreaEffectCloud) {
            return false;
        }
        if (damagesource.m_276093_(DamageTypes.f_268671_)) {
            return false;
        }
        if (damagesource.m_276093_(DamageTypes.f_268585_)) {
            return false;
        }
        if (damagesource.m_276093_(DamageTypes.f_268722_)) {
            return false;
        }
        if (damagesource.m_276093_(DamageTypes.f_268450_)) {
            return false;
        }
        if (damagesource.m_276093_(DamageTypes.f_268565_)) {
            return false;
        }
        if (damagesource.m_276093_(DamageTypes.f_268714_)) {
            return false;
        }
        if (damagesource.m_276093_(DamageTypes.f_268526_)) {
            return false;
        }
        if (damagesource.m_276093_(DamageTypes.f_268482_)) {
            return false;
        }
        if (damagesource.m_276093_(DamageTypes.f_268493_)) {
            return false;
        }
        if (damagesource.m_276093_(DamageTypes.f_268641_)) {
            return false;
        }
        return super.m_6469_(damagesource, amount);
    }

    public boolean m_7337_(Entity entity) {
        return true;
    }

    public boolean m_5829_() {
        return true;
    }

    public boolean m_6094_() {
        return false;
    }

    protected void m_7324_(Entity entityIn) {
    }

    protected void m_6138_() {
    }

    public void m_6075_() {
        super.m_6075_();
        MossElephantEntity.fear((LevelAccessor)this.m_9236_(), this.m_20185_(), this.m_20186_(), this.m_20189_(), (Entity)this);
        if (this.craftingCooldown < 80) {
            ++this.craftingCooldown;
        }
    }

    public static void fear(LevelAccessor world, double x, double y, double z, Entity entity) {
        if (entity == null) {
            return;
        }
        if (entity.m_20184_().m_7096_() > 1.0E-4 | entity.m_20184_().m_7094_() > 1.0E-4 && Math.random() <= 0.05) {
            Level _level;
            if (world instanceof Level && !(_level = (Level)world).m_5776_()) {
                ItemEntity entityToSpawn = new ItemEntity(_level, x, y, z, new ItemStack((ItemLike)ModItems.SWEET_BREAD.get()));
                entityToSpawn.m_32010_(10);
                _level.m_7967_((Entity)entityToSpawn);
            }
            if (world instanceof Level) {
                _level = (Level)world;
                if (!_level.m_5776_()) {
                    _level.m_5594_(null, new BlockPos((int)x, (int)y, (int)z), (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("entity.cow.milk")), SoundSource.NEUTRAL, 1.0f, 1.0f);
                } else {
                    _level.m_7785_(x, y, z, (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("entity.cow.milk")), SoundSource.NEUTRAL, 1.0f, 1.0f, false);
                }
            }
        }
    }

    public InteractionResult m_6071_(Player sourceentity, InteractionHand hand) {
        ItemStack itemstack = sourceentity.m_21120_(hand);
        InteractionResult retval = InteractionResult.m_19078_((boolean)this.m_9236_().m_5776_());
        super.m_6071_(sourceentity, hand);
        double x = this.m_20185_();
        double y = this.m_20186_();
        double z = this.m_20189_();
        MossElephantEntity entity = this;
        Level world = this.m_9236_();
        if (this.craftingCooldown == 80) {
            this.craftingCooldown = 0;
            if (this.hasRecipe(itemstack)) {
                ServerLevel _level;
                if (world instanceof ServerLevel && !(_level = (ServerLevel)world).m_5776_()) {
                    ItemStack res = this.craftItem(itemstack);
                    ItemEntity entityToSpawn = new ItemEntity((Level)_level, x, y + (double)2.8f, z, res);
                    entityToSpawn.m_32010_(10);
                    _level.m_7967_((Entity)entityToSpawn);
                    _level.m_8767_((ParticleOptions)ParticleTypes.f_123748_, x, y, z, 50, 2.0, 2.0, 2.0, 0.0);
                    itemstack.m_41774_(1);
                }
                if (world instanceof ServerLevel) {
                    _level = (ServerLevel)world;
                    if (!_level.m_5776_()) {
                        _level.m_5594_(null, BlockPos.m_274561_((double)x, (double)y, (double)z), (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("jigsaw_pp:moss_elephant_proot")), SoundSource.NEUTRAL, 1.0f, -1.0f);
                    } else {
                        _level.m_7785_(x, y, z, (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("jigsaw_pp:moss_elephant_proot")), SoundSource.NEUTRAL, 1.0f, -1.0f, false);
                    }
                }
            } else {
                ServerLevel _level;
                if (world instanceof ServerLevel && !(_level = (ServerLevel)world).m_5776_()) {
                    _level.m_8767_((ParticleOptions)ParticleTypes.f_123792_, x, y, z, 50, 2.0, 2.0, 2.0, 0.0);
                }
                if (world instanceof ServerLevel) {
                    _level = (ServerLevel)world;
                    if (!_level.m_5776_()) {
                        _level.m_5594_(null, BlockPos.m_274561_((double)x, (double)y, (double)z), (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("jigsaw_pp:moss_elephant_angry_proot")), SoundSource.NEUTRAL, 1.0f, -1.0f);
                    } else {
                        _level.m_7785_(x, y, z, (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("jigsaw_pp:moss_elephant_angry_proot")), SoundSource.NEUTRAL, 1.0f, -1.0f, false);
                    }
                }
            }
        }
        return retval;
    }

    private Optional<ElephantingRecipe> getCurrentRecipe(ItemStack itemStack) {
        SimpleContainer inventory = new SimpleContainer(2);
        inventory.m_6836_(0, itemStack);
        return this.m_9236_().m_7465_().m_44015_((RecipeType)ElephantingRecipe.Type.INSTANCE, (Container)inventory, this.m_9236_());
    }

    private ItemStack craftItem(ItemStack itemStack) {
        Optional<ElephantingRecipe> recipe = this.getCurrentRecipe(itemStack);
        ItemStack result = recipe.get().m_8043_(null);
        return result;
    }

    private boolean hasRecipe(ItemStack itemStack) {
        Optional<ElephantingRecipe> recipe = this.getCurrentRecipe(itemStack);
        return !recipe.isEmpty();
    }
}

