/*
 * Decompiled with CFR 0.152.
 */
package net.svisvi.jigsawpp.entity.projectile;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.registries.ForgeRegistries;
import net.svisvi.jigsawpp.entity.init.ModEntities;
import net.svisvi.jigsawpp.item.armor.BeaverItem;
import net.svisvi.jigsawpp.item.init.ModItems;

public class BeaverBombProjectile
extends ThrowableItemProjectile {
    public boolean binding;

    public BeaverBombProjectile(EntityType<? extends ThrowableItemProjectile> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    public BeaverBombProjectile(Level pLevel, LivingEntity pShooter) {
        super((EntityType)ModEntities.BEAVER_BOMB.get(), pShooter, pLevel);
    }

    public BeaverBombProjectile(Level pLevel, double pX, double pY, double pZ) {
        super((EntityType)ModEntities.BEAVER_BOMB.get(), pX, pY, pZ, pLevel);
    }

    public void setBinding(boolean binding) {
        this.binding = binding;
    }

    public boolean isBinding() {
        return this.binding;
    }

    public BeaverBombProjectile(Level pLevel) {
        super((EntityType)ModEntities.BEAVER_BOMB.get(), pLevel);
    }

    public void m_7822_(byte pId) {
        if (pId == 3) {
            double d0 = 0.08;
            for (int i = 0; i < 8; ++i) {
                this.m_9236_().m_7106_((ParticleOptions)new ItemParticleOption(ParticleTypes.f_123752_, this.m_7846_()), this.m_20185_(), this.m_20186_(), this.m_20189_(), ((double)this.f_19796_.m_188501_() - 0.5) * 0.08, ((double)this.f_19796_.m_188501_() - 0.5) * 0.08, ((double)this.f_19796_.m_188501_() - 0.5) * 0.08);
            }
        }
    }

    protected void m_5790_(EntityHitResult pResult) {
        super.m_5790_(pResult);
    }

    protected Item m_7881_() {
        if (!this.binding) {
            return (Item)ModItems.BEAVER_BOMB.get();
        }
        return (Item)ModItems.BEAVER_BOMB.get();
    }

    protected void m_6532_(HitResult pResult) {
        super.m_6532_(pResult);
        this.realHit(this.m_9236_(), new BlockPos((int)pResult.m_82450_().f_82479_, (int)pResult.m_82450_().f_82480_, (int)pResult.m_82450_().f_82481_));
    }

    public static Projectile shootEnt(Level pLevel, LivingEntity pEntity, float pVelocity, float pInaccuracy) {
        if (!pLevel.f_46443_) {
            BeaverBombProjectile thrownegg = new BeaverBombProjectile(pLevel, pEntity);
            thrownegg.m_37251_((Entity)pEntity, pEntity.m_146909_(), pEntity.m_146908_(), 0.0f, pVelocity, pInaccuracy);
            pLevel.m_7967_((Entity)thrownegg);
            return thrownegg;
        }
        return null;
    }

    public static void beaverify(Level level, Entity entity, boolean binding) {
        BlockPos pos = entity.m_20097_();
        if (entity == null) {
            return;
        }
        ArrayList<EquipmentSlot> slotNames = new ArrayList<EquipmentSlot>(Arrays.asList(EquipmentSlot.FEET, EquipmentSlot.LEGS, EquipmentSlot.CHEST, EquipmentSlot.HEAD));
        ItemStack temp = ItemStack.f_41583_;
        ArrayList<Item> beaverArmor = new ArrayList<Item>(Arrays.asList((Item)ModItems.BEAVER_BOOTS.get(), (Item)ModItems.SLAVE_LEGGINGS.get(), (Item)ModItems.BEAVER_CHESTPLATE.get(), (Item)ModItems.BEAVER_HELMET.get()));
        for (int i = 0; i < 4; ++i) {
            ItemStack itemStack;
            if (entity instanceof LivingEntity) {
                LivingEntity _entGetArmor = (LivingEntity)entity;
                itemStack = _entGetArmor.m_6844_((EquipmentSlot)slotNames.get(i));
            } else {
                itemStack = ItemStack.f_41583_;
            }
            if (itemStack.m_41720_() instanceof BeaverItem || temp.getEnchantmentLevel(Enchantments.f_44975_) != 0) continue;
            ItemEntity entityToSpawn = new ItemEntity(level, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), temp);
            entityToSpawn.m_32010_(10);
            level.m_7967_((Entity)entityToSpawn);
            ItemStack newStack = ItemStack.f_41583_;
            if (i != 1) {
                newStack = new ItemStack((ItemLike)beaverArmor.get(i));
                if (binding) {
                    newStack.m_41663_(Enchantments.f_44975_, 1);
                }
            }
            if (entity instanceof Player) {
                Player _player = (Player)entity;
                _player.m_150109_().f_35975_.set(i, (Object)newStack);
                _player.m_150109_().m_6596_();
                continue;
            }
            if (!(entity instanceof LivingEntity)) continue;
            LivingEntity _living = (LivingEntity)entity;
            _living.m_8061_((EquipmentSlot)slotNames.get(i), newStack);
        }
    }

    public static void massBeaverify(Level level, BlockPos pos, boolean binding) {
        Vec3 _center = new Vec3((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_());
        List _entfound = level.m_6443_(Entity.class, new AABB(_center, _center).m_82400_(2.0), e -> true).stream().sorted(Comparator.comparingDouble(_entcnd -> _entcnd.m_20238_(_center))).collect(Collectors.toList());
        for (Entity entityiterator : _entfound) {
            BeaverBombProjectile.beaverify(level, entityiterator, binding);
        }
    }

    public void realHit(Level level, BlockPos pos) {
        if (!level.m_5776_()) {
            level.m_5594_(null, pos, (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("entity.generic.explode")), SoundSource.MASTER, 1.0f, 1.0f);
        } else {
            level.m_245747_(pos, (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("entity.generic.explode")), SoundSource.MASTER, 1.0f, 1.0f, false);
        }
        if (level instanceof ServerLevel) {
            ServerLevel _level = (ServerLevel)level;
            _level.m_8767_((ParticleOptions)ParticleTypes.f_123813_, (double)pos.m_123341_(), (double)(pos.m_123342_() + 1), (double)pos.m_123343_(), 12, 0.5, 0.5, 0.5, 0.0);
            BeaverBombProjectile.massBeaverify(level, pos, this.isBinding());
        }
        if (!this.m_9236_().f_46443_) {
            this.m_9236_().m_7605_((Entity)this, (byte)3);
            this.m_146870_();
        }
    }
}

