/*
 * Decompiled with CFR 0.152.
 */
package net.svisvi.jigsawpp.entity.projectile;

import java.util.HashSet;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.ItemSupplier;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.network.PlayMessages;
import net.minecraftforge.registries.ForgeRegistries;
import net.svisvi.jigsawpp.entity.init.ModEntities;
import net.svisvi.jigsawpp.item.init.ModItems;
import net.svisvi.jigsawpp.particles.ModParticleTypes;

@OnlyIn(value=Dist.CLIENT, _interface=ItemSupplier.class)
public class BeaverzookaEntity
extends AbstractArrow
implements ItemSupplier {
    public static HashSet<TagKey<Block>> notReplaceableTags = new HashSet();
    public static HashSet<SoundType> replaceableSoundTypes;
    public static HashSet<TagKey<Block>> replaceableTags;

    public BeaverzookaEntity(PlayMessages.SpawnEntity packet, Level world) {
        super((EntityType)ModEntities.BEAVERZOOKA_ENTITY.get(), world);
    }

    public BeaverzookaEntity(EntityType<? extends BeaverzookaEntity> type, Level world) {
        super(type, world);
    }

    public BeaverzookaEntity(EntityType<? extends BeaverzookaEntity> type, double x, double y, double z, Level world) {
        super(type, x, y, z, world);
    }

    public BeaverzookaEntity(EntityType<? extends BeaverzookaEntity> type, LivingEntity entity, Level world) {
        super(type, entity, world);
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return super.m_5654_();
    }

    @OnlyIn(value=Dist.CLIENT)
    public ItemStack m_7846_() {
        return new ItemStack((ItemLike)ModItems.BEAWEED_NUT.get());
    }

    protected ItemStack m_7941_() {
        return new ItemStack((ItemLike)ModItems.BEAVER_AMMO.get());
    }

    protected void m_7761_(LivingEntity entity) {
        super.m_7761_(entity);
        entity.m_21317_(entity.m_21234_() - 1);
    }

    public void m_8119_() {
        super.m_8119_();
        this.tickScript(this.m_9236_(), this.m_20185_(), this.m_20186_(), this.m_20189_(), (Entity)this);
        if (this.f_36703_) {
            this.m_146870_();
        }
    }

    public static BeaverzookaEntity shoot(Level world, LivingEntity entity, Random random, float power, double damage, int knockback) {
        BeaverzookaEntity entityarrow = new BeaverzookaEntity((EntityType<? extends BeaverzookaEntity>)((EntityType)ModEntities.BEAVERZOOKA_ENTITY.get()), entity, world);
        entityarrow.m_6686_(entity.m_20252_((float)1.0f).f_82479_, entity.m_20252_((float)1.0f).f_82480_, entity.m_20252_((float)1.0f).f_82481_, power * 2.0f, 0.0f);
        entityarrow.m_20225_(true);
        entityarrow.m_36762_(false);
        entityarrow.m_36781_(damage);
        entityarrow.m_36735_(knockback);
        world.m_7967_((Entity)entityarrow);
        world.m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("entity.ghast.shoot")), SoundSource.PLAYERS, 1.0f, 1.0f / (random.nextFloat() * 0.5f + 1.0f) + power / 2.0f);
        return entityarrow;
    }

    public static BeaverzookaEntity shoot(LivingEntity entity, LivingEntity target) {
        BeaverzookaEntity entityarrow = new BeaverzookaEntity((EntityType<? extends BeaverzookaEntity>)((EntityType)ModEntities.BEAVERZOOKA_ENTITY.get()), entity, entity.m_9236_());
        double dx = target.m_20185_() - entity.m_20185_();
        double dy = target.m_20186_() + (double)target.m_20192_() - 1.1;
        double dz = target.m_20189_() - entity.m_20189_();
        entityarrow.m_6686_(dx, dy - entityarrow.m_20186_() + Math.hypot(dx, dz) * (double)0.2f, dz, 1.0f, 12.0f);
        entityarrow.m_20225_(true);
        entityarrow.m_36781_(1.0);
        entityarrow.m_36735_(1);
        entityarrow.m_36762_(false);
        entity.m_9236_().m_7967_((Entity)entityarrow);
        entity.m_9236_().m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("entity.ghast.shoot")), SoundSource.PLAYERS, 1.0f, 1.0f / (new Random().nextFloat() * 0.5f + 1.0f));
        return entityarrow;
    }

    public void tickScript(Level world, double x, double y, double z, final Entity immediatesourceentity) {
        BlockPos pos = new BlockPos((int)x, (int)y, (int)z);
        if (immediatesourceentity == null) {
            return;
        }
        boolean found = false;
        int sx = 0;
        int sy = 0;
        int sz = 0;
        double despawn = 0.0;
        found = false;
        if (despawn >= 20.0 && !immediatesourceentity.m_9236_().m_5776_()) {
            immediatesourceentity.m_146870_();
        }
        new Object(){
            private int ticks = 0;
            private float waitTicks;
            private LevelAccessor world;

            public void start(LevelAccessor world, int waitTicks) {
                this.waitTicks = waitTicks;
                MinecraftForge.EVENT_BUS.register((Object)this);
                this.world = world;
            }

            @SubscribeEvent
            public void tick(TickEvent.ServerTickEvent event) {
                if (event.phase == TickEvent.Phase.END) {
                    ++this.ticks;
                    if ((float)this.ticks >= this.waitTicks) {
                        this.run();
                    }
                }
            }

            private void run() {
                if (!immediatesourceentity.m_9236_().m_5776_()) {
                    immediatesourceentity.m_146870_();
                }
                MinecraftForge.EVENT_BUS.unregister((Object)this);
            }
        }.start((LevelAccessor)world, 110);
        immediatesourceentity.m_20242_(true);
        if (world instanceof ServerLevel) {
            ServerLevel _level = (ServerLevel)world;
            _level.m_8767_((ParticleOptions)((SimpleParticleType)ModParticleTypes.POOP.get()), x, y, z, 5, 0.1, 0.1, 0.1, 0.0);
        }
        sx = -3;
        found = false;
        for (int index0 = 0; index0 < 6; ++index0) {
            sy = -3;
            for (int index1 = 0; index1 < 6; ++index1) {
                sz = -3;
                for (int index2 = 0; index2 < 6; ++index2) {
                    if (this.breakBlock(world, new BlockPos(pos.m_123341_() + sx, pos.m_123342_() + sy, pos.m_123343_() + sz))) {
                        despawn += 1.0;
                    }
                    ++sz;
                }
                ++sy;
            }
            ++sx;
        }
    }

    public boolean breakBlock(Level world, BlockPos pos) {
        BlockState state = world.m_8055_(pos);
        if (!notReplaceableTags.stream().anyMatch(arg_0 -> ((BlockState)state).m_204336_(arg_0))) {
            if (replaceableTags.stream().anyMatch(arg_0 -> ((BlockState)state).m_204336_(arg_0)) || replaceableSoundTypes.stream().anyMatch(soundType -> soundType == state.m_60827_())) {
                world.m_7731_(pos, Blocks.f_50016_.m_49966_(), 3);
                if (!world.m_5776_()) {
                    world.m_5594_(null, pos, (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("block.wood.step")), SoundSource.BLOCKS, 1.0f, 1.0f);
                } else {
                    world.m_245747_(pos, (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("block.wood.step")), SoundSource.BLOCKS, 1.0f, 1.0f, false);
                }
                if (world instanceof ServerLevel) {
                    ServerLevel _level = (ServerLevel)world;
                    _level.m_8767_((ParticleOptions)ParticleTypes.f_123797_, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), 2, 0.1, 0.1, 0.1, 0.0);
                }
                return true;
            }
        }
        return false;
    }

    static {
        notReplaceableTags.add((TagKey<Block>)BlockTags.create((ResourceLocation)new ResourceLocation("forge:barrels/wooden")));
        notReplaceableTags.add((TagKey<Block>)BlockTags.create((ResourceLocation)new ResourceLocation("forge:chests/wooden")));
        replaceableSoundTypes = new HashSet();
        replaceableSoundTypes.add(SoundType.f_56760_);
        replaceableSoundTypes.add(SoundType.f_154666_);
        replaceableSoundTypes.add(SoundType.f_154674_);
        replaceableSoundTypes.add(SoundType.f_56754_);
        replaceableSoundTypes.add(SoundType.f_56755_);
        replaceableSoundTypes.add(SoundType.f_256995_);
        replaceableSoundTypes.add(SoundType.f_243772_);
        replaceableSoundTypes.add(SoundType.f_154670_);
        replaceableSoundTypes.add(SoundType.f_154664_);
        replaceableSoundTypes.add(SoundType.f_271239_);
        replaceableSoundTypes.add(SoundType.f_271370_);
        replaceableSoundTypes.add(SoundType.f_271497_);
        replaceableSoundTypes.add(SoundType.f_271094_);
        replaceableSoundTypes.add(SoundType.f_154667_);
        replaceableSoundTypes.add(SoundType.f_154673_);
        replaceableSoundTypes.add(SoundType.f_56748_);
        replaceableSoundTypes.add(SoundType.f_56741_);
        replaceableSoundTypes.add(SoundType.f_222467_);
        replaceableSoundTypes.add(SoundType.f_244244_);
        replaceableSoundTypes.add(SoundType.f_256908_);
        replaceableSoundTypes.add(SoundType.f_56712_);
        replaceableSoundTypes.add(SoundType.f_56756_);
        replaceableSoundTypes.add(SoundType.f_154671_);
        replaceableSoundTypes.add(SoundType.f_56715_);
        replaceableSoundTypes.add(SoundType.f_56714_);
        replaceableSoundTypes.add(SoundType.f_56736_);
        replaceableTags = new HashSet();
        replaceableTags.add((TagKey<Block>)BlockTags.f_13090_);
        replaceableTags.add((TagKey<Block>)BlockTags.f_13092_);
        replaceableTags.add((TagKey<Block>)BlockTags.f_13095_);
        replaceableTags.add((TagKey<Block>)BlockTags.f_13096_);
        replaceableTags.add((TagKey<Block>)BlockTags.f_13097_);
        replaceableTags.add((TagKey<Block>)BlockTags.f_13098_);
        replaceableTags.add((TagKey<Block>)BlockTags.f_13100_);
        replaceableTags.add((TagKey<Block>)BlockTags.f_13102_);
        replaceableTags.add((TagKey<Block>)BlockTags.f_13104_);
        replaceableTags.add((TagKey<Block>)BlockTags.f_13105_);
        replaceableTags.add((TagKey<Block>)BlockTags.f_215839_);
        replaceableTags.add((TagKey<Block>)BlockTags.f_13106_);
        replaceableTags.add((TagKey<Block>)BlockTags.f_13107_);
        replaceableTags.add((TagKey<Block>)BlockTags.f_13108_);
        replaceableTags.add((TagKey<Block>)BlockTags.f_13109_);
        replaceableTags.add((TagKey<Block>)BlockTags.f_13110_);
        replaceableTags.add((TagKey<Block>)BlockTags.f_271212_);
        replaceableTags.add((TagKey<Block>)BlockTags.f_13111_);
        replaceableTags.add((TagKey<Block>)BlockTags.f_13112_);
        replaceableTags.add((TagKey<Block>)BlockTags.f_215840_);
        replaceableTags.add((TagKey<Block>)BlockTags.f_257016_);
        replaceableTags.add((TagKey<Block>)BlockTags.f_13035_);
    }
}

