/*
 * Decompiled with CFR 0.152.
 */
package net.svisvi.jigsawpp.entity.projectile;

import net.minecraft.core.BlockPos;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.ItemSupplier;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraftforge.network.PlayMessages;
import net.minecraftforge.registries.ForgeRegistries;
import net.svisvi.jigsawpp.entity.init.ModEntities;
import net.svisvi.jigsawpp.procedures.ExtinguisherProjectileParticle;
import net.svisvi.jigsawpp.procedures.ut.FireClear;

public class ExtinguisherProjectile
extends AbstractArrow
implements ItemSupplier {
    public static final ItemStack PROJECTILE_ITEM = new ItemStack((ItemLike)Blocks.f_50083_);

    public ExtinguisherProjectile(PlayMessages.SpawnEntity packet, Level world) {
        super((EntityType)ModEntities.EXTINGUISHER_PROJECTILE.get(), world);
    }

    public ExtinguisherProjectile(EntityType<? extends ExtinguisherProjectile> type, Level world) {
        super(type, world);
    }

    public ExtinguisherProjectile(EntityType<? extends ExtinguisherProjectile> type, double x, double y, double z, Level world) {
        super(type, x, y, z, world);
    }

    public ExtinguisherProjectile(EntityType<? extends ExtinguisherProjectile> type, LivingEntity entity, Level world) {
        super(type, entity, world);
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return super.m_5654_();
    }

    public ItemStack m_7846_() {
        return PROJECTILE_ITEM;
    }

    protected ItemStack m_7941_() {
        return PROJECTILE_ITEM;
    }

    public void m_8119_() {
        Level level;
        super.m_8119_();
        ExtinguisherProjectileParticle.particleSpawn((LevelAccessor)this.m_9236_(), this.m_20185_(), this.m_20186_(), this.m_20189_());
        if (this.m_9236_().m_8055_(BlockPos.m_274561_((double)this.m_146903_(), (double)this.m_146904_(), (double)this.m_146907_())).m_60734_() == Blocks.f_50083_ && (level = this.m_9236_()) instanceof ServerLevel) {
            ServerLevel _level = (ServerLevel)level;
            FireClear.clearFire((LevelAccessor)this.m_9236_(), this.m_146903_(), this.m_146904_(), this.m_146907_(), 3);
            this.m_146870_();
        }
        if (this.f_36703_) {
            this.m_146870_();
        }
    }

    protected void m_5790_(EntityHitResult pResult) {
        this.m_6074_();
        super.m_5790_(pResult);
    }

    protected void m_8060_(BlockHitResult pResult) {
        FireClear.clearFire((LevelAccessor)this.m_9236_(), pResult.m_82425_().m_123341_(), pResult.m_82425_().m_123342_(), pResult.m_82425_().m_123343_(), 3);
        this.m_36740_(SoundEvents.f_12031_);
        super.m_8060_(pResult);
    }

    public static ExtinguisherProjectile shoot(Level world, LivingEntity entity, RandomSource random, float power, double damage, int knockback) {
        ExtinguisherProjectile entityarrow = new ExtinguisherProjectile((EntityType<? extends ExtinguisherProjectile>)((EntityType)ModEntities.EXTINGUISHER_PROJECTILE.get()), entity, world);
        entityarrow.m_6686_(entity.m_20252_((float)1.0f).f_82479_, entity.m_20252_((float)1.0f).f_82480_, entity.m_20252_((float)1.0f).f_82481_, power * 2.0f, 0.0f);
        entityarrow.m_20225_(true);
        entityarrow.m_36762_(true);
        entityarrow.m_36781_(damage);
        entityarrow.m_36735_(knockback);
        world.m_7967_((Entity)entityarrow);
        world.m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("block.fire.extinguish")), SoundSource.PLAYERS, 1.0f, 1.0f / (random.m_188501_() * 0.5f + 1.0f) + power / 2.0f);
        return entityarrow;
    }

    public static ExtinguisherProjectile shoot(LivingEntity entity, LivingEntity target) {
        ExtinguisherProjectile entityarrow = new ExtinguisherProjectile((EntityType<? extends ExtinguisherProjectile>)((EntityType)ModEntities.EXTINGUISHER_PROJECTILE.get()), entity, entity.m_9236_());
        double dx = target.m_20185_() - entity.m_20185_();
        double dy = target.m_20186_() + (double)target.m_20192_() - 1.1;
        double dz = target.m_20189_() - entity.m_20189_();
        entityarrow.m_6686_(dx, dy - entityarrow.m_20186_() + Math.hypot(dx, dz) * (double)0.2f, dz, 2.0f, 12.0f);
        entityarrow.m_20225_(true);
        entityarrow.m_36781_(0.0);
        entityarrow.m_36735_(10);
        entityarrow.m_36762_(true);
        entity.m_9236_().m_7967_((Entity)entityarrow);
        entity.m_9236_().m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("block.fire.extinguish")), SoundSource.PLAYERS, 1.0f, 1.0f / (RandomSource.m_216327_().m_188501_() * 0.5f + 1.0f));
        return entityarrow;
    }
}

