/*
 * Decompiled with CFR 0.152.
 */
package net.svisvi.jigsawpp.entity.projectile;

import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.projectile.ItemSupplier;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.PlayMessages;
import net.minecraftforge.registries.ForgeRegistries;
import net.svisvi.jigsawpp.entity.init.ModEntities;
import net.svisvi.jigsawpp.entity.projectile.PoopsEntity;
import net.svisvi.jigsawpp.item.init.ModItems;
import net.svisvi.jigsawpp.particles.ModParticleTypes;
import net.svisvi.jigsawpp.procedures.ut.DristExplosion;

@OnlyIn(value=Dist.CLIENT, _interface=ItemSupplier.class)
public class PoopisEntity
extends PoopsEntity {
    public PoopisEntity(PlayMessages.SpawnEntity packet, Level world) {
        super((EntityType<? extends PoopsEntity>)((EntityType)ModEntities.POOPIS.get()), world);
    }

    public PoopisEntity(EntityType<? extends PoopisEntity> type, Level world) {
        super(type, world);
    }

    public PoopisEntity(EntityType<? extends PoopisEntity> type, double x, double y, double z, Level world) {
        super(type, x, y, z, world);
    }

    public PoopisEntity(EntityType<? extends PoopisEntity> type, LivingEntity entity, Level world) {
        super(type, entity, world);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public ItemStack m_7846_() {
        return new ItemStack((ItemLike)ModItems.POOPIS.get());
    }

    @Override
    protected ItemStack m_7941_() {
        return new ItemStack((ItemLike)ModItems.POOPIS.get());
    }

    @Override
    public void hit(Level world, BlockPos pos) {
        int x = pos.m_123341_();
        int y = pos.m_123342_();
        int z = pos.m_123343_();
        if (!world.m_5776_()) {
            world.m_5594_(null, pos, (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("entity.dragon_fireball.explode")), SoundSource.NEUTRAL, 1.0f, 1.0f);
        } else {
            world.m_245747_(pos, (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("entity.dragon_fireball.explode")), SoundSource.NEUTRAL, 1.0f, 1.0f, false);
        }
        if (world instanceof ServerLevel) {
            ServerLevel _level = (ServerLevel)world;
            _level.m_8767_((ParticleOptions)((SimpleParticleType)ModParticleTypes.POOP_BUBBLE.get()), (double)x, (double)y, (double)z, 20, 1.0, 1.0, 1.0, 0.1);
        }
        if (!world.m_5776_()) {
            DristExplosion.harmfulDristExplode(world, pos, 4, Level.ExplosionInteraction.NONE, null);
        }
        if (Math.random() < 0.2 && !world.m_5776_()) {
            ItemEntity entityToSpawn = new ItemEntity(world, (double)x, (double)y, (double)z, new ItemStack((ItemLike)ModItems.POOPIS.get()));
            entityToSpawn.m_32010_(10);
            world.m_7967_((Entity)entityToSpawn);
        }
    }

    public static PoopisEntity shoot(Level world, LivingEntity entity, Random random, float power, double damage, int knockback) {
        PoopisEntity entityarrow = new PoopisEntity((EntityType<? extends PoopisEntity>)((EntityType)ModEntities.POOPIS.get()), entity, world);
        entityarrow.m_6686_(entity.m_20252_((float)1.0f).f_82479_, entity.m_20252_((float)1.0f).f_82480_, entity.m_20252_((float)1.0f).f_82481_, power * 2.0f, 0.0f);
        entityarrow.m_20225_(true);
        entityarrow.m_36762_(false);
        entityarrow.m_36781_(damage);
        entityarrow.m_36735_(knockback);
        world.m_7967_((Entity)entityarrow);
        world.m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("entity.villager.no")), SoundSource.PLAYERS, 1.0f, 1.0f / (random.nextFloat() * 0.5f + 1.0f) + power / 2.0f);
        return entityarrow;
    }

    public static PoopisEntity shoot(LivingEntity entity, LivingEntity target) {
        PoopisEntity entityarrow = new PoopisEntity((EntityType<? extends PoopisEntity>)((EntityType)ModEntities.POOPIS.get()), entity, entity.m_9236_());
        double dx = target.m_20185_() - entity.m_20185_();
        double dy = target.m_20186_() + (double)target.m_20192_() - 1.1;
        double dz = target.m_20189_() - entity.m_20189_();
        entityarrow.m_6686_(dx, dy - entityarrow.m_20186_() + Math.hypot(dx, dz) * (double)0.2f, dz, 4.4f, 12.0f);
        entityarrow.m_20225_(true);
        entityarrow.m_36781_(10.0);
        entityarrow.m_36735_(0);
        entityarrow.m_36762_(false);
        entity.m_9236_().m_7967_((Entity)entityarrow);
        entity.m_9236_().m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("entity.villager.no")), SoundSource.PLAYERS, 1.0f, 1.0f / (new Random().nextFloat() * 0.5f + 1.0f));
        return entityarrow;
    }
}

