/*
 * Decompiled with CFR 0.152.
 */
package net.svisvi.jigsawpp.entity.projectile;

import java.util.Comparator;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.ItemSupplier;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PlayMessages;
import net.minecraftforge.registries.ForgeRegistries;
import net.svisvi.jigsawpp.entity.init.ModEntities;
import net.svisvi.jigsawpp.item.init.ModItems;

@OnlyIn(value=Dist.CLIENT, _interface=ItemSupplier.class)
public class PoopsEntity
extends AbstractArrow
implements ItemSupplier {
    public PoopsEntity(PlayMessages.SpawnEntity packet, Level world) {
        super((EntityType)ModEntities.POOPS.get(), world);
    }

    public PoopsEntity(EntityType<? extends PoopsEntity> type, Level world) {
        super(type, world);
    }

    public PoopsEntity(EntityType<? extends PoopsEntity> type, double x, double y, double z, Level world) {
        super(type, x, y, z, world);
    }

    public PoopsEntity(EntityType<? extends PoopsEntity> type, LivingEntity entity, Level world) {
        super(type, entity, world);
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    @OnlyIn(value=Dist.CLIENT)
    public ItemStack m_7846_() {
        return new ItemStack((ItemLike)ModItems.POOPS.get());
    }

    protected ItemStack m_7941_() {
        return new ItemStack((ItemLike)ModItems.POOPS.get());
    }

    protected void m_7761_(LivingEntity entity) {
        super.m_7761_(entity);
        entity.m_21317_(entity.m_21234_() - 1);
    }

    public void hit(Level world, BlockPos pos) {
        int x = pos.m_123341_();
        int y = pos.m_123342_();
        int z = pos.m_123343_();
        if (!world.m_5776_()) {
            world.m_5594_(null, pos, (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("entity.dragon_fireball.explode")), SoundSource.NEUTRAL, 1.0f, 1.0f);
        } else {
            world.m_245747_(pos, (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("entity.dragon_fireball.explode")), SoundSource.NEUTRAL, 1.0f, 1.0f, false);
        }
        if (world instanceof ServerLevel) {
            ServerLevel _level = (ServerLevel)world;
            _level.m_8767_((ParticleOptions)ParticleTypes.f_123750_, (double)x, (double)y, (double)z, 20, 1.0, 1.0, 1.0, 0.1);
        }
        if (!world.m_5776_()) {
            world.m_254849_(null, (double)x, (double)y, (double)z, 4.0f, Level.ExplosionInteraction.NONE);
        }
        if (Math.random() < 0.2 && !world.m_5776_()) {
            ItemEntity entityToSpawn = new ItemEntity(world, (double)x, (double)y, (double)z, new ItemStack((ItemLike)ModItems.POOPS.get()));
            entityToSpawn.m_32010_(10);
            world.m_7967_((Entity)entityToSpawn);
        }
    }

    public void m_5790_(EntityHitResult entityHitResult) {
        super.m_5790_(entityHitResult);
        this.hit(this.m_9236_(), entityHitResult.m_82443_().m_20097_());
        entityHitResult.m_82443_().m_6469_(new DamageSource((Holder)this.m_9236_().m_9598_().m_175515_(Registries.f_268580_).m_246971_(DamageTypes.f_268613_), this.m_19749_(), (Entity)this), 4.0f);
    }

    public void m_8060_(BlockHitResult blockHitResult) {
        super.m_8060_(blockHitResult);
        this.hit(this.m_9236_(), blockHitResult.m_82425_());
    }

    public void m_8119_() {
        super.m_8119_();
        double dis = 0.0;
        double speeed = 0.0;
        speeed = 0.5;
        double x = this.m_20185_();
        double y = this.m_20186_();
        double z = this.m_20189_();
        Entity entity = this.m_19749_();
        PoopsEntity immediatesourceentity = this;
        Level world = this.m_9236_();
        Vec3 _center = new Vec3(x, y, z);
        List _entfound = world.m_6443_(Entity.class, new AABB(_center, _center).m_82400_(16.0), e -> true).stream().sorted(Comparator.comparingDouble(_entcnd -> _entcnd.m_20238_(_center))).collect(Collectors.toList());
        for (Entity entityiterator : _entfound) {
            ServerLevel _level;
            if (immediatesourceentity == entityiterator || entity == entityiterator || (Entity)world.m_6443_(LivingEntity.class, AABB.m_165882_((Vec3)new Vec3(x, y, z), (double)32.0, (double)32.0, (double)32.0), e -> true).stream().sorted(new Object(){

                Comparator<Entity> compareDistOf(double _x, double _y, double _z) {
                    return Comparator.comparingDouble(_entcnd -> _entcnd.m_20275_(_x, _y, _z));
                }
            }.compareDistOf(x, y, z)).findFirst().orElse(null) != entityiterator) continue;
            dis = Math.sqrt(Math.pow(entityiterator.m_20185_() - immediatesourceentity.m_20185_(), 2.0) + Math.pow(entityiterator.m_20186_() - immediatesourceentity.m_20186_(), 2.0) + Math.pow(entityiterator.m_20189_() - immediatesourceentity.m_20189_(), 2.0));
            immediatesourceentity.m_20256_(new Vec3((entityiterator.m_20185_() - immediatesourceentity.m_20185_()) / dis * speeed, (entityiterator.m_20186_() - immediatesourceentity.m_20186_()) / dis * speeed, (entityiterator.m_20189_() - immediatesourceentity.m_20189_()) / dis * speeed));
            if (world instanceof ServerLevel) {
                _level = (ServerLevel)world;
                _level.m_8767_((ParticleOptions)ParticleTypes.f_123747_, x, y, z, 15, 0.7, 0.7, 0.7, 0.2);
            }
            if (world instanceof ServerLevel) {
                _level = (ServerLevel)world;
                _level.m_8767_((ParticleOptions)ParticleTypes.f_123762_, x, y, z, 15, 0.7, 0.7, 0.7, 0.2);
            }
            if (world.m_6443_(LivingEntity.class, AABB.m_165882_((Vec3)new Vec3(x, y, z), (double)5.0, (double)5.0, (double)5.0), e -> true).isEmpty()) continue;
            speeed *= 1.2;
        }
        if (this.f_36703_) {
            this.m_146870_();
        }
    }

    public static PoopsEntity shoot(Level world, LivingEntity entity, Random random, float power, double damage, int knockback) {
        PoopsEntity entityarrow = new PoopsEntity((EntityType<? extends PoopsEntity>)((EntityType)ModEntities.POOPS.get()), entity, world);
        entityarrow.m_6686_(entity.m_20252_((float)1.0f).f_82479_, entity.m_20252_((float)1.0f).f_82480_, entity.m_20252_((float)1.0f).f_82481_, power * 2.0f, 0.0f);
        entityarrow.m_20225_(true);
        entityarrow.m_36762_(false);
        entityarrow.m_36781_(damage);
        entityarrow.m_36735_(knockback);
        world.m_7967_((Entity)entityarrow);
        world.m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("entity.villager.no")), SoundSource.PLAYERS, 1.0f, 1.0f / (random.nextFloat() * 0.5f + 1.0f) + power / 2.0f);
        return entityarrow;
    }

    public static PoopsEntity shoot(LivingEntity entity, LivingEntity target) {
        PoopsEntity entityarrow = new PoopsEntity((EntityType<? extends PoopsEntity>)((EntityType)ModEntities.POOPS.get()), entity, entity.m_9236_());
        double dx = target.m_20185_() - entity.m_20185_();
        double dy = target.m_20186_() + (double)target.m_20192_() - 1.1;
        double dz = target.m_20189_() - entity.m_20189_();
        entityarrow.m_6686_(dx, dy - entityarrow.m_20186_() + Math.hypot(dx, dz) * (double)0.2f, dz, 4.4f, 12.0f);
        entityarrow.m_20225_(true);
        entityarrow.m_36781_(10.0);
        entityarrow.m_36735_(0);
        entityarrow.m_36762_(false);
        entity.m_9236_().m_7967_((Entity)entityarrow);
        entity.m_9236_().m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("entity.villager.no")), SoundSource.PLAYERS, 1.0f, 1.0f / (new Random().nextFloat() * 0.5f + 1.0f));
        return entityarrow;
    }
}

