/*
 * Decompiled with CFR 0.152.
 */
package net.svisvi.jigsawpp.entity.projectile;

import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.ItemSupplier;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.svisvi.jigsawpp.effect.PurgativeEffect;
import net.svisvi.jigsawpp.effect.init.ModEffects;
import net.svisvi.jigsawpp.entity.init.ModEntities;
import net.svisvi.jigsawpp.item.init.ModItems;

public class PurgenPiluleProjectile
extends ThrowableItemProjectile
implements ItemSupplier {
    public boolean armor_piercing;

    public PurgenPiluleProjectile(EntityType<? extends ThrowableItemProjectile> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    public PurgenPiluleProjectile(Level pLevel, LivingEntity pShooter) {
        super((EntityType)ModEntities.PURGEN_PILULE_PROJECTILE.get(), pShooter, pLevel);
    }

    public PurgenPiluleProjectile(Level pLevel, LivingEntity pShooter, boolean ap) {
        super((EntityType)ModEntities.PURGEN_PILULE_PROJECTILE.get(), pShooter, pLevel);
        this.armor_piercing = ap;
    }

    public PurgenPiluleProjectile(Level pLevel, double pX, double pY, double pZ) {
        super((EntityType)ModEntities.PURGEN_PILULE_PROJECTILE.get(), pX, pY, pZ, pLevel);
    }

    public PurgenPiluleProjectile(Level pLevel) {
        super((EntityType)ModEntities.PURGEN_PILULE_PROJECTILE.get(), pLevel);
    }

    public void m_7822_(byte pId) {
        if (pId == 3) {
            double d0 = 0.08;
            for (int i = 0; i < 8; ++i) {
                this.m_9236_().m_7106_((ParticleOptions)new ItemParticleOption(ParticleTypes.f_123752_, this.m_7846_()), this.m_20185_(), this.m_20186_(), this.m_20189_(), ((double)this.f_19796_.m_188501_() - 0.5) * 0.08, ((double)this.f_19796_.m_188501_() - 0.5) * 0.08, ((double)this.f_19796_.m_188501_() - 0.5) * 0.08);
            }
        }
    }

    public void setArmor_piercing(boolean armor_piercing) {
        this.armor_piercing = armor_piercing;
    }

    public boolean getArmor_piercing() {
        return this.armor_piercing;
    }

    protected void m_5790_(EntityHitResult pResult) {
        LivingEntity ent;
        super.m_5790_(pResult);
        pResult.m_82443_().m_6469_(this.m_269291_().m_269390_((Entity)this, this.m_19749_()), 0.5f);
        Entity entity = pResult.m_82443_();
        if (entity instanceof LivingEntity && (PurgativeEffect.poopAdditionConditionLiquidWay((Entity)(ent = (LivingEntity)entity), new MobEffectInstance((MobEffect)ModEffects.PURGATIVE.get(), 21, 0)) || this.armor_piercing)) {
            this.m_7846_().m_41720_().m_5922_(this.m_7846_(), ent.m_9236_(), ent);
        }
    }

    protected Item m_7881_() {
        return (Item)ModItems.EMPTY_PILULE.get();
    }

    public void m_8119_() {
        super.m_8119_();
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel _level = (ServerLevel)level;
            _level.m_8767_((ParticleOptions)ParticleTypes.f_123783_, this.m_20185_(), this.m_20186_(), this.m_20189_(), 3, 0.2, 0.2, 0.2, 0.0);
        }
        if (this.m_19749_() == null || this == null) {
            return;
        }
        double speeed = 0.5;
        double x = this.m_20185_();
        double y = this.m_20186_();
        double z = this.m_20189_();
        Level world = this.m_9236_();
        this.autoAim(speeed, x, y, z, world, (Projectile)this, this.m_19749_());
    }

    public void autoAim(double speed, double x, double y, double z, Level world, Projectile immediatesourceentity, Entity entity) {
        double dis = 0.0;
        Vec3 _center = new Vec3(x, y, z);
        List _entfound = world.m_6443_(Entity.class, new AABB(_center, _center).m_82400_(1.5), e -> true).stream().sorted(Comparator.comparingDouble(_entcnd -> _entcnd.m_20238_(_center))).collect(Collectors.toList());
        for (Entity entityiterator : _entfound) {
            if (immediatesourceentity == entityiterator || entity == entityiterator || (Entity)world.m_6443_(LivingEntity.class, AABB.m_165882_((Vec3)new Vec3(x, y, z), (double)3.0, (double)3.0, (double)3.0), e -> true).stream().sorted(new Object(){

                Comparator<Entity> compareDistOf(double _x, double _y, double _z) {
                    return Comparator.comparingDouble(_entcnd -> _entcnd.m_20275_(_x, _y, _z));
                }
            }.compareDistOf(x, y, z)).findFirst().orElse(null) != entityiterator) continue;
            dis = Math.sqrt(Math.pow(entityiterator.m_20185_() - immediatesourceentity.m_20185_(), 2.0) + Math.pow(entityiterator.m_20186_() - immediatesourceentity.m_20186_(), 2.0) + Math.pow(entityiterator.m_20189_() - immediatesourceentity.m_20189_(), 2.0));
            immediatesourceentity.m_20256_(new Vec3((entityiterator.m_20185_() - immediatesourceentity.m_20185_()) / dis * speed, (entityiterator.m_20186_() - immediatesourceentity.m_20186_()) / dis * speed, (entityiterator.m_20189_() - immediatesourceentity.m_20189_()) / dis * speed));
            if (world instanceof ServerLevel) {
                ServerLevel _level = (ServerLevel)world;
                _level.m_8767_((ParticleOptions)ParticleTypes.f_123762_, x, y, z, 15, 0.7, 0.7, 0.7, 0.2);
            }
            if (world.m_6443_(LivingEntity.class, AABB.m_165882_((Vec3)new Vec3(x, y, z), (double)5.0, (double)5.0, (double)5.0), e -> true).isEmpty()) continue;
            speed *= 1.2;
        }
    }

    protected void m_6532_(HitResult pResult) {
        super.m_6532_(pResult);
        if (!this.m_9236_().f_46443_) {
            this.m_9236_().m_7605_((Entity)this, (byte)3);
            this.m_146870_();
        }
    }

    public static Projectile shoot(Level pLevel, LivingEntity pEntity, float pVelocity, float pInaccuracy, ItemStack renderableItemStack) {
        return PurgenPiluleProjectile.shoot(pLevel, pEntity, pVelocity, pInaccuracy, renderableItemStack, false);
    }

    public static Projectile shoot(Level pLevel, LivingEntity pEntity, float pVelocity, float pInaccuracy, ItemStack renderableItemStack, boolean ap) {
        if (!pLevel.f_46443_) {
            PurgenPiluleProjectile thrownegg = new PurgenPiluleProjectile(pLevel, pEntity, ap);
            thrownegg.m_37446_(renderableItemStack);
            thrownegg.m_37251_((Entity)pEntity, pEntity.m_146909_(), pEntity.m_146908_(), 0.0f, pVelocity, pInaccuracy);
            pLevel.m_7967_((Entity)thrownegg);
            return thrownegg;
        }
        return null;
    }

    public void m_37446_(ItemStack pStack) {
        super.m_37446_(pStack);
    }
}

