/*
 * Decompiled with CFR 0.152.
 */
package net.svisvi.jigsawpp.entity.projectile;

import java.util.Random;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.ItemSupplier;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.PlayMessages;
import net.minecraftforge.registries.ForgeRegistries;
import net.svisvi.jigsawpp.block.init.ModBlocks;
import net.svisvi.jigsawpp.entity.init.ModEntities;
import net.svisvi.jigsawpp.entity.tntpot.PrimedTntPot;
import net.svisvi.jigsawpp.item.init.ModItems;

@OnlyIn(value=Dist.CLIENT, _interface=ItemSupplier.class)
public class TeapotMissileEntity
extends AbstractArrow
implements ItemSupplier {
    public TeapotMissileEntity(PlayMessages.SpawnEntity packet, Level world) {
        super((EntityType)ModEntities.TEAPOT_MISSILE_ENTITY.get(), world);
    }

    public TeapotMissileEntity(EntityType<? extends TeapotMissileEntity> type, Level world) {
        super(type, world);
    }

    public TeapotMissileEntity(EntityType<? extends TeapotMissileEntity> type, double x, double y, double z, Level world) {
        super(type, x, y, z, world);
    }

    public TeapotMissileEntity(EntityType<? extends TeapotMissileEntity> type, LivingEntity entity, Level world) {
        super(type, entity, world);
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return super.m_5654_();
    }

    @OnlyIn(value=Dist.CLIENT)
    public ItemStack m_7846_() {
        return new ItemStack((ItemLike)ModBlocks.TEAPOT.get());
    }

    protected ItemStack m_7941_() {
        return new ItemStack((ItemLike)ModItems.BIG_TEAPOT.get());
    }

    protected void m_7761_(LivingEntity entity) {
        super.m_7761_(entity);
        entity.m_21317_(entity.m_21234_() - 1);
    }

    protected void m_8060_(BlockHitResult pResult) {
        super.m_8060_(pResult);
        PrimedTntPot primedtnt = new PrimedTntPot(this.m_9236_(), this.m_20185_() + 0.5, this.m_20186_(), this.m_20189_() + 0.5, null);
        primedtnt.setFuse(0);
        this.m_9236_().m_7967_((Entity)primedtnt);
        this.m_146870_();
    }

    protected void m_5790_(EntityHitResult pResult) {
        super.m_5790_(pResult);
        PrimedTntPot primedtnt = new PrimedTntPot(this.m_9236_(), this.m_20185_() + 0.5, this.m_20186_(), this.m_20189_() + 0.5, null);
        primedtnt.setFuse(0);
        this.m_9236_().m_7967_((Entity)primedtnt);
        this.m_146870_();
    }

    private static void spawnParticle(LevelAccessor level, Double x, Double y, Double z) {
        Random rand = new Random();
        Double xd = x + rand.nextDouble(0.1, 0.6);
        Double yd = y + rand.nextDouble(0.1, 0.6);
        Double zd = z + rand.nextDouble(0.1, 0.6);
        level.m_7106_((ParticleOptions)ParticleTypes.f_123744_, xd.doubleValue(), yd.doubleValue(), zd.doubleValue(), 0.0, 0.0, 0.0);
        level.m_7106_((ParticleOptions)ParticleTypes.f_123759_, xd.doubleValue(), yd.doubleValue(), zd.doubleValue(), 0.0, 0.0, 0.0);
    }

    public void m_8119_() {
        super.m_8119_();
        for (int i = 0; i < 5; ++i) {
            TeapotMissileEntity.spawnParticle((LevelAccessor)this.m_9236_(), this.m_20185_(), this.m_20186_(), this.m_20189_());
            TeapotMissileEntity.spawnParticle((LevelAccessor)this.m_9236_(), this.m_20185_(), this.m_20186_(), this.m_20189_());
            TeapotMissileEntity.spawnParticle((LevelAccessor)this.m_9236_(), this.m_20185_(), this.m_20186_(), this.m_20189_());
            TeapotMissileEntity.spawnParticle((LevelAccessor)this.m_9236_(), this.m_20185_(), this.m_20186_(), this.m_20189_());
        }
    }

    public static TeapotMissileEntity shoot(Level world, LivingEntity entity, Random random, float power, double damage, int knockback) {
        TeapotMissileEntity entityarrow = new TeapotMissileEntity((EntityType<? extends TeapotMissileEntity>)((EntityType)ModEntities.TEAPOT_MISSILE_ENTITY.get()), entity, world);
        entityarrow.m_6686_(entity.m_20252_((float)1.0f).f_82479_, entity.m_20252_((float)1.0f).f_82480_, entity.m_20252_((float)1.0f).f_82481_, power * 2.0f, 0.0f);
        entityarrow.m_20225_(true);
        entityarrow.m_36762_(false);
        entityarrow.m_36781_(damage);
        entityarrow.m_36735_(knockback);
        world.m_7967_((Entity)entityarrow);
        world.m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("entity.ghast.shoot")), SoundSource.PLAYERS, 1.0f, 1.0f / (random.nextFloat() * 0.5f + 1.0f) + power / 2.0f);
        return entityarrow;
    }

    public static TeapotMissileEntity shoot(LivingEntity entity, LivingEntity target) {
        TeapotMissileEntity entityarrow = new TeapotMissileEntity((EntityType<? extends TeapotMissileEntity>)((EntityType)ModEntities.TEAPOT_MISSILE_ENTITY.get()), entity, entity.m_9236_());
        double dx = target.m_20185_() - entity.m_20185_();
        double dy = target.m_20186_() + (double)target.m_20192_() - 1.1;
        double dz = target.m_20189_() - entity.m_20189_();
        entityarrow.m_6686_(dx, dy - entityarrow.m_20186_() + Math.hypot(dx, dz) * (double)0.2f, dz, 1.0f, 12.0f);
        entityarrow.m_20225_(true);
        entityarrow.m_36781_(1.0);
        entityarrow.m_36735_(1);
        entityarrow.m_36762_(false);
        entity.m_9236_().m_7967_((Entity)entityarrow);
        entity.m_9236_().m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("entity.ghast.shoot")), SoundSource.PLAYERS, 1.0f, 1.0f / (new Random().nextFloat() * 0.5f + 1.0f));
        return entityarrow;
    }
}

