/*
 * Decompiled with CFR 0.152.
 */
package net.svisvi.jigsawpp.entity.projectile.granadeProjectiles;

import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import net.svisvi.jigsawpp.entity.emitters.AbstractEmitterEntity;
import net.svisvi.jigsawpp.entity.emitters.EmitterUtils;
import net.svisvi.jigsawpp.entity.emitters.GasEmitterEntity;

public abstract class AbstractGrenadeProjectile
extends ThrowableItemProjectile {
    private int maxLifeTime = 80;
    private int lifeTime = 0;
    public boolean affectOwner = true;
    public boolean instaboom = false;

    public abstract Class<? extends GasEmitterEntity> getEmitterClass();

    public AbstractGrenadeProjectile(EntityType<? extends AbstractGrenadeProjectile> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    public AbstractGrenadeProjectile(EntityType<? extends AbstractGrenadeProjectile> pEntityType, Level pLevel, int lifeTime, int maxLifeTime) {
        super(pEntityType, pLevel);
        this.maxLifeTime = maxLifeTime;
        this.lifeTime = lifeTime;
    }

    public AbstractGrenadeProjectile(EntityType<? extends AbstractGrenadeProjectile> pEntityType, double pX, double pY, double pZ, Level pLevel) {
        super(pEntityType, pX, pY, pZ, pLevel);
    }

    public AbstractGrenadeProjectile(EntityType<? extends AbstractGrenadeProjectile> pEntityType, LivingEntity pShooter, Level pLevel) {
        super(pEntityType, pShooter, pLevel);
    }

    public GasEmitterEntity getEmitter() {
        try {
            return EmitterUtils.createEmitter(this.getEmitterClass(), this.m_9236_(), this.m_20185_(), this.m_20186_(), this.m_20189_(), 2.5f, 600);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public void explode() {
        try {
            GasEmitterEntity poopgas = this.getEmitter();
            Entity entity = this.m_19749_();
            if (entity instanceof LivingEntity) {
                LivingEntity le = (LivingEntity)entity;
                poopgas.setOwner(le);
                poopgas.setAffectOwner(this.affectOwner);
            }
            this.m_9236_().m_254849_(this.m_19749_(), this.m_20185_(), this.m_20186_(), this.m_20189_(), 0.5f, Level.ExplosionInteraction.NONE);
            this.m_9236_().m_7967_((Entity)poopgas);
            this.m_146870_();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void m_8119_() {
        if (this.lifeTime >= this.maxLifeTime) {
            this.explode();
        }
        ++this.lifeTime;
        super.m_8119_();
    }

    protected void m_8060_(BlockHitResult blockHitResult) {
        if (this.m_9236_().f_46443_) {
            return;
        }
        if (this.isInstaboom()) {
            this.explode();
        }
        Direction hitDirection = blockHitResult.m_82434_();
        Vec3 velocity = this.m_20184_();
        double bounceFactor = 0.24;
        double x = velocity.f_82479_ / 1.4;
        double y = velocity.f_82480_ / 1.4;
        double z = velocity.f_82481_ / 1.4;
        switch (hitDirection.m_122434_()) {
            case X: {
                x = -x * bounceFactor;
                break;
            }
            case Y: {
                y = -y * bounceFactor;
                break;
            }
            case Z: {
                z = -z * bounceFactor;
            }
        }
        this.m_20334_(x, y, z);
    }

    protected void m_5790_(EntityHitResult pResult) {
        if (!(pResult.m_82443_() instanceof AbstractEmitterEntity)) {
            pResult.m_82443_().m_6469_(this.m_269291_().m_269390_((Entity)this, this.m_19749_()), 0.5f);
            this.explode();
        }
        super.m_5790_(pResult);
    }

    public void setLifeTime(int lifeTime) {
        this.lifeTime = lifeTime;
    }

    public int getLifeTime() {
        return this.lifeTime;
    }

    public void setInstaboom(boolean instaboom) {
        this.instaboom = instaboom;
    }

    public boolean isInstaboom() {
        return this.instaboom;
    }

    public void setAffectOwner(boolean pAffectOwner) {
        this.affectOwner = pAffectOwner;
    }
}

