/*
 * Decompiled with CFR 0.152.
 */
package net.svisvi.jigsawpp.entity.rocket;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.UnmodifiableIterator;
import java.util.List;
import net.minecraft.BlockUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.entity.vehicle.DismountHelper;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.CollisionGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.AirBlock;
import net.minecraft.world.level.block.BaseRailBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.PoweredRailBlock;
import net.minecraft.world.level.block.TntBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.IMinecartCollisionHandler;
import net.minecraftforge.registries.ForgeRegistries;
import net.svisvi.jigsawpp.block.init.ModBlocks;
import net.svisvi.jigsawpp.entity.init.ModEntities;
import net.svisvi.jigsawpp.item.init.ModItems;
import net.svisvi.jigsawpp.networking.ModMessages;
import net.svisvi.jigsawpp.networking.packet.SyncRocketDataPacket;
import net.svisvi.jigsawpp.particles.ModParticleTypes;
import net.svisvi.jigsawpp.procedures.radio.IRadioActivatable;
import net.svisvi.jigsawpp.procedures.ut.NuclearShroom;
import org.jetbrains.annotations.Nullable;

public class RocketEntity
extends Entity
implements IRadioActivatable {
    private static final EntityDataAccessor<Integer> DATA_ID_HURT;
    private static final EntityDataAccessor<Integer> DATA_ID_HURTDIR;
    private static final EntityDataAccessor<Float> DATA_ID_DAMAGE;
    private static final EntityDataAccessor<Integer> DATA_ID_DISPLAY_BLOCK;
    private static final EntityDataAccessor<Integer> DATA_ID_DISPLAY_OFFSET;
    private static final EntityDataAccessor<Boolean> DATA_ID_CUSTOM_DISPLAY;
    private static final EntityDataAccessor<ItemStack> DATA_ID_POOPS;
    private static final EntityDataAccessor<ItemStack> DATA_ID_BOMB;
    private static final EntityDataAccessor<ItemStack> DATA_ID_NAMETAG;
    private static final ImmutableMap<Pose, ImmutableList<Integer>> POSE_DISMOUNT_HEIGHTS;
    protected static final float WATER_SLOWDOWN_FACTOR = 0.95f;
    private boolean flipped;
    private boolean onRails;
    private static IMinecartCollisionHandler COLLISIONS;
    private int lSteps;
    private double lx;
    private double ly;
    private double lz;
    private double lyr;
    private double lxr;
    private double lxd;
    private double lyd;
    private double lzd;
    private double lastYd;
    private boolean canBePushed = true;
    private boolean canUseRail = true;
    private float currentSpeedCapOnRail;
    @Nullable
    private Float maxSpeedAirLateral = null;
    private float maxSpeedAirVertical = -1.0f;
    private double dragAir = 0.95f;

    public RocketEntity(EntityType<?> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.f_19850_ = true;
    }

    public RocketEntity(EntityType<?> pEntityType, Level pLevel, double pX, double pY, double pZ) {
        this(pEntityType, pLevel);
        this.m_6034_(pX, pY, pZ);
        this.f_19854_ = pX;
        this.f_19855_ = pY;
        this.f_19856_ = pZ;
    }

    public IMinecartCollisionHandler getCollisionHandler() {
        return COLLISIONS;
    }

    public static void registerCollisionHandler(@javax.annotation.Nullable IMinecartCollisionHandler handler) {
        COLLISIONS = handler;
    }

    public InteractionResult m_6096_(Player pPlayer, InteractionHand pHand) {
        InteractionResult ret;
        if (this.m_9236_().m_5776_()) {
            return InteractionResult.PASS;
        }
        ItemStack handStack = pPlayer.m_21120_(pHand);
        Level level = this.m_9236_();
        if (handStack.m_150930_((Item)ModItems.POOPS.get())) {
            if (this.getPoops().m_41619_()) {
                String poopsName = RocketEntity.getItemStackName(handStack);
                if (RocketEntity.validatePoopsName(poopsName)) {
                    if (!level.m_5776_()) {
                        ItemStack poopsCopy = new ItemStack((ItemLike)ModItems.POOPS.get());
                        poopsCopy.m_41714_((Component)Component.m_237113_((String)poopsName));
                        handStack.m_41774_(1);
                        this.setPoops(poopsCopy);
                        this.correctReaction();
                        this.syncEntity();
                    }
                    return InteractionResult.m_19078_((boolean)level.m_5776_());
                }
                if (!level.m_5776_()) {
                    this.incorrectReaction();
                }
                return InteractionResult.FAIL;
            }
            if (!level.m_5776_()) {
                this.incorrectReaction();
            }
            return InteractionResult.FAIL;
        }
        if (handStack.m_150930_(Items.f_42574_)) {
            if (!this.getPoops().m_41619_()) {
                if (!level.m_5776_()) {
                    handStack.m_41622_(1, (LivingEntity)pPlayer, player -> player.m_21190_(pHand));
                    pPlayer.m_36356_(this.getPoops().m_41777_());
                    this.setPoops(ItemStack.f_41583_);
                    this.shears();
                    this.syncEntity();
                }
                return InteractionResult.m_19078_((boolean)level.m_5776_());
            }
            if (!this.getBomb().m_41619_()) {
                if (!level.m_5776_()) {
                    handStack.m_41622_(1, (LivingEntity)pPlayer, player -> player.m_21190_(pHand));
                    pPlayer.m_36356_(this.getBomb().m_41777_());
                    this.setBomb(ItemStack.f_41583_);
                    this.shears();
                    this.syncEntity();
                }
                return InteractionResult.m_19078_((boolean)level.m_5776_());
            }
            if (!this.getNameTagItem().m_41619_()) {
                if (!level.m_5776_()) {
                    handStack.m_41622_(1, (LivingEntity)pPlayer, player -> player.m_21190_(pHand));
                    pPlayer.m_36356_(this.getNameTagItem().m_41777_());
                    this.setNameTagItem(ItemStack.f_41583_);
                    this.shears();
                    this.syncEntity();
                }
                return InteractionResult.m_19078_((boolean)level.m_5776_());
            }
        } else {
            BlockItem blockItem;
            Object poopsName = handStack.m_41720_();
            if (poopsName instanceof BlockItem && (blockItem = (BlockItem)poopsName).m_40614_() instanceof TntBlock) {
                if (this.getBomb().m_41619_()) {
                    if (!level.m_5776_()) {
                        ItemStack tntStack = new ItemStack((ItemLike)blockItem);
                        handStack.m_41774_(1);
                        this.setBomb(tntStack);
                        this.correctReaction();
                        this.syncEntity();
                    }
                    return InteractionResult.m_19078_((boolean)level.m_5776_());
                }
                if (!level.m_5776_()) {
                    this.incorrectReaction();
                }
                return InteractionResult.FAIL;
            }
            if (handStack.m_150930_(Items.f_42656_)) {
                if (this.getNameTagItem().m_41619_()) {
                    if (!level.m_5776_()) {
                        poopsName = RocketEntity.getItemStackName(handStack);
                        ItemStack poopsCopy = new ItemStack((ItemLike)Items.f_42656_);
                        poopsCopy.m_41714_((Component)Component.m_237113_((String)poopsName));
                        handStack.m_41774_(1);
                        this.setNameTagItem(poopsCopy);
                        this.correctReaction();
                        this.syncEntity();
                    }
                    return InteractionResult.m_19078_((boolean)level.m_5776_());
                }
                if (!level.m_5776_()) {
                    this.incorrectReaction();
                }
                return InteractionResult.FAIL;
            }
        }
        if ((ret = super.m_6096_(pPlayer, pHand)).m_19077_()) {
            return ret;
        }
        if (!(level.m_5776_() || pPlayer.m_36341_() || this.m_20160_())) {
            return pPlayer.m_20329_((Entity)this) ? InteractionResult.CONSUME : InteractionResult.PASS;
        }
        return InteractionResult.PASS;
    }

    private void oldsyncEntity() {
        if (!this.m_9236_().m_5776_()) {
            this.m_20088_().m_135381_(DATA_ID_POOPS, (Object)this.getPoops());
            this.m_20088_().m_135381_(DATA_ID_BOMB, (Object)this.getBomb());
            this.m_20088_().m_135381_(DATA_ID_NAMETAG, (Object)this.getNameTagItem());
            Packet packet = this.m_5654_();
            if (packet != null) {
                ((ServerLevel)this.m_9236_()).m_7726_().m_8445_((Entity)this, packet);
            }
        }
    }

    private void syncEntity() {
        if (!this.m_9236_().m_5776_()) {
            this.m_20088_().m_135381_(DATA_ID_POOPS, (Object)this.getPoops());
            this.m_20088_().m_135381_(DATA_ID_BOMB, (Object)this.getBomb());
            this.m_20088_().m_135381_(DATA_ID_NAMETAG, (Object)this.getNameTagItem());
            this.f_19812_ = true;
        }
    }

    public void m_7350_(EntityDataAccessor<?> key) {
        super.m_7350_(key);
        if ((DATA_ID_POOPS.equals(key) || DATA_ID_BOMB.equals(key) || DATA_ID_NAMETAG.equals(key)) && this.m_9236_().f_46443_) {
            this.m_9236_().m_7260_(this.m_20183_(), this.m_9236_().m_8055_(this.m_20183_()), this.m_9236_().m_8055_(this.m_20183_()), 3);
        }
    }

    public static RocketEntity createChair(Level pLevel, double pX, double pY, double pZ) {
        return new RocketEntity((EntityType)ModEntities.ROCKET.get(), pLevel, pX, pY, pZ);
    }

    protected Entity.MovementEmission m_142319_() {
        return Entity.MovementEmission.EVENTS;
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(DATA_ID_HURT, (Object)0);
        this.f_19804_.m_135372_(DATA_ID_HURTDIR, (Object)1);
        this.f_19804_.m_135372_(DATA_ID_DAMAGE, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(DATA_ID_DISPLAY_BLOCK, (Object)Block.m_49956_((BlockState)Blocks.f_50016_.m_49966_()));
        this.f_19804_.m_135372_(DATA_ID_DISPLAY_OFFSET, (Object)6);
        this.f_19804_.m_135372_(DATA_ID_CUSTOM_DISPLAY, (Object)false);
        this.f_19804_.m_135372_(DATA_ID_POOPS, (Object)ItemStack.f_41583_);
        this.f_19804_.m_135372_(DATA_ID_BOMB, (Object)ItemStack.f_41583_);
        this.f_19804_.m_135372_(DATA_ID_NAMETAG, (Object)ItemStack.f_41583_);
    }

    public boolean m_7337_(Entity pEntity) {
        return Boat.m_38323_((Entity)this, (Entity)pEntity);
    }

    public boolean m_5829_() {
        return true;
    }

    public boolean m_6094_() {
        return this.canBePushed;
    }

    protected Vec3 m_7643_(Direction.Axis pAxis, BlockUtil.FoundRectangle pPortal) {
        return LivingEntity.m_21289_((Vec3)super.m_7643_(pAxis, pPortal));
    }

    public double m_6048_() {
        return super.m_6048_() + (double)0.2f;
    }

    public Vec3 m_7688_(LivingEntity pLivingEntity) {
        Direction direction = this.m_6374_();
        if (direction.m_122434_() == Direction.Axis.Y) {
            return super.m_7688_(pLivingEntity);
        }
        int[][] aint = DismountHelper.m_38467_((Direction)direction);
        BlockPos blockpos = this.m_20183_();
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
        ImmutableList immutablelist = pLivingEntity.m_7431_();
        for (Pose pose : immutablelist) {
            EntityDimensions entitydimensions = pLivingEntity.m_6972_(pose);
            float f = Math.min(entitydimensions.f_20377_, 1.0f) / 2.0f;
            UnmodifiableIterator var11 = ((ImmutableList)POSE_DISMOUNT_HEIGHTS.get((Object)pose)).iterator();
            while (var11.hasNext()) {
                int i = (Integer)var11.next();
                int[][] var13 = aint;
                int var14 = aint.length;
                for (int var15 = 0; var15 < var14; ++var15) {
                    int[] aint1 = var13[var15];
                    blockpos$mutableblockpos.m_122178_(blockpos.m_123341_() + aint1[0], blockpos.m_123342_() + i, blockpos.m_123343_() + aint1[1]);
                    double d0 = this.m_9236_().m_45564_(DismountHelper.m_38446_((BlockGetter)this.m_9236_(), (BlockPos)blockpos$mutableblockpos), () -> DismountHelper.m_38446_((BlockGetter)this.m_9236_(), (BlockPos)blockpos$mutableblockpos.m_7495_()));
                    if (!DismountHelper.m_38439_((double)d0)) continue;
                    AABB aabb = new AABB((double)(-f), 0.0, (double)(-f), (double)f, (double)entitydimensions.f_20378_, (double)f);
                    Vec3 vec3 = Vec3.m_82514_((Vec3i)blockpos$mutableblockpos, (double)d0);
                    if (!DismountHelper.m_38456_((CollisionGetter)this.m_9236_(), (LivingEntity)pLivingEntity, (AABB)aabb.m_82383_(vec3))) continue;
                    pLivingEntity.m_20124_(pose);
                    return vec3;
                }
            }
        }
        double d1 = this.m_20191_().f_82292_;
        blockpos$mutableblockpos.m_122169_((double)blockpos.m_123341_(), d1, (double)blockpos.m_123343_());
        for (Pose pose1 : immutablelist) {
            double d2 = pLivingEntity.m_6972_((Pose)pose1).f_20378_;
            int j = Mth.m_14165_((double)(d1 - (double)blockpos$mutableblockpos.m_123342_() + d2));
            double d3 = DismountHelper.m_38463_((BlockPos)blockpos$mutableblockpos, (int)j, p_289495_ -> this.m_9236_().m_8055_(p_289495_).m_60812_((BlockGetter)this.m_9236_(), p_289495_));
            if (!(d1 + d2 <= d3)) continue;
            pLivingEntity.m_20124_(pose1);
            break;
        }
        return super.m_7688_(pLivingEntity);
    }

    public boolean m_6469_(DamageSource pSource, float pAmount) {
        if (!this.m_9236_().f_46443_ && !this.m_213877_()) {
            boolean flag;
            if (this.m_6673_(pSource)) {
                return false;
            }
            this.setHurtDir(-this.getHurtDir());
            this.setHurtTime(10);
            this.m_5834_();
            this.setDamage(this.getDamage() + pAmount * 10.0f);
            this.m_146852_(GameEvent.f_223706_, pSource.m_7639_());
            boolean bl = flag = pSource.m_7639_() instanceof Player && ((Player)pSource.m_7639_()).m_150110_().f_35937_;
            if (flag || this.getDamage() > 40.0f) {
                this.m_20153_();
                if (flag && !this.m_8077_()) {
                    this.m_146870_();
                } else {
                    this.destroy(pSource);
                }
            }
            return true;
        }
        return true;
    }

    @javax.annotation.Nullable
    public Vec3 getPosOffs(double pX, double pY, double pZ, double pOffset) {
        return null;
    }

    @javax.annotation.Nullable
    public Vec3 getPos(double pX, double pY, double pZ) {
        return null;
    }

    public void destroy(DamageSource pDamageSource) {
        this.m_6074_();
        if (this.m_9236_().m_46469_().m_46207_(GameRules.f_46137_)) {
            ItemStack rocketStack = new ItemStack((ItemLike)this.getDropItem());
            if (this.m_8077_()) {
                rocketStack.m_41714_(this.m_7770_());
            }
            this.m_19983_(rocketStack);
            if (!this.getPoops().m_41619_()) {
                this.m_19983_(this.getPoops().m_41777_());
            }
            if (!this.getBomb().m_41619_()) {
                this.m_19983_(this.getBomb().m_41777_());
            }
            if (!this.getNameTagItem().m_41619_()) {
                this.m_19983_(this.getNameTagItem().m_41777_());
            }
            this.setPoops(ItemStack.f_41583_);
            this.setBomb(ItemStack.f_41583_);
            this.setNameTagItem(ItemStack.f_41583_);
        }
    }

    protected void clampRotation(Entity pEntityToUpdate) {
        pEntityToUpdate.m_5618_(this.m_146908_());
        float f = Mth.m_14177_((float)(pEntityToUpdate.m_146908_() - this.m_146908_()));
        float f1 = Mth.m_14036_((float)f, (float)-105.0f, (float)105.0f);
        pEntityToUpdate.f_19859_ += f1 - f;
        pEntityToUpdate.m_146922_(pEntityToUpdate.m_146908_() + f1 - f);
        pEntityToUpdate.m_5616_(pEntityToUpdate.m_146908_());
    }

    public void m_7340_(Entity pEntityToUpdate) {
        this.clampRotation(pEntityToUpdate);
    }

    public Item getDropItem() {
        return (Item)ModItems.ROCKET.get();
    }

    public void m_6053_(float pYaw) {
        this.setHurtDir(-this.getHurtDir());
        this.setHurtTime(10);
        this.setDamage(this.getDamage() + this.getDamage() * 10.0f);
    }

    public boolean m_6087_() {
        return !this.m_213877_();
    }

    public Direction m_6374_() {
        return this.flipped ? this.m_6350_().m_122424_().m_122427_() : this.m_6350_().m_122427_();
    }

    public void m_8119_() {
        this.legacyTick();
        if (this.getHurtTime() > 0) {
            this.setHurtTime(this.getHurtTime() - 1);
        }
        if (this.getDamage() > 0.0f) {
            this.setDamage(this.getDamage() - 1.0f);
        }
        this.m_146871_();
        this.m_20157_();
        if (this.m_9236_().f_46443_) {
            if (this.lSteps > 0) {
                double d5 = this.m_20185_() + (this.lx - this.m_20185_()) / (double)this.lSteps;
                double d6 = this.m_20186_() + (this.ly - this.m_20186_()) / (double)this.lSteps;
                double d7 = this.m_20189_() + (this.lz - this.m_20189_()) / (double)this.lSteps;
                double d2 = Mth.m_14175_((double)(this.lyr - (double)this.m_146908_()));
                this.m_146922_(this.m_146908_() + (float)d2 / (float)this.lSteps);
                this.m_146926_(this.m_146909_() + (float)(this.lxr - (double)this.m_146909_()) / (float)this.lSteps);
                --this.lSteps;
                this.m_6034_(d5, d6, d7);
                this.m_19915_(this.m_146908_(), this.m_146909_());
            } else {
                this.m_20090_();
                this.m_19915_(this.m_146908_(), this.m_146909_());
            }
        } else {
            double d4;
            if (!this.m_20068_()) {
                double d5 = this.m_20069_() ? -0.005 : -0.04;
                this.m_20256_(this.m_20184_().m_82520_(0.0, d5, 0.0));
            }
            int k = Mth.m_14107_((double)this.m_20185_());
            int i = Mth.m_14107_((double)this.m_20186_());
            int j = Mth.m_14107_((double)this.m_20189_());
            if (this.m_9236_().m_8055_(new BlockPos(k, i - 1, j)).m_204336_(BlockTags.f_13034_)) {
                --i;
            }
            BlockPos blockpos = new BlockPos(k, i, j);
            BlockState blockstate = this.m_9236_().m_8055_(blockpos);
            this.onRails = BaseRailBlock.m_49416_((BlockState)blockstate);
            if (this.canUseRail() && this.onRails) {
                if (blockstate.m_60734_() instanceof PoweredRailBlock && ((PoweredRailBlock)blockstate.m_60734_()).isActivatorRail()) {
                    this.activateMinecart(k, i, j, (Boolean)blockstate.m_61143_((Property)PoweredRailBlock.f_55215_));
                }
            } else {
                this.comeOffTrack();
            }
            this.m_20101_();
            this.m_146926_(0.0f);
            double d1 = this.f_19854_ - this.m_20185_();
            double d3 = this.f_19856_ - this.m_20189_();
            if (d1 * d1 + d3 * d3 > 0.001) {
                this.m_146922_((float)(Mth.m_14136_((double)d3, (double)d1) * 180.0 / Math.PI));
                if (this.flipped) {
                    this.m_146922_(this.m_146908_() + 180.0f);
                }
            }
            if ((d4 = (double)Mth.m_14177_((float)(this.m_146908_() - this.f_19859_))) < -170.0 || d4 >= 170.0) {
                this.m_146922_(this.m_146908_() + 180.0f);
                this.flipped = !this.flipped;
            }
            this.m_19915_(this.m_146908_(), this.m_146909_());
            AABB box = this.getCollisionHandler() != null ? this.m_20191_() : this.m_20191_().m_82377_((double)0.2f, 0.0, (double)0.2f);
            if (this.m_20184_().m_165925_() > 0.01) {
                List list = this.m_9236_().m_6249_((Entity)this, box, EntitySelector.m_20421_((Entity)this));
                if (!list.isEmpty()) {
                    for (int l = 0; l < list.size(); ++l) {
                        Entity entity1 = (Entity)list.get(l);
                        if (!(entity1 instanceof Player || entity1 instanceof IronGolem || entity1 instanceof AbstractMinecart || this.m_20160_() || entity1.m_20159_())) {
                            entity1.m_20329_((Entity)this);
                            continue;
                        }
                        entity1.m_7334_((Entity)this);
                    }
                }
            } else {
                for (Entity entity : this.m_9236_().m_45933_((Entity)this, box)) {
                    if (this.m_20363_(entity) || !entity.m_6094_() || !(entity instanceof AbstractMinecart)) continue;
                    entity.m_7334_((Entity)this);
                }
            }
            this.m_20073_();
            if (this.m_20077_()) {
                this.m_20093_();
                this.f_19789_ *= 0.5f;
            }
            this.f_19803_ = false;
        }
    }

    public void explode() {
        if (!this.m_9236_().m_5776_()) {
            BlockItem blockItem;
            Item item;
            this.m_9236_().m_254849_((Entity)this, this.m_20185_(), this.m_20186_(), this.m_20189_(), 3.0f, Level.ExplosionInteraction.TNT);
            Level level = this.m_9236_();
            if (level instanceof ServerLevel) {
                ServerLevel slevel = (ServerLevel)level;
                NuclearShroom.sendFarParticles(slevel, (ParticleOptions)ParticleTypes.f_123813_, this.m_20185_(), this.m_20186_(), this.m_20189_(), 7.0, 7.0, 7.0, 100, 0.0);
            }
            if (!this.getBomb().m_41619_() && (item = this.getBomb().m_41720_()) instanceof BlockItem && (item = (blockItem = (BlockItem)item).m_40614_()) instanceof TntBlock) {
                TntBlock tnt = (TntBlock)item;
                tnt.onCaughtFire(blockItem.m_40614_().m_49966_(), this.m_9236_(), this.m_20097_().m_7494_(), null, null);
            }
        }
        this.m_146870_();
    }

    public void land() {
        if (!this.getBomb().m_41619_()) {
            this.explode();
            return;
        }
        if (!this.m_9236_().f_46443_) {
            this.getPersistentData().m_128379_("fused", false);
            this.getPersistentData().m_128379_("fall_rocket", false);
            this.getPersistentData().m_128347_("rocket_counter1", 0.0);
            ModMessages.sendToTrackingEntity(new SyncRocketDataPacket(this.m_19879_(), this.getPersistentData()), this);
        }
    }

    public void legacyTick() {
        if (this == null) {
            return;
        }
        double x = this.m_20185_();
        double y = this.m_20186_();
        double z = this.m_20189_();
        BlockPos thisPos = BlockPos.m_274561_((double)x, (double)y, (double)z);
        if (this.m_20184_().m_7098_() == 0.0 && this.getPersistentData().m_128471_("fused") && !this.getPersistentData().m_128471_("fall_rocket") && this.getPersistentData().m_128459_("rocket_counter1") > 210.0) {
            this.explode();
        }
        if (this.getPersistentData().m_128471_("fused") && !this.getPersistentData().m_128471_("fall_rocket")) {
            this.getPersistentData().m_128347_("rocket_counter1", this.getPersistentData().m_128459_("rocket_counter1") + 1.0);
            if (this.getPersistentData().m_128459_("rocket_counter1") >= 200.0) {
                ServerLevel _level;
                this.m_20256_(new Vec3(this.m_20184_().m_7096_(), 0.4, this.m_20184_().m_7094_()));
                Level level = this.m_9236_();
                if (level instanceof ServerLevel) {
                    _level = (ServerLevel)level;
                    _level.m_8767_((ParticleOptions)ParticleTypes.f_123744_, x, y - 2.8, z, 60, 0.1, 1.4, 0.1, 0.1);
                }
                if ((level = this.m_9236_()) instanceof ServerLevel) {
                    _level = (ServerLevel)level;
                    _level.m_8767_((ParticleOptions)((SimpleParticleType)ModParticleTypes.POOP.get()), x, y - 4.0, z, 80, 0.3, 2.0, 0.3, 0.1);
                }
                if (this.getPersistentData().m_128459_("rocket_counter1") % 5.0 == 0.0) {
                    if (!this.m_9236_().m_5776_()) {
                        this.m_9236_().m_5594_(null, thisPos, (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("entity.cow.milk")), SoundSource.BLOCKS, 1.0f, -1.0f);
                    } else {
                        this.m_9236_().m_7785_(x, y, z, (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("entity.cow.milk")), SoundSource.BLOCKS, 1.0f, -1.0f, false);
                    }
                    if (this.m_9236_().m_8055_(thisPos).m_60734_() instanceof AirBlock && this.m_20184_().m_7098_() > 0.0 && !this.getPersistentData().m_128471_("fall_rocket") && (level = this.m_9236_()) instanceof ServerLevel) {
                        _level = (ServerLevel)level;
                        _level.m_7731_(thisPos, ((LiquidBlock)ModBlocks.PONOS_FLUID_BLOCK.get()).m_49966_(), 3);
                    }
                }
                if (y >= 319.0) {
                    ItemStack poops = this.getPoops();
                    if (!poops.m_41619_()) {
                        BlockPos tpPos = RocketEntity.parsePoopsCoords(RocketEntity.getItemStackName(poops));
                        Entity entity = this.m_146895_();
                        if (entity instanceof Player) {
                            Player player = (Player)entity;
                            this.m_20153_();
                            if (player instanceof ServerPlayer) {
                                ServerPlayer splayer = (ServerPlayer)player;
                                splayer.f_8906_.m_9774_((double)tpPos.m_123341_(), this.m_20186_() - 1.0, (double)tpPos.m_123343_(), splayer.m_146908_(), splayer.m_146909_());
                            } else {
                                player.m_6021_((double)tpPos.m_123341_(), this.m_20186_() - 1.0, (double)tpPos.m_123343_());
                            }
                            player.m_7998_((Entity)this, true);
                        }
                        this.m_6021_(tpPos.m_123341_(), this.m_20186_() - 1.0, tpPos.m_123343_());
                        this.getPersistentData().m_128379_("fall_rocket", true);
                    } else {
                        this.explode();
                    }
                }
            } else {
                Level level = this.m_9236_();
                if (level instanceof ServerLevel) {
                    ServerLevel _level = (ServerLevel)level;
                    _level.m_8767_((ParticleOptions)ParticleTypes.f_123759_, x, y, z, 60, 2.0, 0.4, 2.0, 0.1);
                }
                if (this.getPersistentData().m_128459_("rocket_counter1") % 5.0 == 0.0) {
                    if (!this.m_9236_().m_5776_()) {
                        this.m_9236_().m_5594_(null, thisPos, (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("block.wool.break")), SoundSource.BLOCKS, 1.0f, -1.0f);
                    } else {
                        this.m_9236_().m_7785_(x, y, z, (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("block.wool.break")), SoundSource.BLOCKS, 1.0f, -1.0f, false);
                    }
                }
            }
        } else if (this.getPersistentData().m_128471_("fused") && this.getPersistentData().m_128471_("fall_rocket")) {
            this.m_20256_(new Vec3(this.m_20184_().m_7096_(), -1.4, this.m_20184_().m_7094_()));
            this.m_20254_(1);
            Level level = this.m_9236_();
            if (level instanceof ServerLevel) {
                ServerLevel _level = (ServerLevel)level;
                _level.m_8767_((ParticleOptions)ParticleTypes.f_123744_, x, y + 2.3, z, 30, 0.1, 1.4, 0.1, 0.1);
            }
            if (this.m_20096_()) {
                this.land();
            }
        }
    }

    protected void m_7840_(double pY, boolean pOnGround, BlockState pState, BlockPos pPos) {
        this.lastYd = this.m_20184_().f_82480_;
        if (!this.m_20159_()) {
            if (pOnGround) {
                if (this.f_19789_ > 3.0f) {
                    if (!this.m_20096_()) {
                        this.m_183634_();
                        return;
                    }
                    this.m_142535_(this.f_19789_, 1.0f, this.m_269291_().m_268989_());
                    if (!this.m_9236_().f_46443_ && !this.m_213877_()) {
                        this.m_6074_();
                        if (this.m_9236_().m_46469_().m_46207_(GameRules.f_46137_)) {
                            this.m_19983_(this.m_142340_());
                        }
                    }
                }
                this.m_183634_();
            } else if (this.m_20096_() && pY < 0.0) {
                this.f_19789_ -= (float)pY;
            }
        }
    }

    protected double getMaxSpeed() {
        return (this.m_20069_() ? 4.0 : 8.0) / 20.0;
    }

    public void activateMinecart(int pX, int pY, int pZ, boolean pPowered) {
    }

    protected void comeOffTrack() {
        double d0 = this.m_20096_() ? this.getMaxSpeed() : (double)this.getMaxSpeedAirLateral();
        Vec3 vec3 = this.m_20184_();
        this.m_20334_(Mth.m_14008_((double)vec3.f_82479_, (double)(-d0), (double)d0), vec3.f_82480_, Mth.m_14008_((double)vec3.f_82481_, (double)(-d0), (double)d0));
        if (this.m_20096_()) {
            this.m_20256_(this.m_20184_().m_82490_(0.5));
        }
        if (this.getMaxSpeedAirVertical() > 0.0f && this.m_20184_().f_82480_ > (double)this.getMaxSpeedAirVertical()) {
            if (Math.abs(this.m_20184_().f_82479_) < (double)0.3f && Math.abs(this.m_20184_().f_82481_) < (double)0.3f) {
                this.m_20256_(new Vec3(this.m_20184_().f_82479_, (double)0.15f, this.m_20184_().f_82481_));
            } else {
                this.m_20256_(new Vec3(this.m_20184_().f_82479_, (double)this.getMaxSpeedAirVertical(), this.m_20184_().f_82481_));
            }
        }
        this.m_6478_(MoverType.SELF, this.m_20184_());
        if (!this.m_20096_()) {
            this.m_20256_(this.m_20184_().m_82490_(this.getDragAir()));
        }
    }

    public boolean m_288188_() {
        return this.onRails;
    }

    public AABB m_6921_() {
        AABB aabb = this.m_20191_();
        return this.hasCustomDisplay() ? aabb.m_82400_((double)Math.abs(this.getDisplayOffset()) / 16.0) : aabb;
    }

    protected void m_7378_(CompoundTag pCompound) {
        if (pCompound.m_128471_("CustomDisplayTile")) {
            this.setDisplayBlockState(NbtUtils.m_247651_((HolderGetter)this.m_9236_().m_246945_(Registries.f_256747_), (CompoundTag)pCompound.m_128469_("DisplayState")));
            this.setDisplayOffset(pCompound.m_128451_("DisplayOffset"));
        }
        if (pCompound.m_128441_("Poops")) {
            this.setPoops(ItemStack.m_41712_((CompoundTag)pCompound.m_128469_("Poops")));
        }
        if (pCompound.m_128441_("Bomb")) {
            this.setBomb(ItemStack.m_41712_((CompoundTag)pCompound.m_128469_("Bomb")));
        }
        if (pCompound.m_128441_("Nametag")) {
            this.setNameTagItem(ItemStack.m_41712_((CompoundTag)pCompound.m_128469_("Nametag")));
        }
    }

    protected void m_7380_(CompoundTag pCompound) {
        if (this.hasCustomDisplay()) {
            pCompound.m_128379_("CustomDisplayTile", true);
            pCompound.m_128365_("DisplayState", (Tag)NbtUtils.m_129202_((BlockState)this.getDisplayBlockState()));
            pCompound.m_128405_("DisplayOffset", this.getDisplayOffset());
        }
        if (!this.getPoops().m_41619_()) {
            pCompound.m_128365_("Poops", (Tag)this.getPoops().m_41739_(new CompoundTag()));
        }
        if (!this.getBomb().m_41619_()) {
            pCompound.m_128365_("Bomb", (Tag)this.getBomb().m_41739_(new CompoundTag()));
        }
        if (!this.getNameTagItem().m_41619_()) {
            pCompound.m_128365_("Nametag", (Tag)this.getNameTagItem().m_41739_(new CompoundTag()));
        }
    }

    public void m_7334_(Entity pEntity) {
        double d1;
        double d0;
        double d2;
        if (!(this.getCollisionHandler() != null || this.m_9236_().f_46443_ || pEntity.f_19794_ || this.f_19794_ || this.m_20363_(pEntity) || !((d2 = (d0 = pEntity.m_20185_() - this.m_20185_()) * d0 + (d1 = pEntity.m_20189_() - this.m_20189_()) * d1) >= (double)1.0E-4f))) {
            d2 = Math.sqrt(d2);
            d0 /= d2;
            d1 /= d2;
            double d3 = 1.0 / d2;
            if (d3 > 1.0) {
                d3 = 1.0;
            }
            d0 *= d3;
            d1 *= d3;
            d0 *= (double)0.1f;
            d1 *= (double)0.1f;
            d0 *= 0.5;
            d1 *= 0.5;
            if (pEntity instanceof RocketEntity) {
                Vec3 vec31;
                double d5;
                double d4 = pEntity.m_20185_() - this.m_20185_();
                Vec3 vec3 = new Vec3(d4, 0.0, d5 = pEntity.m_20189_() - this.m_20189_()).m_82541_();
                double d6 = Math.abs(vec3.m_82526_(vec31 = new Vec3((double)Mth.m_14089_((float)(this.m_146908_() * ((float)Math.PI / 180))), 0.0, (double)Mth.m_14031_((float)(this.m_146908_() * ((float)Math.PI / 180)))).m_82541_()));
                if (d6 < (double)0.8f) {
                    return;
                }
                Vec3 vec32 = this.m_20184_();
                Vec3 vec33 = pEntity.m_20184_();
                double d7 = (vec33.f_82479_ + vec32.f_82479_) / 2.0;
                double d8 = (vec33.f_82481_ + vec32.f_82481_) / 2.0;
                this.m_20256_(vec32.m_82542_(0.2, 1.0, 0.2));
                this.m_5997_(d7 - d0, 0.0, d8 - d1);
                pEntity.m_20256_(vec33.m_82542_(0.2, 1.0, 0.2));
                pEntity.m_5997_(d7 + d0, 0.0, d8 + d1);
            } else {
                this.m_5997_(-d0, 0.0, -d1);
                pEntity.m_5997_(d0 / 4.0, 0.0, d1 / 4.0);
            }
        }
    }

    public void m_6453_(double pX, double pY, double pZ, float pYaw, float pPitch, int pPosRotationIncrements, boolean pTeleport) {
        this.lx = pX;
        this.ly = pY;
        this.lz = pZ;
        this.lyr = pYaw;
        this.lxr = pPitch;
        this.lSteps = pPosRotationIncrements + 2;
        this.m_20334_(this.lxd, this.lyd, this.lzd);
    }

    public void m_6001_(double pX, double pY, double pZ) {
        this.lxd = pX;
        this.lyd = pY;
        this.lzd = pZ;
        this.m_20334_(this.lxd, this.lyd, this.lzd);
    }

    public void setDamage(float pDamage) {
        this.f_19804_.m_135381_(DATA_ID_DAMAGE, (Object)Float.valueOf(pDamage));
    }

    public float getDamage() {
        return ((Float)this.f_19804_.m_135370_(DATA_ID_DAMAGE)).floatValue();
    }

    public void setHurtTime(int pHurtTime) {
        this.f_19804_.m_135381_(DATA_ID_HURT, (Object)pHurtTime);
    }

    public int getHurtTime() {
        return (Integer)this.f_19804_.m_135370_(DATA_ID_HURT);
    }

    public void setHurtDir(int pHurtDirection) {
        this.f_19804_.m_135381_(DATA_ID_HURTDIR, (Object)pHurtDirection);
    }

    public int getHurtDir() {
        return (Integer)this.f_19804_.m_135370_(DATA_ID_HURTDIR);
    }

    public BlockState getDisplayBlockState() {
        return !this.hasCustomDisplay() ? this.getDefaultDisplayBlockState() : Block.m_49803_((int)((Integer)this.m_20088_().m_135370_(DATA_ID_DISPLAY_BLOCK)));
    }

    public BlockState getDefaultDisplayBlockState() {
        return Blocks.f_50016_.m_49966_();
    }

    public int getDisplayOffset() {
        return !this.hasCustomDisplay() ? this.getDefaultDisplayOffset() : ((Integer)this.m_20088_().m_135370_(DATA_ID_DISPLAY_OFFSET)).intValue();
    }

    public int getDefaultDisplayOffset() {
        return 6;
    }

    public void setDisplayBlockState(BlockState pDisplayState) {
        this.m_20088_().m_135381_(DATA_ID_DISPLAY_BLOCK, (Object)Block.m_49956_((BlockState)pDisplayState));
        this.setCustomDisplay(true);
    }

    public void setDisplayOffset(int pDisplayOffset) {
        this.m_20088_().m_135381_(DATA_ID_DISPLAY_OFFSET, (Object)pDisplayOffset);
        this.setCustomDisplay(true);
    }

    public boolean hasCustomDisplay() {
        return (Boolean)this.m_20088_().m_135370_(DATA_ID_CUSTOM_DISPLAY);
    }

    public void setCustomDisplay(boolean pCustomDisplay) {
        this.m_20088_().m_135381_(DATA_ID_CUSTOM_DISPLAY, (Object)pCustomDisplay);
    }

    public static String getItemStackName(ItemStack stack) {
        String name = stack.m_41611_().getString();
        if (name.startsWith("[") && name.endsWith("]")) {
            name = name.substring(1, name.length() - 1);
        }
        return name;
    }

    public String getNameTag() {
        if (this.getNameTagItem().m_41619_()) {
            return null;
        }
        return RocketEntity.getItemStackName(this.getNameTagItem());
    }

    public Component m_5446_() {
        return Component.m_237113_((String)(this.getNameTag() != null ? this.getNameTag() : "Rocket"));
    }

    public static boolean validatePoopsName(String string) {
        return RocketEntity.parsePoopsCoords(string) != null;
    }

    public static BlockPos parsePoopsCoords(String poopsName) {
        if (poopsName == null || poopsName.trim().isEmpty()) {
            return null;
        }
        String clean = poopsName.replaceAll("\\s+", "");
        String[] parts = clean.split(",");
        if (parts.length != 2) {
            return null;
        }
        try {
            int x = Integer.parseInt(parts[0]);
            int z = Integer.parseInt(parts[1]);
            if (Math.abs(x) > 30000000 || Math.abs(z) > 30000000) {
                return null;
            }
            return new BlockPos(x, 0, z);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public void incorrectReaction() {
        if (!this.m_9236_().m_5776_()) {
            this.m_9236_().m_5594_(null, this.m_20097_().m_6630_(2), SoundEvents.f_11668_, SoundSource.NEUTRAL, 1.0f, 0.0f);
        } else {
            this.m_9236_().m_245747_(this.m_20097_().m_6630_(2), SoundEvents.f_11668_, SoundSource.NEUTRAL, 1.0f, 0.0f, false);
        }
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel _level = (ServerLevel)level;
            _level.m_8767_((ParticleOptions)ParticleTypes.f_123792_, this.m_20185_(), this.m_20186_() + 2.0, this.m_20189_(), 30, 0.2, 0.4, 0.2, 1.0);
        }
    }

    public void correctReaction() {
        if (!this.m_9236_().m_5776_()) {
            this.m_9236_().m_5594_(null, this.m_20097_().m_6630_(2), SoundEvents.f_11871_, SoundSource.NEUTRAL, 1.0f, 0.0f);
        } else {
            this.m_9236_().m_245747_(this.m_20097_().m_6630_(2), SoundEvents.f_11871_, SoundSource.NEUTRAL, 1.0f, 0.0f, false);
        }
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel _level = (ServerLevel)level;
            _level.m_8767_((ParticleOptions)ParticleTypes.f_175830_, this.m_20185_(), this.m_20186_() + 2.0, this.m_20189_(), 30, 0.2, 0.4, 0.2, 1.0);
        }
    }

    public void shears() {
        if (!this.m_9236_().m_5776_()) {
            this.m_9236_().m_5594_(null, this.m_20097_().m_6630_(2), SoundEvents.f_12344_, SoundSource.NEUTRAL, 1.0f, 0.0f);
        } else {
            this.m_9236_().m_245747_(this.m_20097_().m_6630_(2), SoundEvents.f_12344_, SoundSource.NEUTRAL, 1.0f, 0.0f, false);
        }
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel _level = (ServerLevel)level;
            _level.m_8767_((ParticleOptions)ParticleTypes.f_175830_, this.m_20185_(), this.m_20186_() + 2.0, this.m_20189_(), 30, 0.2, 0.4, 0.2, 1.0);
        }
    }

    public ItemStack getPoops() {
        return (ItemStack)this.f_19804_.m_135370_(DATA_ID_POOPS);
    }

    public void setPoops(ItemStack stack) {
        ItemStack copy = stack.m_41777_();
        copy.m_41764_(1);
        this.f_19804_.m_135381_(DATA_ID_POOPS, (Object)copy);
        this.syncEntity();
    }

    public ItemStack getBomb() {
        return (ItemStack)this.f_19804_.m_135370_(DATA_ID_BOMB);
    }

    public void setBomb(ItemStack stack) {
        ItemStack copy = stack.m_41777_();
        copy.m_41764_(1);
        this.f_19804_.m_135381_(DATA_ID_BOMB, (Object)copy);
        this.syncEntity();
    }

    public ItemStack getNameTagItem() {
        return (ItemStack)this.f_19804_.m_135370_(DATA_ID_NAMETAG);
    }

    public void setNameTagItem(ItemStack stack) {
        ItemStack copy = stack.m_41777_();
        copy.m_41764_(1);
        this.f_19804_.m_135381_(DATA_ID_NAMETAG, (Object)copy);
        this.syncEntity();
    }

    public boolean canUseRail() {
        return this.canUseRail;
    }

    public void setCanUseRail(boolean value) {
        this.canUseRail = value;
    }

    public float getCurrentCartSpeedCapOnRail() {
        return this.currentSpeedCapOnRail;
    }

    public void setCurrentCartSpeedCapOnRail(float value) {
        this.currentSpeedCapOnRail = Math.min(value, 1.2f);
    }

    public float getMaxSpeedAirLateral() {
        return this.maxSpeedAirLateral == null ? (float)this.getMaxSpeed() : this.maxSpeedAirLateral.floatValue();
    }

    public void setMaxSpeedAirLateral(float value) {
        this.maxSpeedAirLateral = Float.valueOf(value);
    }

    public float getMaxSpeedAirVertical() {
        return this.maxSpeedAirVertical;
    }

    public void setMaxSpeedAirVertical(float value) {
        this.maxSpeedAirVertical = value;
    }

    public double getDragAir() {
        return this.dragAir;
    }

    public void setDragAir(double value) {
        this.dragAir = value;
    }

    public ItemStack m_142340_() {
        return new ItemStack((ItemLike)ModItems.ROCKET.get());
    }

    @Override
    public void activate(@Nullable Level level, @Nullable BlockPos pos, @Nullable Entity entity, @Nullable Entity owner, @Nullable Entity activator, ItemStack thisStack) {
        if (!this.getPersistentData().m_128471_("fused")) {
            this.getPersistentData().m_128379_("fused", true);
        }
    }

    static {
        DATA_ID_POOPS = SynchedEntityData.m_135353_(RocketEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135033_);
        DATA_ID_BOMB = SynchedEntityData.m_135353_(RocketEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135033_);
        DATA_ID_NAMETAG = SynchedEntityData.m_135353_(RocketEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135033_);
        DATA_ID_HURT = SynchedEntityData.m_135353_(RocketEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
        DATA_ID_HURTDIR = SynchedEntityData.m_135353_(RocketEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
        DATA_ID_DAMAGE = SynchedEntityData.m_135353_(RocketEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
        DATA_ID_DISPLAY_BLOCK = SynchedEntityData.m_135353_(RocketEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
        DATA_ID_DISPLAY_OFFSET = SynchedEntityData.m_135353_(RocketEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
        DATA_ID_CUSTOM_DISPLAY = SynchedEntityData.m_135353_(RocketEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
        POSE_DISMOUNT_HEIGHTS = ImmutableMap.of((Object)Pose.STANDING, (Object)ImmutableList.of((Object)0, (Object)1, (Object)-1), (Object)Pose.CROUCHING, (Object)ImmutableList.of((Object)0, (Object)1, (Object)-1), (Object)Pose.SWIMMING, (Object)ImmutableList.of((Object)0, (Object)1));
        COLLISIONS = null;
    }
}

