/*
 * Decompiled with CFR 0.152.
 */
package net.svisvi.jigsawpp.entity.rocket;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.svisvi.jigsawpp.entity.rocket.RocketEntity;
import net.svisvi.jigsawpp.entity.rocket.RocketModel;

@OnlyIn(value=Dist.CLIENT)
public class RocketRenderer
extends EntityRenderer<RocketEntity> {
    private static final ResourceLocation MINECART_LOCATION = new ResourceLocation("jigsaw_pp:textures/entity/rocket_open.png");
    private static final ResourceLocation MINECART_LOCATION_CLOSED = new ResourceLocation("jigsaw_pp:textures/entity/rocket_closed.png");
    protected final EntityModel<RocketEntity> model;
    private final BlockRenderDispatcher blockRenderer;

    public RocketRenderer(EntityRendererProvider.Context pContext, ModelLayerLocation pLayer) {
        super(pContext);
        this.f_114477_ = 0.5f;
        this.model = new RocketModel<RocketEntity>(pContext.m_174023_(pLayer));
        this.blockRenderer = pContext.m_234597_();
    }

    public boolean isShaking(Entity pEntity) {
        return pEntity.getPersistentData().m_128471_("fused");
    }

    public void render(RocketEntity pEntity, float pEntityYaw, float pPartialTicks, PoseStack pPoseStack, MultiBufferSource pBuffer, int pPackedLight) {
        Item item;
        double distanceSqr;
        String nametag = pEntity.getNameTag();
        if (nametag != null && !nametag.isEmpty() && (distanceSqr = this.f_114476_.m_114471_((Entity)pEntity)) <= 15.0) {
            pPoseStack.m_85836_();
            pPoseStack.m_85837_(0.0, 0.1, 0.0);
            this.m_7649_(pEntity, (Component)Component.m_237113_((String)nametag), pPoseStack, pBuffer, pPackedLight);
            pPoseStack.m_85849_();
        }
        super.m_7392_((Entity)pEntity, pEntityYaw, pPartialTicks, pPoseStack, pBuffer, pPackedLight);
        if (this.isShaking(pEntity)) {
            pEntityYaw += (float)(Math.cos((double)pEntity.f_19797_ * 3.25) * Math.PI * (double)0.4f);
        }
        pPoseStack.m_85836_();
        long $$6 = (long)pEntity.m_19879_() * 493286711L;
        $$6 = $$6 * $$6 * 4392167121L + $$6 * 98761L;
        float $$7 = (((float)($$6 >> 16 & 7L) + 0.5f) / 8.0f - 0.5f) * 0.004f;
        float $$8 = (((float)($$6 >> 20 & 7L) + 0.5f) / 8.0f - 0.5f) * 0.004f;
        float $$9 = (((float)($$6 >> 24 & 7L) + 0.5f) / 8.0f - 0.5f) * 0.004f;
        pPoseStack.m_252880_($$7, $$8, $$9);
        double $$10 = Mth.m_14139_((double)pPartialTicks, (double)pEntity.f_19790_, (double)pEntity.m_20185_());
        double $$11 = Mth.m_14139_((double)pPartialTicks, (double)pEntity.f_19791_, (double)pEntity.m_20186_());
        double $$12 = Mth.m_14139_((double)pPartialTicks, (double)pEntity.f_19792_, (double)pEntity.m_20189_());
        double $$13 = 0.3f;
        Vec3 $$14 = pEntity.getPos($$10, $$11, $$12);
        float $$15 = Mth.m_14179_((float)pPartialTicks, (float)pEntity.f_19860_, (float)pEntity.m_146909_());
        if ($$14 != null) {
            Vec3 $$16 = pEntity.getPosOffs($$10, $$11, $$12, 0.3f);
            Vec3 $$17 = pEntity.getPosOffs($$10, $$11, $$12, -0.3f);
            if ($$16 == null) {
                $$16 = $$14;
            }
            if ($$17 == null) {
                $$17 = $$14;
            }
            pPoseStack.m_85837_($$14.f_82479_ - $$10, ($$16.f_82480_ + $$17.f_82480_) / 2.0 - $$11, $$14.f_82481_ - $$12);
            Vec3 $$18 = $$17.m_82520_(-$$16.f_82479_, -$$16.f_82480_, -$$16.f_82481_);
            if ($$18.m_82553_() != 0.0) {
                $$18 = $$18.m_82541_();
                pEntityYaw = (float)(Math.atan2($$18.f_82481_, $$18.f_82479_) * 180.0 / Math.PI);
                $$15 = (float)(Math.atan($$18.f_82480_) * 73.0);
            }
        }
        pPoseStack.m_252880_(0.0f, 0.375f, 0.0f);
        pPoseStack.m_252781_(Axis.f_252436_.m_252977_(180.0f - pEntityYaw));
        pPoseStack.m_252781_(Axis.f_252403_.m_252977_(-$$15));
        float $$19 = (float)pEntity.getHurtTime() - pPartialTicks;
        float $$20 = pEntity.getDamage() - pPartialTicks;
        if ($$20 < 0.0f) {
            $$20 = 0.0f;
        }
        if ($$19 > 0.0f) {
            pPoseStack.m_252781_(Axis.f_252529_.m_252977_(Mth.m_14031_((float)$$19) * $$19 * $$20 / 10.0f * (float)pEntity.getHurtDir()));
        }
        int $$21 = pEntity.getDisplayOffset();
        BlockState $$22 = pEntity.getDisplayBlockState();
        if ($$22.m_60799_() != RenderShape.INVISIBLE) {
            pPoseStack.m_85836_();
            float $$23 = 0.75f;
            pPoseStack.m_85841_(0.75f, 0.75f, 0.75f);
            pPoseStack.m_252880_(-0.5f, (float)($$21 - 8) / 16.0f, 0.5f);
            pPoseStack.m_252781_(Axis.f_252436_.m_252977_(90.0f));
            this.renderMinecartContents(pEntity, pPartialTicks, $$22, pPoseStack, pBuffer, pPackedLight);
            pPoseStack.m_85849_();
        }
        pPoseStack.m_85841_(-1.0f, -1.0f, 1.0f);
        pPoseStack.m_252880_(0.0f, -1.125f, 0.0f);
        this.model.m_6973_((Entity)pEntity, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f);
        VertexConsumer $$24 = pBuffer.m_6299_(this.model.m_103119_(this.getTextureLocation(pEntity)));
        this.model.m_7695_(pPoseStack, $$24, pPackedLight, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        ItemStack bombStack = pEntity.getBomb();
        if (!bombStack.m_41619_() && (item = bombStack.m_41720_()) instanceof BlockItem) {
            BlockItem blockItem = (BlockItem)item;
            pPoseStack.m_85836_();
            BlockState bombState = blockItem.m_40614_().m_49966_();
            pPoseStack.m_85837_(0.0, -1.05, 0.0);
            pPoseStack.m_85841_(0.6f, 0.6f, 0.6f);
            pPoseStack.m_252880_(-0.5f, 0.0f, -0.5f);
            this.blockRenderer.m_110912_(bombState, pPoseStack, pBuffer, pPackedLight, OverlayTexture.f_118083_);
            pPoseStack.m_85849_();
        }
        pPoseStack.m_85849_();
    }

    public ResourceLocation getTextureLocation(RocketEntity pEntity) {
        return pEntity.getPoops().m_41619_() ? MINECART_LOCATION : MINECART_LOCATION_CLOSED;
    }

    protected void renderMinecartContents(RocketEntity pEntity, float pPartialTicks, BlockState pState, PoseStack pPoseStack, MultiBufferSource pBuffer, int pPackedLight) {
        this.blockRenderer.m_110912_(pState, pPoseStack, pBuffer, pPackedLight, OverlayTexture.f_118083_);
    }
}

