/*
 * Decompiled with CFR 0.152.
 */
package net.svisvi.jigsawpp.entity.stone_beaver;

import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.registries.ForgeRegistries;

public class StoneBeaverGoals {

    public static class MoveToOreGoal
    extends Goal {
        private static final int GIVE_UP_TICKS = 1200;
        private static final int STAY_TICKS = 1200;
        private static final int INTERVAL_TICKS = 200;
        protected final PathfinderMob mob;
        public final double speedModifier;
        protected int nextStartTick;
        protected int tryTicks;
        private int maxStayTicks;
        protected BlockPos blockPos = BlockPos.f_121853_;
        private boolean reachedTarget;
        private final int searchRange;
        private final int verticalSearchRange;
        protected int verticalSearchStart;

        public MoveToOreGoal(PathfinderMob pMob, double pSpeedModifier, int pSearchRange) {
            this(pMob, pSpeedModifier, pSearchRange, 1);
        }

        public MoveToOreGoal(PathfinderMob pMob, double pSpeedModifier, int pSearchRange, int pVerticalSearchRange) {
            this.mob = pMob;
            this.speedModifier = pSpeedModifier;
            this.searchRange = pSearchRange;
            this.verticalSearchStart = 0;
            this.verticalSearchRange = pVerticalSearchRange;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.JUMP));
        }

        public boolean m_8036_() {
            if (this.nextStartTick > 0) {
                --this.nextStartTick;
                return false;
            }
            this.nextStartTick = this.nextStartTick(this.mob);
            return this.findNearestBlock();
        }

        protected int nextStartTick(PathfinderMob pCreature) {
            return MoveToOreGoal.m_186073_((int)(200 + pCreature.m_217043_().m_188503_(200)));
        }

        public boolean m_8045_() {
            return this.tryTicks >= -this.maxStayTicks && this.tryTicks <= 1200 && this.isValidTarget((LevelReader)this.mob.m_9236_(), this.blockPos);
        }

        public void m_8056_() {
            this.moveMobToBlock();
            this.tryTicks = 0;
            this.maxStayTicks = this.mob.m_217043_().m_188503_(this.mob.m_217043_().m_188503_(1200) + 1200) + 1200;
        }

        protected void moveMobToBlock() {
            this.mob.m_21573_().m_26519_((double)this.blockPos.m_123341_() + 0.5, (double)(this.blockPos.m_123342_() + 1), (double)this.blockPos.m_123343_() + 0.5, this.speedModifier);
        }

        public double acceptedDistance() {
            return 1.0;
        }

        protected BlockPos getMoveToTarget() {
            return this.blockPos.m_7494_();
        }

        public boolean m_183429_() {
            return true;
        }

        public void m_8037_() {
            BlockPos $$0 = this.getMoveToTarget();
            if (!$$0.m_203195_((Position)this.mob.m_20182_(), this.acceptedDistance())) {
                this.reachedTarget = false;
                ++this.tryTicks;
                if (this.shouldRecalculatePath()) {
                    this.mob.m_21573_().m_26519_((double)$$0.m_123341_() + 0.5, (double)$$0.m_123342_(), (double)$$0.m_123343_() + 0.5, this.speedModifier);
                }
            } else {
                this.reachedTarget = true;
                --this.tryTicks;
            }
        }

        public boolean shouldRecalculatePath() {
            return this.tryTicks % 40 == 0;
        }

        protected boolean isReachedTarget() {
            return this.reachedTarget;
        }

        protected boolean findNearestBlock() {
            int $$0 = this.searchRange;
            int $$1 = this.verticalSearchRange;
            BlockPos $$2 = this.mob.m_20183_();
            BlockPos.MutableBlockPos $$3 = new BlockPos.MutableBlockPos();
            int $$4 = this.verticalSearchStart;
            while ($$4 <= $$1) {
                for (int $$5 = 0; $$5 < $$0; ++$$5) {
                    int $$6 = 0;
                    while ($$6 <= $$5) {
                        int $$7;
                        int n = $$7 = $$6 < $$5 && $$6 > -$$5 ? $$5 : 0;
                        while ($$7 <= $$5) {
                            $$3.m_122154_((Vec3i)$$2, $$6, $$4 - 1, $$7);
                            if (this.mob.m_21444_((BlockPos)$$3) && this.isValidTarget((LevelReader)this.mob.m_9236_(), (BlockPos)$$3)) {
                                this.blockPos = $$3;
                                return true;
                            }
                            $$7 = $$7 > 0 ? -$$7 : 1 - $$7;
                        }
                        $$6 = $$6 > 0 ? -$$6 : 1 - $$6;
                    }
                }
                $$4 = $$4 > 0 ? -$$4 : 1 - $$4;
            }
            return false;
        }

        protected boolean isValidTarget(LevelReader level, BlockPos blockpos) {
            return level.m_8055_(blockpos).m_204336_(BlockTags.create((ResourceLocation)new ResourceLocation("forge:ores")));
        }
    }

    public static class EatOreGoal
    extends Goal {
        private static final int EAT_ANIMATION_TICKS = 40;
        private final Mob mob;
        private final Level level;
        private int eatAnimationTick;

        public EatOreGoal(Mob pMob) {
            this.mob = pMob;
            this.level = pMob.m_9236_();
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK, Goal.Flag.JUMP));
        }

        public boolean m_8036_() {
            if (this.mob.m_217043_().m_188503_(5) != 0) {
                return false;
            }
            BlockPos blockpos = EatOreGoal.getLookPos((Entity)this.mob);
            BlockPos downPos = this.mob.m_20183_().m_7495_();
            return this.level.m_8055_(blockpos).m_204336_(BlockTags.create((ResourceLocation)new ResourceLocation("forge:ores"))) || this.level.m_8055_(downPos).m_204336_(BlockTags.create((ResourceLocation)new ResourceLocation("forge:ores")));
        }

        public void m_8056_() {
            this.eatAnimationTick = this.m_183277_(40);
            this.level.m_7605_((Entity)this.mob, (byte)10);
            this.mob.m_21573_().m_26573_();
        }

        public void m_8041_() {
            this.eatAnimationTick = 0;
        }

        public boolean m_8045_() {
            return this.eatAnimationTick > 0;
        }

        public int getEatAnimationTick() {
            return this.eatAnimationTick;
        }

        public void m_8037_() {
            this.eatAnimationTick = Math.max(0, this.eatAnimationTick - 1);
            if (this.eatAnimationTick == this.m_183277_(4)) {
                BlockPos blockpos = EatOreGoal.getLookPos((Entity)this.mob);
                BlockPos downPos = this.mob.m_20183_().m_7495_();
                if (this.level.m_8055_(blockpos).m_204336_(BlockTags.create((ResourceLocation)new ResourceLocation("forge:ores")))) {
                    if (ForgeEventFactory.getMobGriefingEvent((Level)this.level, (Entity)this.mob)) {
                        this.level.m_46796_(2001, blockpos, Block.m_49956_((BlockState)this.level.m_8055_(blockpos).m_60734_().m_49966_()));
                        this.level.m_7731_(blockpos, Blocks.f_50016_.m_49966_(), 2);
                        if (!this.level.m_5776_()) {
                            this.level.m_5594_(null, blockpos, (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("entity.player.burp")), SoundSource.BLOCKS, 1.0f, -1.0f);
                        } else {
                            this.level.m_245747_(blockpos, (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("entity.player.burp")), SoundSource.BLOCKS, 1.0f, -1.0f, false);
                        }
                    }
                    this.mob.m_8035_();
                } else if (this.level.m_8055_(downPos).m_204336_(BlockTags.create((ResourceLocation)new ResourceLocation("forge:ores"))) && ForgeEventFactory.getMobGriefingEvent((Level)this.level, (Entity)this.mob)) {
                    this.level.m_46796_(2001, downPos, Block.m_49956_((BlockState)this.level.m_8055_(downPos).m_60734_().m_49966_()));
                    this.level.m_7731_(downPos, Blocks.f_50016_.m_49966_(), 2);
                    if (!this.level.m_5776_()) {
                        this.level.m_5594_(null, blockpos, (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("entity.player.burp")), SoundSource.BLOCKS, 1.0f, -1.0f);
                    } else {
                        this.level.m_245747_(blockpos, (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("entity.player.burp")), SoundSource.BLOCKS, 1.0f, -1.0f, false);
                    }
                }
            }
        }

        public static BlockPos getLookPos(Entity entity) {
            BlockPos pPos = new BlockPos(entity.m_9236_().m_45547_(new ClipContext(entity.m_20299_(1.0f), entity.m_20299_(1.0f).m_82549_(entity.m_20252_(1.0f).m_82490_(3.0)), ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, entity)).m_82425_().m_123341_(), entity.m_9236_().m_45547_(new ClipContext(entity.m_20299_(1.0f), entity.m_20299_(1.0f).m_82549_(entity.m_20252_(1.0f).m_82490_(3.0)), ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, entity)).m_82425_().m_123342_(), entity.m_9236_().m_45547_(new ClipContext(entity.m_20299_(1.0f), entity.m_20299_(1.0f).m_82549_(entity.m_20252_(1.0f).m_82490_(3.0)), ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, entity)).m_82425_().m_123343_());
            return pPos;
        }
    }
}

