/*
 * Decompiled with CFR 0.152.
 */
package net.svisvi.jigsawpp.event;

import com.google.common.collect.EvictingQueue;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;
import net.svisvi.jigsawpp.config.ModServerConfigs;
import net.svisvi.jigsawpp.procedures.Pair;

@Mod.EventBusSubscriber(modid="jigsaw_pp", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class PatchouliGiving {
    private static final String PLAYED_BEFORE = "ap_played_before";
    private static final int CHAT_QUEUE_MAX_SIZE = 50;
    private static final int PLAYER_QUEUE_MAX_SIZE = 50;
    public static final EvictingQueue<Pair<Long, ChatMessageObject>> messageQueue = EvictingQueue.create((int)50);
    public static final EvictingQueue<Pair<Long, PlayerMessageObject>> playerMessageQueue = EvictingQueue.create((int)50);
    private static long lastPlayerMessageID = 0L;

    @SubscribeEvent
    public static void onWorldJoin(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        if (ModList.get().isLoaded("patchouli") && ((Boolean)ModServerConfigs.GIVE_PATCHOULI_BOOK.get()).booleanValue() && !PatchouliGiving.hasPlayedBefore(player)) {
            ItemStack book = new ItemStack((ItemLike)ForgeRegistries.ITEMS.getValue(new ResourceLocation("patchouli", "guide_book")));
            CompoundTag nbt = new CompoundTag();
            nbt.m_128359_("patchouli:book", "jigsaw_pp:kapital");
            book.m_41751_(nbt);
            player.m_36356_(book);
        }
        PatchouliGiving.putPlayerMessage(Pair.of(PatchouliGiving.getLastPlayerMessageID(), new PlayerMessageObject("playerJoin", player.m_7755_().getString(), player.m_9236_().m_46472_().m_135782_().toString(), "")));
    }

    public static synchronized void putPlayerMessage(Pair<Long, PlayerMessageObject> message) {
        playerMessageQueue.add(message);
        ++lastPlayerMessageID;
    }

    public static synchronized long getLastPlayerMessageID() {
        return lastPlayerMessageID;
    }

    private static boolean hasPlayedBefore(Player player) {
        CompoundTag tag = player.getPersistentData().m_128469_("PlayerPersisted");
        if (tag.m_128471_(PLAYED_BEFORE)) {
            return true;
        }
        tag.m_128379_(PLAYED_BEFORE, true);
        player.getPersistentData().m_128365_("PlayerPersisted", (Tag)tag);
        return false;
    }

    public record PlayerMessageObject(String eventName, String playerName, String fromDimension, String toDimension) {
    }

    public record ChatMessageObject(String username, String message, String uuid, boolean isHidden) {
    }
}

