/*
 * Decompiled with CFR 0.152.
 */
package net.svisvi.jigsawpp.gas;

import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.svisvi.jigsawpp.entity.emitters.AbstractEmitterEntity;
import net.svisvi.jigsawpp.procedures.ut.PoopProtectionArmorConditions;

public abstract class AbstractGasClass {
    public ParticleOptions particle;
    public SoundEvent sound;
    public AbstractEmitterEntity emitter;
    @Nullable
    private LivingEntity owner;
    @Nullable
    private UUID ownerUUID;
    public float gasCloudSizeMultiplier = 1.0f;
    public int effectApplyingTiming = 0;

    public SoundEvent getSound() {
        return this.sound;
    }

    public void setSound(SoundEvent sound) {
        this.sound = sound;
    }

    public ParticleOptions getParticle() {
        return this.particle;
    }

    public void setParticle(ParticleOptions particle) {
        this.particle = particle;
    }

    public AbstractEmitterEntity getEmitter() {
        return this.emitter;
    }

    public void setEmitter(AbstractEmitterEntity emitter) {
        this.emitter = emitter;
    }

    public boolean gasApplyCondition(Entity entity) {
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            if (!PoopProtectionArmorConditions.isProtectedFromGas(entity)) {
                return true;
            }
        }
        return false;
    }

    public void gasSpawnCloud() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void gasApplyEffect(Entity entity) {
        if (!(entity instanceof LivingEntity)) return;
        LivingEntity livingEntity = (LivingEntity)entity;
        if (!this.gasApplyCondition(entity)) return;
        if (!(livingEntity instanceof Player)) return;
        Player player = (Player)livingEntity;
        Level level = player.m_9236_();
        if (!level.m_5776_()) {
            level.m_5594_(null, player.m_20097_(), this.getSound(), SoundSource.HOSTILE, 0.5f, 1.0f);
            return;
        } else {
            level.m_245747_(player.m_20097_(), this.getSound(), SoundSource.HOSTILE, 0.5f, 1.0f, false);
        }
    }

    @Nullable
    public LivingEntity getOwner(Level level) {
        Entity entity;
        if (this.owner == null && this.ownerUUID != null && level instanceof ServerLevel && (entity = ((ServerLevel)level).m_8791_(this.ownerUUID)) instanceof LivingEntity) {
            this.owner = (LivingEntity)entity;
        }
        return this.owner;
    }

    public void setOwner(@Nullable LivingEntity owner) {
        this.owner = owner;
        this.ownerUUID = owner != null ? owner.m_20148_() : null;
    }
}

