/*
 * Decompiled with CFR 0.152.
 */
package net.svisvi.jigsawpp.gas;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.RelativeMovement;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.levelgen.Heightmap;
import net.svisvi.jigsawpp.effect.PoopEffect;
import net.svisvi.jigsawpp.gas.EffectGasClass;
import net.svisvi.jigsawpp.particles.ModParticleTypes;

public class BrownHoleGasClass
extends EffectGasClass {
    public ParticleOptions particle = (ParticleOptions)ModParticleTypes.POOP.get();
    public SoundEvent sound = SoundEvents.f_11858_;
    public List<MobEffectInstance> effectList = new ArrayList<MobEffectInstance>(Arrays.asList(new MobEffectInstance(MobEffects.f_216964_, 21, 0)));

    public BrownHoleGasClass() {
        this((ParticleOptions)ModParticleTypes.POOP.get(), SoundEvents.f_11858_, new ArrayList<MobEffectInstance>(Arrays.asList(new MobEffectInstance(MobEffects.f_216964_, 21, 0))));
    }

    public BrownHoleGasClass(MobEffectInstance poopEffect) {
        this((ParticleOptions)ModParticleTypes.POOP.get(), SoundEvents.f_11858_, new ArrayList<MobEffectInstance>(Arrays.asList(poopEffect)));
    }

    public BrownHoleGasClass(ParticleOptions partcl, SoundEvent soundd, List<MobEffectInstance> effectList) {
        super(partcl, soundd, effectList);
    }

    @Override
    public void gasApplyEffect(Entity entity) {
        super.gasApplyEffect(entity);
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            if (this.gasApplyCondition(entity)) {
                for (MobEffectInstance mef : this.effectList) {
                    PoopEffect.addEffectGasWay((Entity)livingEntity, mef);
                }
                BrownHoleGasClass.teleportToOverworldSpawn(livingEntity);
            }
        }
    }

    @Override
    public boolean gasApplyCondition(Entity entity) {
        return true;
    }

    public static void teleportToOverworldSpawn(LivingEntity entity) {
        ServerLevel serverLevel;
        ServerLevel overworld;
        Level level = entity.m_9236_();
        if (level instanceof ServerLevel && (overworld = (serverLevel = (ServerLevel)level).m_7654_().m_129880_(Level.f_46428_)) != null) {
            int surfaceY = overworld.m_6924_(Heightmap.Types.MOTION_BLOCKING, 0, 0);
            BlockPos spawnPos = new BlockPos(0, surfaceY, 0);
            Set<RelativeMovement> movementFlags = Set.of(RelativeMovement.X, RelativeMovement.Y, RelativeMovement.Z, RelativeMovement.Y_ROT, RelativeMovement.X_ROT);
            entity.m_264318_(overworld, (double)spawnPos.m_123341_() + 0.5, (double)(spawnPos.m_123342_() + 1), (double)spawnPos.m_123343_() + 0.5, movementFlags, entity.m_146908_(), entity.m_146909_());
        }
    }
}

