/*
 * Decompiled with CFR 0.152.
 */
package net.svisvi.jigsawpp.gas;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.svisvi.jigsawpp.effect.PoopEffect;
import net.svisvi.jigsawpp.effect.PurgativeEffect;
import net.svisvi.jigsawpp.effect.init.ModEffects;
import net.svisvi.jigsawpp.gas.EffectGasClass;
import net.svisvi.jigsawpp.particles.ModParticleTypes;

public class PurgativeGasClass
extends EffectGasClass {
    public ParticleOptions particle = (ParticleOptions)ModParticleTypes.PURGATIVE_CLOUD.get();
    public SoundEvent sound = SoundEvents.f_11833_;
    public List<MobEffectInstance> effectList = new ArrayList<MobEffectInstance>(Arrays.asList(new MobEffectInstance((MobEffect)ModEffects.PURGATIVE.get(), 60, 0)));

    public PurgativeGasClass() {
        this((ParticleOptions)ModParticleTypes.PURGATIVE_CLOUD.get(), SoundEvents.f_11833_, new ArrayList<MobEffectInstance>(Arrays.asList(new MobEffectInstance((MobEffect)ModEffects.PURGATIVE.get(), 60, 0))));
    }

    public PurgativeGasClass(MobEffectInstance purgativeEffect) {
        this((ParticleOptions)ModParticleTypes.PURGATIVE_CLOUD.get(), SoundEvents.f_11833_, new ArrayList<MobEffectInstance>(Arrays.asList(purgativeEffect)));
    }

    public PurgativeGasClass(List<MobEffectInstance> purgativeEffectList) {
        this((ParticleOptions)ModParticleTypes.PURGATIVE_CLOUD.get(), SoundEvents.f_11833_, purgativeEffectList);
    }

    public PurgativeGasClass(ParticleOptions partcl, SoundEvent soundd, List<MobEffectInstance> effectList) {
        super(partcl, soundd, effectList);
    }

    @Override
    public void gasApplyEffect(Entity entity) {
        super.gasApplyEffect(entity);
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            if (this.gasApplyCondition(entity)) {
                for (MobEffectInstance mef : this.effectList) {
                    PurgativeEffect.addEffectGasWay((Entity)livingEntity, mef);
                }
            }
        }
    }

    @Override
    public boolean gasApplyCondition(Entity entity) {
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            if (PoopEffect.poopAdditionConditionGasWay(entity, new MobEffectInstance((MobEffect)ModEffects.PURGATIVE.get()))) {
                return true;
            }
        }
        return false;
    }
}

