/*
 * Decompiled with CFR 0.152.
 */
package net.svisvi.jigsawpp.item;

import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.ChatFormatting;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.stats.Stats;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.inventory.tooltip.BundleTooltip;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.BundleItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;

public class PurgenBundleItem
extends BundleItem {
    private static final String TAG_ITEMS = "jigsaw_pp:pilules";
    public static final int MAX_WEIGHT = 32;
    private static final int BUNDLE_IN_BUNDLE_WEIGHT = 4;
    private static final int BAR_COLOR = Mth.m_14159_((float)0.831f, (float)0.765f, (float)0.184f);

    public PurgenBundleItem() {
        super(new Item.Properties().m_41487_(1).m_41497_(Rarity.COMMON).m_41489_(new FoodProperties.Builder().m_38760_(0).m_38758_(0.0f).m_38765_().m_38757_().m_38767_()));
    }

    public static float m_150766_(ItemStack pStack) {
        return (float)PurgenBundleItem.m_150778_(pStack) / 32.0f;
    }

    public boolean m_142207_(ItemStack pStack, Slot pSlot, ClickAction pAction, Player pPlayer) {
        if (pStack.m_41613_() != 1 || pAction != ClickAction.SECONDARY) {
            return false;
        }
        ItemStack itemstack = pSlot.m_7993_();
        if (itemstack.m_41619_()) {
            this.m_186342_((Entity)pPlayer);
            PurgenBundleItem.m_150780_(pStack).ifPresent(p_150740_ -> PurgenBundleItem.m_150763_(pStack, pSlot.m_150659_(p_150740_)));
        } else if (itemstack.m_41720_().m_142095_() && itemstack.m_204117_(ItemTags.create((ResourceLocation)new ResourceLocation(TAG_ITEMS)))) {
            int i = (32 - PurgenBundleItem.m_150778_(pStack)) / PurgenBundleItem.m_150776_(itemstack);
            int j = PurgenBundleItem.m_150763_(pStack, pSlot.m_150647_(itemstack.m_41613_(), i, pPlayer));
            if (j > 0) {
                this.m_186351_((Entity)pPlayer);
            }
        }
        return true;
    }

    public boolean m_142305_(ItemStack pStack, ItemStack pOther, Slot pSlot, ClickAction pAction, Player pPlayer, SlotAccess pAccess) {
        if (pStack.m_41613_() != 1) {
            return false;
        }
        if (pAction == ClickAction.SECONDARY && pSlot.m_150651_(pPlayer)) {
            int i;
            if (pOther.m_41619_()) {
                PurgenBundleItem.m_150780_(pStack).ifPresent(p_186347_ -> {
                    this.m_186342_((Entity)pPlayer);
                    pAccess.m_142104_(p_186347_);
                });
            } else if (pOther.m_204117_(ItemTags.create((ResourceLocation)new ResourceLocation(TAG_ITEMS))) && (i = PurgenBundleItem.m_150763_(pStack, pOther)) > 0) {
                this.m_186351_((Entity)pPlayer);
                pOther.m_41774_(i);
            }
            return true;
        }
        return false;
    }

    public ItemStack m_5922_(ItemStack itemstack, Level world, LivingEntity entity) {
        this.stopUsing(entity);
        ItemStack stack = ItemStack.f_41583_;
        if (entity instanceof Player) {
            Player player = (Player)entity;
            stack = PurgenBundleItem.useFirst(itemstack, player);
        }
        stack.m_41720_().m_5922_(stack, world, entity);
        return itemstack;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level pLevel, Player pPlayer, InteractionHand pUsedHand) {
        pPlayer.m_5496_(SoundEvents.f_12321_, 1.0f, 1.0f);
        pPlayer.m_36246_(Stats.f_12982_.m_12902_((Object)this));
        return ItemUtils.m_150959_((Level)pLevel, (Player)pPlayer, (InteractionHand)pUsedHand);
    }

    public static ItemStack useFirst(ItemStack pStack, Player pPlayer) {
        CompoundTag compoundtag = pStack.m_41784_();
        if (!compoundtag.m_128441_(TAG_ITEMS)) {
            return ItemStack.f_41583_;
        }
        ItemStack itemStack = ItemStack.f_41583_;
        if (pPlayer instanceof ServerPlayer) {
            ListTag listtag = compoundtag.m_128437_(TAG_ITEMS, 10);
            itemStack = PurgenBundleItem.shrinkOne(pStack).get();
            if (itemStack == null) {
                itemStack = ItemStack.f_41583_;
            }
        }
        return itemStack;
    }

    public static Optional<ItemStack> shrinkOne(ItemStack pStack) {
        CompoundTag compoundtag = pStack.m_41784_();
        if (!compoundtag.m_128441_(TAG_ITEMS)) {
            return Optional.empty();
        }
        ListTag listtag = compoundtag.m_128437_(TAG_ITEMS, 10);
        if (listtag.isEmpty()) {
            return Optional.empty();
        }
        boolean i = false;
        CompoundTag compoundtag1 = listtag.m_128728_(0);
        ItemStack itemstack = ItemStack.m_41712_((CompoundTag)compoundtag1);
        if (itemstack.m_41613_() == 1) {
            listtag.remove(0);
        } else {
            itemstack.m_41774_(1);
            listtag.remove(0);
            PurgenBundleItem.m_150763_(pStack, itemstack);
        }
        if (listtag.isEmpty()) {
            pStack.m_41749_(TAG_ITEMS);
        }
        itemstack.m_41764_(1);
        return Optional.of(itemstack);
    }

    public boolean m_142522_(ItemStack pStack) {
        return PurgenBundleItem.m_150778_(pStack) > 0;
    }

    public int m_142158_(ItemStack pStack) {
        return Math.min(1 + 12 * PurgenBundleItem.m_150778_(pStack) / 32, 13);
    }

    public int m_142159_(ItemStack pStack) {
        return BAR_COLOR;
    }

    private static int m_150763_(ItemStack pBundleStack, ItemStack pInsertedStack) {
        if (!pInsertedStack.m_41619_() && pInsertedStack.m_204117_(ItemTags.create((ResourceLocation)new ResourceLocation(TAG_ITEMS))) && pInsertedStack.m_41720_().m_142095_()) {
            CompoundTag compoundtag = pBundleStack.m_41784_();
            if (!compoundtag.m_128441_(TAG_ITEMS)) {
                compoundtag.m_128365_(TAG_ITEMS, (Tag)new ListTag());
            }
            int i = PurgenBundleItem.m_150778_(pBundleStack);
            int j = PurgenBundleItem.m_150776_(pInsertedStack);
            int k = Math.min(pInsertedStack.m_41613_(), (32 - i) / j);
            if (k == 0) {
                return 0;
            }
            ListTag listtag = compoundtag.m_128437_(TAG_ITEMS, 10);
            Optional<CompoundTag> optional = PurgenBundleItem.m_150756_(pInsertedStack, listtag);
            if (optional.isPresent()) {
                CompoundTag compoundtag1 = optional.get();
                ItemStack itemstack = ItemStack.m_41712_((CompoundTag)compoundtag1);
                itemstack.m_41769_(k);
                itemstack.m_41739_(compoundtag1);
                listtag.remove((Object)compoundtag1);
                listtag.add(0, (Tag)compoundtag1);
            } else {
                ItemStack itemstack1 = pInsertedStack.m_255036_(k);
                CompoundTag compoundtag2 = new CompoundTag();
                itemstack1.m_41739_(compoundtag2);
                listtag.add(0, (Tag)compoundtag2);
            }
            return k;
        }
        return 0;
    }

    private static Optional<CompoundTag> m_150756_(ItemStack pStack, ListTag pList) {
        return pStack.m_150930_(Items.f_151058_) ? Optional.empty() : pList.stream().filter(CompoundTag.class::isInstance).map(CompoundTag.class::cast).filter(p_186350_ -> ItemStack.m_150942_((ItemStack)ItemStack.m_41712_((CompoundTag)p_186350_), (ItemStack)pStack)).findFirst();
    }

    private static int m_150776_(ItemStack pStack) {
        CompoundTag compoundtag;
        if (pStack.m_150930_(Items.f_151058_)) {
            return 4 + PurgenBundleItem.m_150778_(pStack);
        }
        if ((pStack.m_150930_(Items.f_42786_) || pStack.m_150930_(Items.f_42785_)) && pStack.m_41782_() && (compoundtag = BlockItem.m_186336_((ItemStack)pStack)) != null && !compoundtag.m_128437_("Bees", 10).isEmpty()) {
            return 32;
        }
        return 1;
    }

    public static int m_150778_(ItemStack pStack) {
        return PurgenBundleItem.m_150782_(pStack).mapToInt(p_186356_ -> PurgenBundleItem.m_150776_(p_186356_) * p_186356_.m_41613_()).sum();
    }

    private static Optional<ItemStack> m_150780_(ItemStack pStack) {
        CompoundTag compoundtag = pStack.m_41784_();
        if (!compoundtag.m_128441_(TAG_ITEMS)) {
            return Optional.empty();
        }
        ListTag listtag = compoundtag.m_128437_(TAG_ITEMS, 10);
        if (listtag.isEmpty()) {
            return Optional.empty();
        }
        boolean i = false;
        CompoundTag compoundtag1 = listtag.m_128728_(0);
        ItemStack itemstack = ItemStack.m_41712_((CompoundTag)compoundtag1);
        listtag.remove(0);
        if (listtag.isEmpty()) {
            pStack.m_41749_(TAG_ITEMS);
        }
        return Optional.of(itemstack);
    }

    private static boolean m_150729_(ItemStack pStack, Player pPlayer) {
        CompoundTag compoundtag = pStack.m_41784_();
        if (!compoundtag.m_128441_(TAG_ITEMS)) {
            return false;
        }
        if (pPlayer instanceof ServerPlayer) {
            ListTag listtag = compoundtag.m_128437_(TAG_ITEMS, 10);
            for (int i = 0; i < listtag.size(); ++i) {
                CompoundTag compoundtag1 = listtag.m_128728_(i);
                ItemStack itemstack = ItemStack.m_41712_((CompoundTag)compoundtag1);
                pPlayer.m_36176_(itemstack, true);
            }
        }
        pStack.m_41749_(TAG_ITEMS);
        return true;
    }

    public static Stream<ItemStack> m_150782_(ItemStack pStack) {
        CompoundTag compoundtag = pStack.m_41783_();
        if (compoundtag == null) {
            return Stream.empty();
        }
        ListTag listtag = compoundtag.m_128437_(TAG_ITEMS, 10);
        return listtag.stream().map(CompoundTag.class::cast).map(ItemStack::m_41712_);
    }

    public Optional<TooltipComponent> m_142422_(ItemStack pStack) {
        NonNullList nonnulllist = NonNullList.m_122779_();
        PurgenBundleItem.m_150782_(pStack).forEach(arg_0 -> nonnulllist.add(arg_0));
        return Optional.of(new BundleTooltip(nonnulllist, PurgenBundleItem.m_150778_(pStack)));
    }

    public void m_7373_(ItemStack pStack, Level pLevel, List<Component> pTooltipComponents, TooltipFlag pIsAdvanced) {
        pTooltipComponents.add((Component)Component.m_237110_((String)"item.minecraft.bundle.fullness", (Object[])new Object[]{PurgenBundleItem.m_150778_(pStack), 32}).m_130940_(ChatFormatting.GRAY));
    }

    public void m_142023_(ItemEntity pItemEntity) {
        ItemUtils.m_150952_((ItemEntity)pItemEntity, PurgenBundleItem.m_150782_(pItemEntity.m_32055_()));
    }

    private void m_186342_(Entity pEntity) {
        pEntity.m_5496_(SoundEvents.f_184216_, 0.8f, 0.8f + pEntity.m_9236_().m_213780_().m_188501_() * 0.4f);
    }

    private void m_186351_(Entity pEntity) {
        pEntity.m_5496_(SoundEvents.f_184215_, 0.8f, 0.8f + pEntity.m_9236_().m_213780_().m_188501_() * 0.4f);
    }

    private void m_186353_(Entity pEntity) {
        pEntity.m_5496_(SoundEvents.f_184214_, 0.8f, 0.8f + pEntity.m_9236_().m_213780_().m_188501_() * 0.4f);
    }

    public int m_8105_(ItemStack itemstack) {
        return 32;
    }

    public UseAnim m_6164_(ItemStack pStack) {
        return UseAnim.DRINK;
    }

    public void m_5551_(ItemStack pStack, Level pLevel, LivingEntity pLivingEntity, int pTimeCharged) {
        this.stopUsing(pLivingEntity);
    }

    private void stopUsing(LivingEntity pUser) {
        pUser.m_5496_(SoundEvents.f_11833_, 1.0f, 1.0f);
    }
}

