/*
 * Decompiled with CFR 0.152.
 */
package net.svisvi.jigsawpp.item;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.ForgeEventFactory;
import net.svisvi.jigsawpp.entity.projectile.TreeProjectile;
import net.svisvi.jigsawpp.item.ut.CustomArmPoseItem;
import net.svisvi.jigsawpp.procedures.ut.TreeSaplingFinder;
import org.jetbrains.annotations.Nullable;

public class TreeLauncherItem
extends Item
implements CustomArmPoseItem {
    public static final int COOLDOWN = 40;
    public static final int COOLDOWN_BREAK = 120;
    public static float SPREAD = 30.0f;
    public static final int AMOUNT = 8;

    public TreeLauncherItem() {
        super(new Item.Properties().m_41487_(1).m_41497_(Rarity.COMMON).m_41503_(250));
    }

    public TreeLauncherItem(int dur) {
        super(new Item.Properties().m_41487_(1).m_41497_(Rarity.COMMON).m_41503_(dur));
    }

    public int getCooldown() {
        return 40;
    }

    public int getCooldownBreak() {
        return 120;
    }

    public float getSpread() {
        return SPREAD;
    }

    public static int getAmount() {
        return 8;
    }

    public void m_7373_(ItemStack itemstack, Level world, List<Component> list, TooltipFlag flag) {
        super.m_7373_(itemstack, world, list, flag);
        list.add((Component)Component.m_237115_((String)"item.jigsaw_pp.tree_launcher.desc"));
    }

    public void m_5551_(ItemStack pStack, Level pLevel, LivingEntity pEntity, int pTimeLeft) {
        ArrayList<ItemStack> saplings = new ArrayList<ItemStack>(TreeLauncherItem.getAmount());
        if (pEntity instanceof Player) {
            Player pPlayer = (Player)pEntity;
            for (int i = 0; i < TreeLauncherItem.getAmount(); ++i) {
                ItemStack purgen_pilule = TreeSaplingFinder.findTree(pPlayer);
                saplings.add(purgen_pilule);
            }
            if (TreeLauncherItem.ableToShoot(saplings)) {
                pPlayer.m_36335_().m_41524_((Item)this, this.getCooldown());
                ItemStack _ist = pStack;
                if (_ist.m_220157_(1, RandomSource.m_216327_(), null)) {
                    _ist.m_41774_(1);
                    _ist.m_41721_(0);
                }
                pLevel.m_6263_((Player)null, pPlayer.m_20185_(), pPlayer.m_20186_(), pPlayer.m_20189_(), SoundEvents.f_11705_, SoundSource.PLAYERS, 1.0f, 1.0f / (pLevel.m_213780_().m_188501_() * 0.4f + 0.8f));
                pLevel.m_6263_((Player)null, pPlayer.m_20185_(), pPlayer.m_20186_(), pPlayer.m_20189_(), SoundEvents.f_12312_, SoundSource.PLAYERS, 1.0f, 1.0f / (pLevel.m_213780_().m_188501_() * 0.4f + 0.8f));
                for (ItemStack sapling : saplings) {
                    this.new_shoot(pLevel, pPlayer, pStack, sapling.m_41777_(), this.getSpread());
                    ItemStack _stktoremove = new ItemStack((ItemLike)sapling.m_41720_());
                    pPlayer.m_150109_().m_36022_(p -> _stktoremove.m_41720_() == p.m_41720_(), 1, (Container)pPlayer.f_36095_.m_39730_());
                }
                if (pEntity instanceof Player) {
                    Player _player = (Player)pEntity;
                    _player.m_36335_().m_41524_(pStack.m_41720_(), 40);
                }
            } else {
                pPlayer.m_36335_().m_41524_((Item)this, this.getCooldownBreak());
                pLevel.m_6263_((Player)null, pPlayer.m_20185_(), pPlayer.m_20186_(), pPlayer.m_20189_(), SoundEvents.f_11668_, SoundSource.PLAYERS, 1.0f, 1.0f / (pLevel.m_213780_().m_188501_() * 0.4f + 0.8f));
            }
        }
    }

    public static boolean ableToShoot(ArrayList<ItemStack> array) {
        ItemStack stack = array.get(0);
        if (array.size() == TreeLauncherItem.getAmount()) {
            for (ItemStack item : array) {
                if (item.m_204117_(ItemTags.f_13180_) || item.m_41720_() != stack.m_41720_()) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level pLevel, Player pPlayer, InteractionHand pHand) {
        ItemStack itemstack = pPlayer.m_21120_(pHand);
        InteractionResultHolder ret = ForgeEventFactory.onArrowNock((ItemStack)itemstack, (Level)pLevel, (Player)pPlayer, (InteractionHand)pHand, (boolean)true);
        if (ret != null) {
            return ret;
        }
        pPlayer.m_6672_(pHand);
        return InteractionResultHolder.m_19096_((Object)itemstack);
    }

    public void new_shoot(Level pLevel, Player pPlayer, ItemStack thisStack, ItemStack purgenPilule, float inaccuracy) {
        if (!pLevel.m_5776_()) {
            Random rand = new Random();
            float randomValue = rand.nextFloat();
            TreeProjectile.shoot(pLevel, (LivingEntity)pPlayer, 1.3f, inaccuracy, purgenPilule);
        }
    }

    public int m_8105_(ItemStack pStack) {
        return 72000;
    }

    public UseAnim m_6164_(ItemStack pStack) {
        return UseAnim.BOW;
    }

    @Override
    @Nullable
    public // Could not load outer class - annotation placement on inner may be incorrect
     @Nullable @Nullable HumanoidModel.ArmPose getArmPose(ItemStack stack, AbstractClientPlayer player, InteractionHand hand) {
        if (!player.f_20911_ && !player.m_6117_()) {
            return HumanoidModel.ArmPose.CROSSBOW_CHARGE;
        }
        return null;
    }
}

