/*
 * Decompiled with CFR 0.152.
 */
package net.svisvi.jigsawpp.item.armor;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import net.minecraftforge.common.Tags;
import net.minecraftforge.registries.ForgeRegistries;
import net.svisvi.jigsawpp.entity.armor.beaver.BeaverBodyModel;
import net.svisvi.jigsawpp.entity.armor.beaver.BeaverBootsModel;
import net.svisvi.jigsawpp.entity.armor.beaver.BeaverHatModel;
import net.svisvi.jigsawpp.entity.init.ModModelLayers;

public abstract class BeaverItem
extends ArmorItem {
    public BeaverItem(ArmorItem.Type type, Item.Properties properties) {
        super(new ArmorMaterial(){

            public int m_266425_(ArmorItem.Type type) {
                return (new int[]{13, 15, 16, 11})[type.m_266308_().m_20749_()] * 12;
            }

            public int m_7366_(ArmorItem.Type type) {
                return (new int[]{2, 0, 3, 2})[type.m_266308_().m_20749_()];
            }

            public int m_6646_() {
                return 9;
            }

            public SoundEvent m_7344_() {
                return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("item.armor.equip_leather"));
            }

            public Ingredient m_6230_() {
                return Ingredient.m_204132_((TagKey)Tags.Items.LEATHER);
            }

            public String m_6082_() {
                return "beaver";
            }

            public float m_6651_() {
                return 0.0f;
            }

            public float m_6649_() {
                return 0.0f;
            }
        }, type, properties);
    }

    public static class Boots
    extends BeaverItem {
        public Boots() {
            super(ArmorItem.Type.BOOTS, new Item.Properties());
        }

        public void m_7373_(ItemStack itemstack, Level world, List<Component> list, TooltipFlag flag) {
            super.m_7373_(itemstack, world, list, flag);
        }

        public void initializeClient(Consumer<IClientItemExtensions> consumer) {
            consumer.accept(new IClientItemExtensions(){

                @OnlyIn(value=Dist.CLIENT)
                public HumanoidModel getHumanoidArmorModel(LivingEntity living, ItemStack stack, EquipmentSlot slot, HumanoidModel defaultModel) {
                    HumanoidModel armorModel = new HumanoidModel(new ModelPart(Collections.emptyList(), Map.of("left_leg", new BeaverBootsModel<T>((ModelPart)Minecraft.m_91087_().m_167973_().m_171103_((ModelLayerLocation)ModModelLayers.BEAVER_BOOTS_LAYER)).LeftLeg, "right_leg", new BeaverBootsModel<T>((ModelPart)Minecraft.m_91087_().m_167973_().m_171103_((ModelLayerLocation)ModModelLayers.BEAVER_BOOTS_LAYER)).RightLeg, "head", new ModelPart(Collections.emptyList(), Collections.emptyMap()), "hat", new ModelPart(Collections.emptyList(), Collections.emptyMap()), "body", new ModelPart(Collections.emptyList(), Collections.emptyMap()), "right_arm", new ModelPart(Collections.emptyList(), Collections.emptyMap()), "left_arm", new ModelPart(Collections.emptyList(), Collections.emptyMap()))));
                    armorModel.f_102817_ = living.m_6144_();
                    armorModel.f_102609_ = defaultModel.f_102609_;
                    armorModel.f_102610_ = living.m_6162_();
                    return armorModel;
                }
            });
        }

        public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, String type) {
            return "jigsaw_pp:textures/models/armor/beaver_armor.png";
        }
    }

    public static class Chestplate
    extends BeaverItem {
        public Chestplate() {
            super(ArmorItem.Type.CHESTPLATE, new Item.Properties());
        }

        public void m_7373_(ItemStack itemstack, Level world, List<Component> list, TooltipFlag flag) {
            super.m_7373_(itemstack, world, list, flag);
        }

        public void initializeClient(Consumer<IClientItemExtensions> consumer) {
            consumer.accept(new IClientItemExtensions(){

                @OnlyIn(value=Dist.CLIENT)
                public HumanoidModel getHumanoidArmorModel(LivingEntity living, ItemStack stack, EquipmentSlot slot, HumanoidModel defaultModel) {
                    HumanoidModel armorModel = new HumanoidModel(new ModelPart(Collections.emptyList(), Map.of("body", new BeaverBodyModel<T>((ModelPart)Minecraft.m_91087_().m_167973_().m_171103_((ModelLayerLocation)ModModelLayers.BEAVER_BODY_LAYER)).Body, "left_arm", new BeaverBodyModel<T>((ModelPart)Minecraft.m_91087_().m_167973_().m_171103_((ModelLayerLocation)ModModelLayers.BEAVER_BODY_LAYER)).LeftArm, "right_arm", new BeaverBodyModel<T>((ModelPart)Minecraft.m_91087_().m_167973_().m_171103_((ModelLayerLocation)ModModelLayers.BEAVER_BODY_LAYER)).RightArm, "head", new ModelPart(Collections.emptyList(), Collections.emptyMap()), "hat", new ModelPart(Collections.emptyList(), Collections.emptyMap()), "right_leg", new ModelPart(Collections.emptyList(), Collections.emptyMap()), "left_leg", new ModelPart(Collections.emptyList(), Collections.emptyMap()))));
                    armorModel.f_102817_ = living.m_6144_();
                    armorModel.f_102609_ = defaultModel.f_102609_;
                    armorModel.f_102610_ = living.m_6162_();
                    return armorModel;
                }
            });
        }

        public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, String type) {
            return "jigsaw_pp:textures/models/armor/beaver_armor.png";
        }
    }

    public static class Helmet
    extends BeaverItem {
        public Helmet() {
            super(ArmorItem.Type.HELMET, new Item.Properties());
        }

        public void m_7373_(ItemStack itemstack, Level world, List<Component> list, TooltipFlag flag) {
            super.m_7373_(itemstack, world, list, flag);
        }

        public void initializeClient(Consumer<IClientItemExtensions> consumer) {
            consumer.accept(new IClientItemExtensions(){

                public HumanoidModel getHumanoidArmorModel(LivingEntity living, ItemStack stack, EquipmentSlot slot, HumanoidModel defaultModel) {
                    HumanoidModel armorModel = new HumanoidModel(new ModelPart(Collections.emptyList(), Map.of("head", new BeaverHatModel<T>((ModelPart)Minecraft.m_91087_().m_167973_().m_171103_((ModelLayerLocation)ModModelLayers.BEAVER_HAT_LAYER)).Head, "hat", new ModelPart(Collections.emptyList(), Collections.emptyMap()), "body", new ModelPart(Collections.emptyList(), Collections.emptyMap()), "right_arm", new ModelPart(Collections.emptyList(), Collections.emptyMap()), "left_arm", new ModelPart(Collections.emptyList(), Collections.emptyMap()), "right_leg", new ModelPart(Collections.emptyList(), Collections.emptyMap()), "left_leg", new ModelPart(Collections.emptyList(), Collections.emptyMap()))));
                    armorModel.f_102817_ = living.m_6144_();
                    armorModel.f_102609_ = defaultModel.f_102609_;
                    armorModel.f_102610_ = living.m_6162_();
                    return armorModel;
                }
            });
        }

        public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, String type) {
            return "jigsaw_pp:textures/models/armor/beaver_armor.png";
        }
    }
}

