/*
 * Decompiled with CFR 0.152.
 */
package net.svisvi.jigsawpp.item.armor;

import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.ForgeRegistries;
import net.svisvi.jigsawpp.procedures.ut.IPoopProtective;
import net.svisvi.jigsawpp.procedures.ut.PoopProtectionArmorConditions;

public abstract class HazmatItem
extends ArmorItem
implements IPoopProtective {
    public HazmatItem(ArmorItem.Type type, Item.Properties properties) {
        super(new ArmorMaterial(){

            public int m_266425_(ArmorItem.Type type) {
                return (new int[]{13, 15, 16, 11})[type.m_266308_().m_20749_()] * 6;
            }

            public int m_7366_(ArmorItem.Type type) {
                return (new int[]{1, 2, 4, 2})[type.m_266308_().m_20749_()];
            }

            public int m_6646_() {
                return 9;
            }

            public SoundEvent m_7344_() {
                return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("item.armor.equip_leather"));
            }

            public Ingredient m_6230_() {
                return Ingredient.m_151265_();
            }

            public String m_6082_() {
                return "hazmat";
            }

            public float m_6651_() {
                return 0.0f;
            }

            public float m_6649_() {
                return 0.0f;
            }
        }, type, properties);
    }

    @Override
    public void onGas(ItemStack itemStack, Entity entity) {
        PoopProtectionArmorConditions.defaultAction(entity, itemStack, "gas");
    }

    @Override
    public void onLiquid(ItemStack itemStack, Entity entity) {
        PoopProtectionArmorConditions.defaultAction(entity, itemStack, "liquid");
    }

    public static class Boots
    extends HazmatItem {
        public Boots() {
            super(ArmorItem.Type.BOOTS, new Item.Properties());
        }

        public void m_7373_(ItemStack itemstack, Level world, List<Component> list, TooltipFlag flag) {
            super.m_7373_(itemstack, world, list, flag);
        }

        public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, String type) {
            return "jigsaw_pp:textures/models/armor/hazmat_layer_1.png";
        }
    }

    public static class Leggings
    extends HazmatItem {
        public Leggings() {
            super(ArmorItem.Type.LEGGINGS, new Item.Properties());
        }

        public void m_7373_(ItemStack itemstack, Level world, List<Component> list, TooltipFlag flag) {
            super.m_7373_(itemstack, world, list, flag);
        }

        public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, String type) {
            return "jigsaw_pp:textures/models/armor/hazmat_layer_2.png";
        }
    }

    public static class Chestplate
    extends HazmatItem {
        public Chestplate() {
            super(ArmorItem.Type.CHESTPLATE, new Item.Properties());
        }

        public void m_7373_(ItemStack itemstack, Level world, List<Component> list, TooltipFlag flag) {
            super.m_7373_(itemstack, world, list, flag);
        }

        public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, String type) {
            return "jigsaw_pp:textures/models/armor/hazmat_layer_1.png";
        }
    }

    public static class Helmet
    extends HazmatItem {
        public Helmet() {
            super(ArmorItem.Type.HELMET, new Item.Properties());
        }

        public void m_7373_(ItemStack itemstack, Level world, List<Component> list, TooltipFlag flag) {
            super.m_7373_(itemstack, world, list, flag);
        }

        public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, String type) {
            return "jigsaw_pp:textures/models/armor/hazmat_layer_1.png";
        }
    }
}

