/*
 * Decompiled with CFR 0.152.
 */
package net.svisvi.jigsawpp.item.armor;

import com.google.common.collect.Iterables;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.animal.Cow;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import net.minecraftforge.registries.ForgeRegistries;
import net.svisvi.jigsawpp.entity.armor.OnionModel;
import net.svisvi.jigsawpp.entity.init.ModModelLayers;

public abstract class OnionItem
extends ArmorItem {
    public OnionItem(ArmorItem.Type type, Item.Properties properties) {
        super(new ArmorMaterial(){

            public int m_266425_(ArmorItem.Type type) {
                return (new int[]{13, 15, 16, 128})[type.m_266308_().m_20749_()];
            }

            public int m_7366_(ArmorItem.Type type) {
                return (new int[]{0, 0, 0, 1})[type.m_266308_().m_20749_()];
            }

            public int m_6646_() {
                return 4;
            }

            public SoundEvent m_7344_() {
                return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("item.armor.equip_leather"));
            }

            public Ingredient m_6230_() {
                return Ingredient.m_151265_();
            }

            public String m_6082_() {
                return "onion";
            }

            public float m_6651_() {
                return 0.0f;
            }

            public float m_6649_() {
                return 0.0f;
            }
        }, type, properties);
    }

    public static class Helmet
    extends OnionItem {
        public Helmet() {
            super(ArmorItem.Type.HELMET, new Item.Properties());
        }

        public void initializeClient(Consumer<IClientItemExtensions> consumer) {
            consumer.accept(new IClientItemExtensions(){

                public HumanoidModel getHumanoidArmorModel(LivingEntity living, ItemStack stack, EquipmentSlot slot, HumanoidModel defaultModel) {
                    HumanoidModel armorModel = new HumanoidModel(new ModelPart(Collections.emptyList(), Map.of("head", new OnionModel<T>((ModelPart)Minecraft.m_91087_().m_167973_().m_171103_((ModelLayerLocation)ModModelLayers.ONION_LAYER)).head, "hat", new ModelPart(Collections.emptyList(), Collections.emptyMap()), "body", new ModelPart(Collections.emptyList(), Collections.emptyMap()), "right_arm", new ModelPart(Collections.emptyList(), Collections.emptyMap()), "left_arm", new ModelPart(Collections.emptyList(), Collections.emptyMap()), "right_leg", new ModelPart(Collections.emptyList(), Collections.emptyMap()), "left_leg", new ModelPart(Collections.emptyList(), Collections.emptyMap()))));
                    armorModel.f_102817_ = living.m_6144_();
                    armorModel.f_102609_ = defaultModel.f_102609_;
                    armorModel.f_102610_ = living.m_6162_();
                    return armorModel;
                }
            });
        }

        public void m_7373_(ItemStack itemstack, Level world, List<Component> list, TooltipFlag flag) {
            super.m_7373_(itemstack, world, list, flag);
            list.add((Component)Component.m_237115_((String)"item.jigsaw_pp.onion.desc"));
        }

        public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, String type) {
            return "jigsaw_pp:textures/models/armor/onion.png";
        }

        public void m_6883_(ItemStack itemstack, Level world, Entity entity, int slot, boolean selected) {
            Player player;
            super.m_6883_(itemstack, world, entity, slot, selected);
            if (entity instanceof Player && Iterables.contains((Iterable)(player = (Player)entity).m_6168_(), (Object)itemstack)) {
                if (entity == null) {
                    return;
                }
                double T = 0.0;
                double Zo = 0.0;
                double Yo = 0.0;
                double Za = 0.0;
                double Xo = 0.0;
                double Ya = 0.0;
                double Xa = 0.0;
                itemstack.m_41784_().m_128347_("cc2", itemstack.m_41784_().m_128459_("cc2") + 1.0);
                if (itemstack.m_41784_().m_128459_("cc2") % 60.0 == 0.0) {
                    Vec3 _center = new Vec3(entity.m_20185_(), entity.m_20186_(), entity.m_20189_());
                    List _entfound = world.m_6443_(Entity.class, new AABB(_center, _center).m_82400_(16.0), e -> true).stream().sorted(Comparator.comparingDouble(_entcnd -> _entcnd.m_20238_(_center))).collect(Collectors.toList());
                    for (Entity entityiterator : _entfound) {
                        ServerLevel _level;
                        if (!(entityiterator instanceof Cow)) continue;
                        if (entityiterator instanceof Mob) {
                            Mob _entity = (Mob)entityiterator;
                            _entity.m_21573_().m_26519_(entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), 3.0);
                        }
                        Xo = entity.m_20185_() - entityiterator.m_20185_();
                        Yo = entity.m_20186_() - entityiterator.m_20186_();
                        Zo = entity.m_20189_() - entityiterator.m_20189_();
                        if (Math.floor(entity.m_20185_()) <= Math.floor(entityiterator.m_20185_())) {
                            if (Math.floor(entity.m_20185_()) == Math.floor(entityiterator.m_20185_())) {
                                if (Math.floor(entity.m_20186_()) == Math.floor(entityiterator.m_20186_())) {
                                    if (Math.floor(entity.m_20189_()) <= Math.floor(entityiterator.m_20189_())) {
                                        for (Za = Math.floor(entity.m_20189_()) + 0.2; Za <= Math.floor(entityiterator.m_20189_()); Za = 0.2 + Za) {
                                            T = (Za - entity.m_20189_()) / Zo;
                                            Ya = (double)(entity.m_20206_() / 2.0f) + entity.m_20186_() + Yo * T;
                                            Xa = entity.m_20185_() + Xo * T;
                                            if (!(world instanceof ServerLevel)) continue;
                                            _level = (ServerLevel)world;
                                            _level.m_8767_((ParticleOptions)ParticleTypes.f_175830_, Xa, Ya, Za, 1, 0.0, 0.0, 0.0, 0.0);
                                        }
                                        continue;
                                    }
                                    for (Za = Math.floor(entityiterator.m_20189_()) + 0.2; Za <= Math.floor(entity.m_20189_()); Za = 0.2 + Za) {
                                        T = (Za - entity.m_20189_()) / Zo;
                                        Ya = (double)(entity.m_20206_() / 2.0f) + entity.m_20186_() + Yo * T;
                                        Xa = entity.m_20185_() + Xo * T;
                                        if (!(world instanceof ServerLevel)) continue;
                                        _level = (ServerLevel)world;
                                        _level.m_8767_((ParticleOptions)ParticleTypes.f_175830_, Xa, Ya, Za, 1, 0.0, 0.0, 0.0, 0.0);
                                    }
                                    continue;
                                }
                                if (Math.floor(entity.m_20186_()) <= Math.floor(entityiterator.m_20186_())) {
                                    for (Ya = Math.floor(entity.m_20186_()) + 0.2; Ya <= Math.floor(entityiterator.m_20186_()); Ya = 0.2 + Ya) {
                                        T = (Ya - entity.m_20186_()) / Yo;
                                        Xa = entity.m_20185_() + Xo * T;
                                        Za = entity.m_20189_() + Zo * T;
                                        if (!(world instanceof ServerLevel)) continue;
                                        _level = (ServerLevel)world;
                                        _level.m_8767_((ParticleOptions)ParticleTypes.f_175830_, Xa, Ya, Za, 1, 0.0, 0.0, 0.0, 0.0);
                                    }
                                    continue;
                                }
                                for (Ya = Math.floor(entityiterator.m_20186_()) + 0.2; Ya <= Math.floor(entity.m_20186_()); Ya = 0.2 + Ya) {
                                    T = (Ya - entity.m_20186_()) / Yo;
                                    Xa = entity.m_20185_() + Xo * T;
                                    Za = entity.m_20189_() + Zo * T;
                                    if (!(world instanceof ServerLevel)) continue;
                                    _level = (ServerLevel)world;
                                    _level.m_8767_((ParticleOptions)ParticleTypes.f_175830_, Xa, Ya, Za, 1, 0.0, 0.0, 0.0, 0.0);
                                }
                                continue;
                            }
                            for (Xa = Math.floor(entity.m_20185_()) + 0.2; Xa <= Math.floor(entityiterator.m_20185_()); Xa = 0.2 + Xa) {
                                T = (Xa - entity.m_20185_()) / Xo;
                                Ya = (double)(entity.m_20206_() / 2.0f) + entity.m_20186_() + Yo * T;
                                Za = entity.m_20189_() + Zo * T;
                                if (!(world instanceof ServerLevel)) continue;
                                _level = (ServerLevel)world;
                                _level.m_8767_((ParticleOptions)ParticleTypes.f_175830_, Xa, Ya, Za, 1, 0.0, 0.0, 0.0, 0.0);
                            }
                            continue;
                        }
                        for (Xa = entityiterator.m_20185_() + 0.2; Xa < Math.floor(entity.m_20185_()); Xa = 0.2 + Xa) {
                            T = (Xa - entity.m_20185_()) / Xo;
                            Ya = (double)(entity.m_20206_() / 2.0f) + entity.m_20186_() + Yo * T;
                            Za = entity.m_20189_() + Zo * T;
                            if (!(world instanceof ServerLevel)) continue;
                            _level = (ServerLevel)world;
                            _level.m_8767_((ParticleOptions)ParticleTypes.f_175830_, Xa, Ya, Za, 1, 0.0, 0.0, 0.0, 0.0);
                        }
                    }
                }
            }
        }
    }
}

