/*
 * Decompiled with CFR 0.152.
 */
package net.svisvi.jigsawpp.item.grenades;

import java.util.List;
import java.util.Random;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.ForgeEventFactory;
import net.svisvi.jigsawpp.entity.projectile.granadeProjectiles.AbstractGrenadeProjectile;
import net.svisvi.jigsawpp.item.grenades.AbstractGrenadeItem;
import net.svisvi.jigsawpp.item.ut.CustomArmPoseItem;
import net.svisvi.jigsawpp.procedures.ut.GrenadeFinder;
import org.jetbrains.annotations.Nullable;

public class GrenadeLauncherItem
extends Item
implements CustomArmPoseItem {
    public static final int COOLDOWN = 20;
    public static final int COOLDOWN_BREAK = 60;
    public static float SPREAD = 0.0f;
    public static float MISSFIRE = 0.02f;

    public GrenadeLauncherItem() {
        super(new Item.Properties().m_41487_(1).m_41497_(Rarity.COMMON).m_41503_(250));
    }

    public GrenadeLauncherItem(int dur) {
        super(new Item.Properties().m_41487_(1).m_41497_(Rarity.COMMON).m_41503_(dur));
    }

    public int getCooldown() {
        return 20;
    }

    public int getCooldownBreak() {
        return 60;
    }

    public float getSpread() {
        return SPREAD;
    }

    public float getMissfire() {
        return MISSFIRE;
    }

    public void m_5551_(ItemStack pStack, Level pLevel, LivingEntity pEntity, int pTimeLeft) {
        if (pEntity instanceof Player) {
            Player pPlayer = (Player)pEntity;
            ItemStack purgen_pilule = GrenadeFinder.findGrenade(pPlayer);
            if (purgen_pilule != ItemStack.f_41583_) {
                ItemStack _ist;
                pPlayer.m_36335_().m_41524_((Item)this, this.getCooldown());
                if (!pPlayer.m_150110_().f_35937_ && (_ist = pStack).m_220157_(1, RandomSource.m_216327_(), null)) {
                    _ist.m_41774_(1);
                    _ist.m_41721_(0);
                }
                pLevel.m_6263_((Player)null, pPlayer.m_20185_(), pPlayer.m_20186_(), pPlayer.m_20189_(), SoundEvents.f_11833_, SoundSource.PLAYERS, 1.0f, 1.0f / (pLevel.m_213780_().m_188501_() * 0.4f + 0.8f));
                pLevel.m_6263_((Player)null, pPlayer.m_20185_(), pPlayer.m_20186_(), pPlayer.m_20189_(), SoundEvents.f_12312_, SoundSource.PLAYERS, 1.0f, 1.0f / (pLevel.m_213780_().m_188501_() * 0.4f + 0.8f));
                this.new_shoot(pLevel, pPlayer, pStack, purgen_pilule, this.getSpread());
            } else {
                pPlayer.m_36335_().m_41524_((Item)this, this.getCooldownBreak());
                pLevel.m_6263_((Player)null, pPlayer.m_20185_(), pPlayer.m_20186_(), pPlayer.m_20189_(), SoundEvents.f_11668_, SoundSource.PLAYERS, 1.0f, 1.0f / (pLevel.m_213780_().m_188501_() * 0.4f + 0.8f));
            }
        }
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level pLevel, Player pPlayer, InteractionHand pHand) {
        ItemStack itemstack = pPlayer.m_21120_(pHand);
        InteractionResultHolder ret = ForgeEventFactory.onArrowNock((ItemStack)itemstack, (Level)pLevel, (Player)pPlayer, (InteractionHand)pHand, (boolean)true);
        if (ret != null) {
            return ret;
        }
        pPlayer.m_6672_(pHand);
        return InteractionResultHolder.m_19096_((Object)itemstack);
    }

    public void new_shoot(Level pLevel, Player pPlayer, ItemStack thisStack, ItemStack purgenPilule, float inaccuracy) {
        Item item;
        if (!pLevel.m_5776_() && (item = purgenPilule.m_41720_()) instanceof AbstractGrenadeItem) {
            AbstractGrenadeItem grenadeitem = (AbstractGrenadeItem)item;
            Random rand = new Random();
            float randomValue = rand.nextFloat();
            if (randomValue < this.getMissfire()) {
                this.missfire(pLevel, pPlayer, thisStack, purgenPilule);
            } else {
                ThrowableItemProjectile grenade = grenadeitem.setProjectile(pLevel, pPlayer, purgenPilule);
                grenade.m_37446_(grenadeitem.getUsedItem());
                grenade.m_5602_((Entity)pPlayer);
                grenade.m_37251_((Entity)pPlayer, pPlayer.m_146909_(), pPlayer.m_146908_(), 0.0f, 2.0f, 0.2f);
                if (grenade instanceof AbstractGrenadeProjectile) {
                    AbstractGrenadeProjectile ge = (AbstractGrenadeProjectile)grenade;
                    ge.setLifeTime(40);
                    ge.setInstaboom(true);
                }
                pLevel.m_7967_((Entity)grenade);
            }
        }
    }

    public void missfire(Level pLevel, Player pPlayer, ItemStack thisStack, ItemStack purgenPilule) {
        Item item;
        if (!pLevel.m_5776_() && (item = purgenPilule.m_41720_()) instanceof AbstractGrenadeItem) {
            AbstractGrenadeItem grenadeitem = (AbstractGrenadeItem)item;
            ThrowableItemProjectile grenade = grenadeitem.setProjectile(pLevel, pPlayer, purgenPilule);
            grenade.m_37446_(grenadeitem.getUsedItem());
            grenade.m_5602_((Entity)pPlayer);
            if (grenade instanceof AbstractGrenadeProjectile) {
                AbstractGrenadeProjectile ge = (AbstractGrenadeProjectile)grenade;
                ge.explode();
            }
        }
        pPlayer.m_36335_().m_41524_((Item)this, this.getCooldown());
        pLevel.m_6263_((Player)null, pPlayer.m_20185_(), pPlayer.m_20186_(), pPlayer.m_20189_(), SoundEvents.f_12601_, SoundSource.PLAYERS, 1.0f, 1.0f / (pLevel.m_213780_().m_188501_() * 0.4f + 0.8f));
    }

    public int m_8105_(ItemStack pStack) {
        return 72000;
    }

    public UseAnim m_6164_(ItemStack pStack) {
        return UseAnim.BOW;
    }

    public void m_7373_(ItemStack itemstack, Level world, List<Component> list, TooltipFlag flag) {
        super.m_7373_(itemstack, world, list, flag);
        list.add((Component)Component.m_237115_((String)"item.jigsaw_pp.grenade_launcher.desc"));
    }

    @Override
    @Nullable
    public // Could not load outer class - annotation placement on inner may be incorrect
     @Nullable @Nullable HumanoidModel.ArmPose getArmPose(ItemStack stack, AbstractClientPlayer player, InteractionHand hand) {
        if (!player.f_20911_ && !player.m_6117_()) {
            return HumanoidModel.ArmPose.CROSSBOW_CHARGE;
        }
        return null;
    }
}

