/*
 * Decompiled with CFR 0.152.
 */
package net.svisvi.jigsawpp.item.pilule;

import java.util.Iterator;
import java.util.List;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.svisvi.jigsawpp.effect.PurgativeEffect;
import net.svisvi.jigsawpp.effect.init.ModEffects;
import net.svisvi.jigsawpp.item.init.ModItems;
import net.svisvi.jigsawpp.procedures.ut.PiluleStyles;

public class AbstractPiluleItem
extends Item {
    static int duration = 1000;
    int duration_buff = 0;
    static int amplifier = 0;
    public static int EFFECTS_REVEAL = 50;
    MobEffectInstance effect;

    public AbstractPiluleItem(MobEffectInstance _effect) {
        super(new Item.Properties().m_41487_(16).m_41497_(Rarity.COMMON).m_41489_(new FoodProperties.Builder().m_38760_(1).m_38758_(0.0f).m_38765_().m_38757_().m_38762_(_effect, 1.0f).m_38767_()));
    }

    public int m_8105_(ItemStack itemstack) {
        return 16;
    }

    public static boolean doctorEnabled(Player player) {
        return player.m_6844_(EquipmentSlot.HEAD).m_41720_() == ModItems.DOCTOR_HELMET.get();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack itemstack, Level world, List<Component> list, TooltipFlag flag) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        boolean isCreative = player != null && player.m_7500_();
        list.add((Component)Component.m_237115_((String)"item.jigsaw_pp.pilule.duration"));
        list.add((Component)Component.m_237113_((String)Integer.toString(this.duration() / 20)).m_7220_((Component)Component.m_237115_((String)"misc.jigsaw_pp.second")).m_7220_((Component)Component.m_237113_((String)"\u00a77 + ")).m_7220_((Component)Component.m_237113_((String)Integer.toString(itemstack.m_41784_().m_128451_("duration_buff") / 20))).m_7220_((Component)Component.m_237115_((String)"misc.jigsaw_pp.second")));
        list.add((Component)Component.m_237115_((String)"item.jigsaw_pp.pilule.purity"));
        list.add((Component)Component.m_237113_((String)Integer.toString(this.purity(itemstack))).m_6270_(PiluleStyles.purityLogic(this.purity(itemstack))).m_7220_((Component)Component.m_237113_((String)"%")));
        if (AbstractPiluleItem.doctorEnabled((Player)player)) {
            list.add((Component)Component.m_237115_((String)"item.jigsaw_pp.pilule.doctor_visibility"));
        } else if (isCreative) {
            list.add((Component)Component.m_237115_((String)"item.jigsaw_pp.pilule.god_visibility"));
        }
        if (this.purity(itemstack) >= EFFECTS_REVEAL || isCreative || AbstractPiluleItem.doctorEnabled((Player)player)) {
            if (PotionUtils.m_43547_((ItemStack)itemstack) != null) {
                list.add((Component)Component.m_237115_((String)"item.jigsaw_pp.pilule.sec_effect"));
                for (MobEffectInstance mobeffectinstance : PotionUtils.m_43547_((ItemStack)itemstack)) {
                    list.add((Component)Component.m_237113_((String)"\u00a77").m_7220_((Component)Component.m_237115_((String)mobeffectinstance.m_19576_()).m_6270_(PiluleStyles.effectLogic(mobeffectinstance))).m_7220_((Component)Component.m_237113_((String)" ")).m_7220_((Component)Component.m_237113_((String)PiluleStyles.numberToRoman(mobeffectinstance.m_19564_())).m_6270_(PiluleStyles.effectLogic(mobeffectinstance))).m_7220_((Component)Component.m_237113_((String)" ")).m_130946_(Integer.toString(mobeffectinstance.m_19557_() / 20)).m_7220_((Component)Component.m_237115_((String)"misc.jigsaw_pp.second")));
                }
            }
        } else {
            list.add((Component)Component.m_237115_((String)"item.jigsaw_pp.pilule.sec_effect"));
            list.add((Component)Component.m_237115_((String)"item.jigsaw_pp.pilule.effects_hidden"));
        }
        super.m_7373_(itemstack, world, list, flag);
    }

    public int duration() {
        return duration;
    }

    public int duration_buff() {
        return this.duration_buff;
    }

    public int amplifier() {
        return amplifier;
    }

    public MobEffectInstance effect() {
        return this.effect;
    }

    public int purity(ItemStack itemStack) {
        return itemStack.m_41784_().m_128451_("purity");
    }

    public static void setDurationBuff(int durationBuff, ItemStack itemStack) {
        itemStack.m_41784_().m_128405_("duration_buff", durationBuff);
    }

    public static void setPurity(int purity, ItemStack itemStack) {
        itemStack.m_41784_().m_128405_("purity", purity);
    }

    public ItemStack m_5922_(ItemStack itemstack, Level world, LivingEntity entity) {
        Player player;
        PurgativeEffect.addEffectInnerWay((Entity)entity, new MobEffectInstance(this.effect().m_19544_(), this.duration() + itemstack.m_41784_().m_128451_("duration_buff"), this.amplifier()));
        Player player2 = player = entity instanceof Player ? (Player)entity : null;
        if (player instanceof ServerPlayer) {
            CriteriaTriggers.f_10592_.m_23682_((ServerPlayer)player, itemstack);
        }
        if (!world.f_46443_) {
            AbstractPiluleItem pilule = (AbstractPiluleItem)itemstack.m_41720_();
            if (pilule.purity(itemstack) >= 85) {
                this.curePotionEffects(entity);
            }
            for (MobEffectInstance mobeffectinstance : PotionUtils.m_43547_((ItemStack)itemstack)) {
                if (mobeffectinstance.m_19544_().m_8093_()) {
                    if (mobeffectinstance.m_19544_().equals(ModEffects.BAD_EFFECT.get())) {
                        mobeffectinstance.m_19544_().m_19461_((Entity)player, (Entity)player, entity, mobeffectinstance.m_19564_(), (double)mobeffectinstance.m_19557_());
                        continue;
                    }
                    mobeffectinstance.m_19544_().m_19461_((Entity)player, (Entity)player, entity, mobeffectinstance.m_19564_(), 1.0);
                    continue;
                }
                entity.m_7292_(new MobEffectInstance(mobeffectinstance));
            }
        }
        ItemStack retval = new ItemStack((ItemLike)ModItems.EMPTY_PILULE.get());
        super.m_5922_(itemstack, world, entity);
        if (itemstack.m_41619_()) {
            return retval;
        }
        if (entity instanceof Player) {
            Player _player = (Player)entity;
            if (!_player.m_150110_().f_35937_ && !_player.m_150109_().m_36054_(retval)) {
                _player.m_36176_(retval, false);
            }
        }
        return itemstack;
    }

    public boolean curePotionEffects(LivingEntity entityLiving) {
        boolean ret = false;
        Iterator itr = entityLiving.m_21221_().values().iterator();
        while (itr.hasNext()) {
            MobEffectInstance effect = (MobEffectInstance)itr.next();
            if (effect.m_19544_().m_19486_() || effect.m_19544_() == ModEffects.PURGATIVE.get()) continue;
            effect.m_19544_().m_6386_(entityLiving, entityLiving.m_21204_(), effect.m_19564_());
            itr.remove();
            ret = true;
            if (!(entityLiving instanceof Player)) continue;
            ((Player)entityLiving).m_36335_().m_41524_((Item)this, 30);
        }
        return ret;
    }

    public static boolean comparePilules(ItemStack first, ItemStack second) {
        boolean logic = true;
        if (first.m_41784_().m_128451_("duration_buff") != second.m_41784_().m_128451_("duration_buff")) {
            logic = false;
            return logic;
        }
        if (first.m_41784_().m_128451_("purity") != second.m_41784_().m_128451_("purity")) {
            logic = false;
            return logic;
        }
        if (!PotionUtils.m_43547_((ItemStack)first).equals(PotionUtils.m_43547_((ItemStack)second))) {
            logic = false;
            return logic;
        }
        return logic;
    }
}

