/*
 * Decompiled with CFR 0.152.
 */
package net.svisvi.jigsawpp.item.purgen_gun;

import java.util.Random;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.ForgeEventFactory;
import net.svisvi.jigsawpp.effect.PurgativeEffect;
import net.svisvi.jigsawpp.effect.init.ModEffects;
import net.svisvi.jigsawpp.enchantment.ModEnchantments;
import net.svisvi.jigsawpp.entity.projectile.PurgenPiluleProjectile;
import net.svisvi.jigsawpp.item.ut.CustomArmPoseItem;
import net.svisvi.jigsawpp.procedures.ut.PurgenPiluleFinder;
import org.jetbrains.annotations.Nullable;

public class PurgenGunItem
extends Item
implements CustomArmPoseItem {
    public static final int COOLDOWN = 40;
    public static final int COOLDOWN_BREAK = 120;
    public static float SPREAD = 0.0f;
    public static float MISSFIRE = 0.03f;

    public PurgenGunItem() {
        super(new Item.Properties().m_41487_(1).m_41497_(Rarity.COMMON).m_41503_(250));
    }

    public PurgenGunItem(int dur) {
        super(new Item.Properties().m_41487_(1).m_41497_(Rarity.COMMON).m_41503_(dur));
    }

    public int getCooldown() {
        return 40;
    }

    public int getCooldownBreak() {
        return 120;
    }

    public float getSpread() {
        return SPREAD;
    }

    public float getMissfire() {
        return MISSFIRE;
    }

    public void m_5551_(ItemStack pStack, Level pLevel, LivingEntity pEntity, int pTimeLeft) {
        if (pEntity instanceof Player) {
            Player pPlayer = (Player)pEntity;
            ItemStack purgen_pilule = PurgenPiluleFinder.findPilule(pPlayer);
            if (purgen_pilule != ItemStack.f_41583_) {
                ItemStack _ist;
                pPlayer.m_36335_().m_41524_((Item)this, this.getCooldown());
                if (!pPlayer.m_150110_().f_35937_ && (_ist = pStack).m_220157_(1, RandomSource.m_216327_(), null)) {
                    _ist.m_41774_(1);
                    _ist.m_41721_(0);
                }
                pLevel.m_6263_((Player)null, pPlayer.m_20185_(), pPlayer.m_20186_(), pPlayer.m_20189_(), SoundEvents.f_11833_, SoundSource.PLAYERS, 1.0f, 1.0f / (pLevel.m_213780_().m_188501_() * 0.4f + 0.8f));
                pLevel.m_6263_((Player)null, pPlayer.m_20185_(), pPlayer.m_20186_(), pPlayer.m_20189_(), SoundEvents.f_12312_, SoundSource.PLAYERS, 1.0f, 1.0f / (pLevel.m_213780_().m_188501_() * 0.4f + 0.8f));
                this.new_shoot(pLevel, pPlayer, pStack, purgen_pilule, this.getSpread());
            } else {
                pPlayer.m_36335_().m_41524_((Item)this, this.getCooldownBreak());
                pLevel.m_6263_((Player)null, pPlayer.m_20185_(), pPlayer.m_20186_(), pPlayer.m_20189_(), SoundEvents.f_11668_, SoundSource.PLAYERS, 1.0f, 1.0f / (pLevel.m_213780_().m_188501_() * 0.4f + 0.8f));
            }
        }
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level pLevel, Player pPlayer, InteractionHand pHand) {
        ItemStack itemstack = pPlayer.m_21120_(pHand);
        InteractionResultHolder ret = ForgeEventFactory.onArrowNock((ItemStack)itemstack, (Level)pLevel, (Player)pPlayer, (InteractionHand)pHand, (boolean)true);
        if (ret != null) {
            return ret;
        }
        pPlayer.m_6672_(pHand);
        return InteractionResultHolder.m_19096_((Object)itemstack);
    }

    public void new_shoot(Level pLevel, Player pPlayer, ItemStack thisStack, ItemStack purgenPilule, float inaccuracy) {
        if (!pLevel.m_5776_()) {
            Random rand = new Random();
            float randomValue = rand.nextFloat();
            if (randomValue < this.getMissfire()) {
                this.missfire(pLevel, pPlayer, thisStack, purgenPilule);
            } else {
                boolean hasArmorPiercing = thisStack.getEnchantmentLevel((Enchantment)ModEnchantments.PURGEN_PIERCING.get()) >= 1;
                PurgenPiluleProjectile.shoot(pLevel, (LivingEntity)pPlayer, 1.3f, inaccuracy, purgenPilule, hasArmorPiercing);
            }
        }
    }

    public void missfire(Level pLevel, Player pPlayer, ItemStack thisStack, ItemStack purgenPilule) {
        if (PurgativeEffect.poopAdditionConditionLiquidWay((Entity)pPlayer, new MobEffectInstance((MobEffect)ModEffects.PURGATIVE.get(), 21, 0))) {
            purgenPilule.m_41720_().m_5922_(purgenPilule, pLevel, (LivingEntity)pPlayer);
        }
        pPlayer.m_36335_().m_41524_((Item)this, this.getCooldown());
        pLevel.m_6263_((Player)null, pPlayer.m_20185_(), pPlayer.m_20186_(), pPlayer.m_20189_(), SoundEvents.f_12601_, SoundSource.PLAYERS, 1.0f, 1.0f / (pLevel.m_213780_().m_188501_() * 0.4f + 0.8f));
    }

    public int m_8105_(ItemStack pStack) {
        return 72000;
    }

    public UseAnim m_6164_(ItemStack pStack) {
        return UseAnim.BOW;
    }

    @Override
    @Nullable
    public // Could not load outer class - annotation placement on inner may be incorrect
     @Nullable @Nullable HumanoidModel.ArmPose getArmPose(ItemStack stack, AbstractClientPlayer player, InteractionHand hand) {
        if (!player.f_20911_ && !player.m_6117_()) {
            return HumanoidModel.ArmPose.CROSSBOW_CHARGE;
        }
        return null;
    }
}

