/*
 * Decompiled with CFR 0.152.
 */
package net.svisvi.jigsawpp.mixin.client;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexBuffer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Axis;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.FogRenderer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.svisvi.jigsawpp.procedures.ut.PurgenApocalypseUtils;
import org.joml.Matrix4f;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={LevelRenderer.class})
public abstract class LevelRendererMixin {
    private static final ResourceLocation CUSTOM_SUN = new ResourceLocation("jigsaw_pp:textures/environment/purgen_sun.png");
    private static final Vec3 BROWN_SKY_COLOR = new Vec3(0.4, 0.2, 0.0);
    @Shadow
    private ClientLevel f_109465_;
    @Shadow
    private VertexBuffer f_109471_;

    @Inject(method={"renderSky"}, at={@At(value="HEAD")}, cancellable=true)
    private void renderCustomSky(PoseStack poseStack, Matrix4f projectionMatrix, float partialTick, Camera camera, boolean isFoggy, Runnable skyFogSetup, CallbackInfo ci) {
        if (!this.shouldApplyPurgenEffects()) {
            return;
        }
        ci.cancel();
        RenderSystem.setShader(GameRenderer::m_172808_);
        RenderSystem.setShaderColor((float)((float)LevelRendererMixin.BROWN_SKY_COLOR.f_82479_), (float)((float)LevelRendererMixin.BROWN_SKY_COLOR.f_82480_), (float)((float)LevelRendererMixin.BROWN_SKY_COLOR.f_82481_), (float)1.0f);
        BufferBuilder buffer = Tesselator.m_85913_().m_85915_();
        buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85814_);
        buffer.m_5483_(-1.0, -1.0, -1.0).m_5752_();
        buffer.m_5483_(1.0, -1.0, -1.0).m_5752_();
        buffer.m_5483_(1.0, 1.0, -1.0).m_5752_();
        buffer.m_5483_(-1.0, 1.0, -1.0).m_5752_();
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)buffer.m_231175_());
        float starBrightness = this.f_109465_.m_104811_(partialTick) * (this.shouldApplyPurgenEffects() ? 1.0f : 0.0f);
        if (starBrightness > 0.0f) {
            RenderSystem.setShaderColor((float)starBrightness, (float)starBrightness, (float)starBrightness, (float)starBrightness);
            FogRenderer.m_109017_();
            this.f_109471_.m_85921_();
            this.f_109471_.m_253207_(poseStack.m_85850_().m_252922_(), projectionMatrix, GameRenderer.m_172808_());
            VertexBuffer.m_85931_();
        }
        if (this.shouldApplyPurgenEffects()) {
            this.renderCustomSun(poseStack, partialTick);
        }
    }

    @Inject(method={"renderChunkLayer"}, at={@At(value="HEAD")}, cancellable=true)
    public void renderCustomChunkLayer(RenderType pRenderType, PoseStack pPoseStack, double pCamX, double pCamY, double pCamZ, Matrix4f pProjectionMatrix, CallbackInfo ci) {
        if (this.shouldApplyPurgenEffects()) {
            RenderSystem.setShaderColor((float)((float)LevelRendererMixin.BROWN_SKY_COLOR.f_82479_), (float)((float)LevelRendererMixin.BROWN_SKY_COLOR.f_82480_), (float)((float)LevelRendererMixin.BROWN_SKY_COLOR.f_82481_), (float)1.0f);
            ShaderInstance shader = RenderSystem.getShader();
            if (shader.f_173312_ != null) {
                shader.f_173312_.m_5805_((float)LevelRendererMixin.BROWN_SKY_COLOR.f_82479_, (float)LevelRendererMixin.BROWN_SKY_COLOR.f_82480_, (float)LevelRendererMixin.BROWN_SKY_COLOR.f_82481_, 1.0f);
            }
            if (shader.f_173317_ != null) {
                shader.f_173317_.m_5805_((float)LevelRendererMixin.BROWN_SKY_COLOR.f_82479_, (float)LevelRendererMixin.BROWN_SKY_COLOR.f_82480_, (float)LevelRendererMixin.BROWN_SKY_COLOR.f_82481_, 1.0f);
            }
        }
    }

    private void renderCustomSun(PoseStack poseStack, float partialTick) {
        poseStack.m_85836_();
        poseStack.m_252781_(Axis.f_252436_.m_252977_(-90.0f));
        poseStack.m_252781_(Axis.f_252529_.m_252977_(this.f_109465_.m_46942_(partialTick) * 360.0f));
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)CUSTOM_SUN);
        RenderSystem.setShaderColor((float)((float)LevelRendererMixin.BROWN_SKY_COLOR.f_82479_), (float)((float)LevelRendererMixin.BROWN_SKY_COLOR.f_82480_), (float)((float)LevelRendererMixin.BROWN_SKY_COLOR.f_82481_), (float)1.0f);
        Matrix4f matrix = poseStack.m_85850_().m_252922_();
        BufferBuilder buffer = Tesselator.m_85913_().m_85915_();
        buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        float size = 30.0f;
        buffer.m_252986_(matrix, -size, 100.0f, -size).m_7421_(0.0f, 0.0f).m_5752_();
        buffer.m_252986_(matrix, size, 100.0f, -size).m_7421_(1.0f, 0.0f).m_5752_();
        buffer.m_252986_(matrix, size, 100.0f, size).m_7421_(1.0f, 1.0f).m_5752_();
        buffer.m_252986_(matrix, -size, 100.0f, size).m_7421_(0.0f, 1.0f).m_5752_();
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)buffer.m_231175_());
        poseStack.m_85849_();
    }

    @OnlyIn(value=Dist.CLIENT)
    private boolean shouldApplyPurgenEffects() {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return false;
        }
        return PurgenApocalypseUtils.purgenPlayerRenderCondition((Player)player);
    }
}

