/*
 * Decompiled with CFR 0.152.
 */
package net.svisvi.jigsawpp.networking;

import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.network.simple.SimpleChannel;
import net.svisvi.jigsawpp.networking.packet.FluidSyncS2CPacket;
import net.svisvi.jigsawpp.networking.packet.SyncRocketDataPacket;

public class ModMessages {
    private static SimpleChannel INSTANCE;
    private static int packetId;

    private static int id() {
        return packetId++;
    }

    public static void register() {
        SimpleChannel net;
        INSTANCE = net = NetworkRegistry.ChannelBuilder.named((ResourceLocation)new ResourceLocation("jigsaw_pp", "messages")).networkProtocolVersion(() -> "1.0").clientAcceptedVersions(s -> true).serverAcceptedVersions(s -> true).simpleChannel();
        net.messageBuilder(FluidSyncS2CPacket.class, ModMessages.id(), NetworkDirection.PLAY_TO_CLIENT).decoder(FluidSyncS2CPacket::new).encoder(FluidSyncS2CPacket::toBytes).consumerMainThread(FluidSyncS2CPacket::handle).add();
        net.messageBuilder(SyncRocketDataPacket.class, ModMessages.id(), NetworkDirection.PLAY_TO_CLIENT).decoder(SyncRocketDataPacket::new).encoder(SyncRocketDataPacket::toBytes).consumerMainThread(SyncRocketDataPacket::handle).add();
    }

    public static <MSG> void sendToServer(MSG message) {
        INSTANCE.sendToServer(message);
    }

    public static <MSG> void sendToPlayer(MSG message, ServerPlayer player) {
        INSTANCE.send(PacketDistributor.PLAYER.with(() -> player), message);
    }

    public static <MSG> void sendToClients(MSG message) {
        INSTANCE.send(PacketDistributor.ALL.noArg(), message);
    }

    public static <MSG> void sendToTrackingEntity(MSG message, Entity entity) {
        INSTANCE.send(PacketDistributor.TRACKING_ENTITY.with(() -> entity), message);
    }

    static {
        packetId = 0;
    }
}

