/*
 * Decompiled with CFR 0.152.
 */
package net.svisvi.jigsawpp.procedures.radio;

import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.svisvi.jigsawpp.procedures.radio.IRadioActivatable;

public class RadioUtils {
    public static void activateAround(String code, Level level, BlockPos pPos, @Nullable LivingEntity activator) {
        Vec3 _center = new Vec3((double)pPos.m_123341_(), (double)pPos.m_123342_(), (double)pPos.m_123343_());
        List _entfound = level.m_6443_(Entity.class, new AABB(_center, _center).m_82400_(64.0), e -> true).stream().sorted(Comparator.comparingDouble(_entcnd -> _entcnd.m_20238_(_center))).collect(Collectors.toList());
        for (Entity entityiterator : _entfound) {
            if (entityiterator instanceof IRadioActivatable) {
                IRadioActivatable radioentity = (IRadioActivatable)entityiterator;
                if (RadioUtils.getEntityName(entityiterator).equals(code)) {
                    radioentity.activate(level, pPos, entityiterator, null, (Entity)activator, null);
                }
            }
            if (entityiterator instanceof Player) {
                Player player = (Player)entityiterator;
                RadioUtils.activatePlayer(player, level, (Entity)activator);
                continue;
            }
            if (!(entityiterator instanceof LivingEntity)) continue;
            LivingEntity living = (LivingEntity)entityiterator;
            RadioUtils.activateArmoredEntity(living, level, (Entity)activator);
        }
    }

    public static void activateWithItem(ItemStack stack, Level level, BlockPos pPos, @Nullable LivingEntity owner) {
        RadioUtils.activateAround(RadioUtils.getItemStackName(stack), level, pPos, owner);
    }

    public static String getItemStackName(ItemStack stack) {
        String name = stack.m_41611_().getString();
        if (name.startsWith("[") && name.endsWith("]")) {
            name = name.substring(1, name.length() - 1);
        }
        return name;
    }

    public static String getEntityName(Entity entity) {
        String name = entity.m_5446_().getString();
        if (name.startsWith("[") && name.endsWith("]")) {
            name = name.substring(1, name.length() - 1);
        }
        return name;
    }

    public static void activatePlayer(Player player, Level level, Entity activator) {
        for (ItemStack stack : player.m_150109_().f_35975_) {
            Item item = stack.m_41720_();
            if (!(item instanceof IRadioActivatable)) continue;
            IRadioActivatable radiostack = (IRadioActivatable)item;
            radiostack.activate(level, player.m_20097_(), null, (Entity)player, activator, stack);
        }
    }

    public static void activateArmoredEntity(LivingEntity living, Level level, Entity activator) {
        for (ItemStack stack : living.m_6168_()) {
            Item item = stack.m_41720_();
            if (!(item instanceof IRadioActivatable)) continue;
            IRadioActivatable radiostack = (IRadioActivatable)item;
            radiostack.activate(level, living.m_20097_(), null, (Entity)living, activator, stack);
        }
    }
}

