/*
 * Decompiled with CFR 0.152.
 */
package net.svisvi.jigsawpp.procedures.ut;

import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundLevelParticlesPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.svisvi.jigsawpp.particles.ModParticleTypes;

public class NuclearShroom {
    public static void createNuclearMushroom(Level level, double x, double y, double z) {
        if (level instanceof ServerLevel) {
            int yOffset;
            ServerLevel serverLevel = (ServerLevel)level;
            int stemHeight = 20;
            double stemRadius = 2.0;
            int stemParticlesPerLayer = 30;
            int capHeight = 10;
            double capBaseRadius = 15.0;
            int capParticlesPerLayer = 100;
            for (yOffset = 0; yOffset < stemHeight; ++yOffset) {
                for (int i = 0; i < stemParticlesPerLayer; ++i) {
                    double angle = Math.PI * 2 * (double)i / (double)stemParticlesPerLayer;
                    double dx = stemRadius * Math.cos(angle);
                    double dz = stemRadius * Math.sin(angle);
                    NuclearShroom.sendFarParticles(serverLevel, (ParticleOptions)ParticleTypes.f_123777_, x + dx, y + (double)yOffset, z + dz, 0.1, 0.1, 0.1);
                }
            }
            for (yOffset = 0; yOffset < capHeight; ++yOffset) {
                double progress = (double)yOffset / (double)capHeight;
                double currentRadius = capBaseRadius * Math.sqrt(1.0 - progress * progress);
                int particlesThisLayer = (int)((double)capParticlesPerLayer * (currentRadius / capBaseRadius));
                for (int i = 0; i < particlesThisLayer; ++i) {
                    double angle = Math.PI * 2 * (double)i / (double)particlesThisLayer;
                    double dx = currentRadius * Math.cos(angle);
                    double dz = currentRadius * Math.sin(angle);
                    SimpleParticleType type = ParticleTypes.f_123777_;
                    double speed = 0.2;
                    if (yOffset < capHeight / 3) {
                        type = ParticleTypes.f_123812_;
                        speed = 0.3;
                    } else if (yOffset < 2 * capHeight / 3) {
                        type = ParticleTypes.f_123756_;
                        speed = 0.25;
                    }
                    NuclearShroom.sendFarParticles(serverLevel, (ParticleOptions)type, x + dx, y + (double)stemHeight + (double)yOffset, z + dz, speed, speed, speed);
                }
            }
            NuclearShroom.sendFarParticles(serverLevel, (ParticleOptions)ParticleTypes.f_123744_, x, y, z, 5.0, 3.0, 5.0, 100, 0.2);
            NuclearShroom.sendFarParticles(serverLevel, (ParticleOptions)ParticleTypes.f_123756_, x, y, z, 5.0, 1.0, 5.0, 50, 0.1);
            NuclearShroom.sendFarParticles(serverLevel, (ParticleOptions)ParticleTypes.f_175827_, x, y + (double)stemHeight, z, 2.0, 3.0, 2.0, 20, 0.0);
        }
    }

    public static void createShitNuclearMushroom(Level level, double x, double y, double z) {
        if (level instanceof ServerLevel) {
            int yOffset;
            ServerLevel serverLevel = (ServerLevel)level;
            int stemHeight = 20;
            double stemRadius = 2.0;
            int stemParticlesPerLayer = 30;
            int capHeight = 10;
            double capBaseRadius = 15.0;
            int capParticlesPerLayer = 100;
            for (yOffset = 0; yOffset < stemHeight; ++yOffset) {
                for (int i = 0; i < stemParticlesPerLayer; ++i) {
                    double angle = Math.PI * 2 * (double)i / (double)stemParticlesPerLayer;
                    double dx = stemRadius * Math.cos(angle);
                    double dz = stemRadius * Math.sin(angle);
                    NuclearShroom.sendFarParticles(serverLevel, (ParticleOptions)ModParticleTypes.PURGATIVE_CLOUD.get(), x + dx, y + (double)yOffset, z + dz, 0.1, 0.1, 0.1);
                }
            }
            for (yOffset = 0; yOffset < capHeight; ++yOffset) {
                double progress = (double)yOffset / (double)capHeight;
                double currentRadius = capBaseRadius * Math.sqrt(1.0 - progress * progress);
                int particlesThisLayer = (int)((double)capParticlesPerLayer * (currentRadius / capBaseRadius));
                for (int i = 0; i < particlesThisLayer; ++i) {
                    double angle = Math.PI * 2 * (double)i / (double)particlesThisLayer;
                    double dx = currentRadius * Math.cos(angle);
                    double dz = currentRadius * Math.sin(angle);
                    ParticleOptions type = (ParticleOptions)ModParticleTypes.POOP_CLOUD.get();
                    double speed = 0.2;
                    if (yOffset < capHeight / 3) {
                        type = (ParticleOptions)ModParticleTypes.POOP_CLOUD.get();
                        speed = 0.3;
                    } else if (yOffset < 2 * capHeight / 3) {
                        type = (ParticleOptions)ModParticleTypes.POOP.get();
                        speed = 0.25;
                    }
                    NuclearShroom.sendFarParticles(serverLevel, type, x + dx, y + (double)stemHeight + (double)yOffset, z + dz, speed, speed, speed);
                }
            }
            NuclearShroom.sendFarParticles(serverLevel, (ParticleOptions)ParticleTypes.f_123744_, x, y, z, 5.0, 3.0, 5.0, 100, 0.2);
            NuclearShroom.sendFarParticles(serverLevel, (ParticleOptions)ParticleTypes.f_123756_, x, y, z, 5.0, 1.0, 5.0, 50, 0.1);
            NuclearShroom.sendFarParticles(serverLevel, (ParticleOptions)ParticleTypes.f_175827_, x, y + (double)stemHeight, z, 2.0, 3.0, 2.0, 20, 0.0);
        }
    }

    public static void sendFarParticles(ServerLevel level, ParticleOptions type, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
        for (ServerPlayer player : level.m_6907_()) {
            level.m_8624_(player, type, true, x, y, z, 1, 0.0, 0.0, 0.0, xSpeed);
        }
    }

    public static void sendFarParticles(ServerLevel level, ParticleOptions type, double x, double y, double z, double xd, double yd, double zd, int count, double speed) {
        ClientboundLevelParticlesPacket packet = new ClientboundLevelParticlesPacket(type, true, x, y, z, (float)xd, (float)yd, (float)zd, (float)speed, count);
        for (ServerPlayer player : level.m_6907_()) {
            if (player.m_9236_() != level) continue;
            player.f_8906_.m_9829_((Packet)packet);
        }
    }
}

