/*
 * Decompiled with CFR 0.152.
 */
package net.svisvi.jigsawpp.recipe;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.List;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.Level;
import net.svisvi.jigsawpp.recipe.ParsePotion;
import org.jetbrains.annotations.Nullable;

public class PurgenCatalystRecipe
implements Recipe<SimpleContainer> {
    private final NonNullList<Ingredient> inputItems;
    private final ItemStack output;
    private final ResourceLocation id;
    private final float purityK;
    private final float additionalTimeK;
    private final float malChanceK;
    private final ItemStack potionStack;

    public PurgenCatalystRecipe(NonNullList<Ingredient> inputItems, ItemStack output, ResourceLocation id, float p_purityK, float p_additionalTimeK, float p_malChanceK, ItemStack p_potion) {
        this.inputItems = inputItems;
        this.output = output;
        this.id = id;
        this.purityK = p_purityK;
        this.additionalTimeK = p_additionalTimeK;
        this.malChanceK = p_malChanceK;
        this.potionStack = p_potion;
    }

    public boolean matches(SimpleContainer pContainer, Level pLevel) {
        if (pLevel.m_5776_()) {
            return false;
        }
        return ((Ingredient)this.inputItems.get(0)).test(pContainer.m_8020_(0));
    }

    public NonNullList<Ingredient> m_7527_() {
        return this.inputItems;
    }

    public ItemStack assemble(SimpleContainer pContainer, RegistryAccess pRegistryAccess) {
        return this.output.m_41777_();
    }

    public boolean m_8004_(int pWidth, int pHeight) {
        return false;
    }

    public ItemStack m_8043_(RegistryAccess pRegistryAccess) {
        return this.output.m_41777_();
    }

    public float getPurityK(RegistryAccess pRegistryAccess) {
        return this.purityK;
    }

    public float getAdditionalTimeK(RegistryAccess pRegistryAccess) {
        return this.additionalTimeK;
    }

    public float getMalChanceK(RegistryAccess pRegistryAccess) {
        return this.malChanceK;
    }

    public ItemStack getPotionStack() {
        return this.potionStack;
    }

    public List<MobEffectInstance> getEffects() {
        return PotionUtils.m_43547_((ItemStack)this.potionStack);
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public RecipeSerializer<?> m_7707_() {
        return Serializer.INSTANCE;
    }

    public RecipeType<?> m_6671_() {
        return Type.INSTANCE;
    }

    public static class Serializer
    implements RecipeSerializer<PurgenCatalystRecipe> {
        public static final Serializer INSTANCE = new Serializer();
        public static final ResourceLocation ID = new ResourceLocation("jigsaw_pp", "purgen_catalyst");

        public PurgenCatalystRecipe fromJson(ResourceLocation pRecipeId, JsonObject pSerializedRecipe) {
            float purityK = pSerializedRecipe.get("purity").getAsFloat();
            float additionalTimeK = pSerializedRecipe.get("additionalTime").getAsFloat();
            float malChanceK = pSerializedRecipe.get("malChance").getAsFloat();
            ItemStack output = ShapedRecipe.m_151274_((JsonObject)GsonHelper.m_13930_((JsonObject)pSerializedRecipe, (String)"result"));
            JsonArray ingredients = GsonHelper.m_13933_((JsonObject)pSerializedRecipe, (String)"ingredients");
            NonNullList inputs = NonNullList.m_122780_((int)1, (Object)Ingredient.f_43901_);
            for (int i = 0; i < inputs.size(); ++i) {
                inputs.set(i, (Object)Ingredient.m_43917_((JsonElement)ingredients.get(i)));
            }
            return new PurgenCatalystRecipe((NonNullList<Ingredient>)inputs, output, pRecipeId, purityK, additionalTimeK, malChanceK, ParsePotion.parseFromJson(pSerializedRecipe));
        }

        @Nullable
        public PurgenCatalystRecipe fromNetwork(ResourceLocation pRecipeId, FriendlyByteBuf pBuffer) {
            NonNullList inputs = NonNullList.m_122780_((int)pBuffer.readInt(), (Object)Ingredient.f_43901_);
            for (int i = 0; i < inputs.size(); ++i) {
                inputs.set(i, (Object)Ingredient.m_43940_((FriendlyByteBuf)pBuffer));
            }
            ItemStack output = pBuffer.m_130267_();
            float purityK = pBuffer.readFloat();
            float additionalTimeK = pBuffer.readFloat();
            float malChanceK = pBuffer.readFloat();
            ItemStack potion = pBuffer.m_130267_();
            return new PurgenCatalystRecipe((NonNullList<Ingredient>)inputs, output, pRecipeId, purityK, additionalTimeK, malChanceK, potion);
        }

        public void toNetwork(FriendlyByteBuf pBuffer, PurgenCatalystRecipe pRecipe) {
            pBuffer.writeInt(pRecipe.inputItems.size());
            for (Ingredient ingredient : pRecipe.m_7527_()) {
                ingredient.m_43923_(pBuffer);
            }
            pBuffer.writeItemStack(pRecipe.m_8043_(null), false);
            pBuffer.writeFloat(pRecipe.getPurityK(null));
            pBuffer.writeFloat(pRecipe.getAdditionalTimeK(null));
            pBuffer.writeFloat(pRecipe.getMalChanceK(null));
            pBuffer.writeItemStack(pRecipe.getPotionStack(), false);
        }
    }

    public static class Type
    implements RecipeType<PurgenCatalystRecipe> {
        public static final Type INSTANCE = new Type();
        public static final String ID = "purgen_catalyst";
    }
}

