/*
 * Decompiled with CFR 0.152.
 */
package net.svisvi.jigsawpp.recipe;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.List;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistries;
import net.svisvi.jigsawpp.recipe.ParsePotion;
import org.jetbrains.annotations.Nullable;

public class PurgenFactoryRecipe
implements Recipe<SimpleContainer> {
    private final NonNullList<Ingredient> inputItems;
    private final ItemStack output;
    private final ResourceLocation id;
    private final int purity;
    private final int additionalTime;
    private final float malChance;
    private final ItemStack potionStack;
    private final FluidStack fluidStack;

    public PurgenFactoryRecipe(NonNullList<Ingredient> inputItems, ItemStack output, ResourceLocation id, int p_purity, int p_additionalTime, float p_malChance, ItemStack p_potion, FluidStack p_fluidStack) {
        this.inputItems = inputItems;
        this.output = output;
        this.id = id;
        this.purity = p_purity;
        this.additionalTime = p_additionalTime;
        this.malChance = p_malChance;
        this.potionStack = p_potion;
        this.fluidStack = p_fluidStack;
    }

    public boolean matches(SimpleContainer pContainer, Level pLevel) {
        return false;
    }

    public boolean match(SimpleContainer pContainer, FluidStack fluid, Level pLevel) {
        if (pLevel.m_5776_()) {
            return false;
        }
        return ((Ingredient)this.inputItems.get(0)).test(pContainer.m_8020_(0)) && ((Ingredient)this.inputItems.get(1)).test(pContainer.m_8020_(1)) && this.fluidStack.isFluidEqual(fluid) && this.fluidStack.getAmount() <= fluid.getAmount();
    }

    public NonNullList<Ingredient> m_7527_() {
        return this.inputItems;
    }

    public ItemStack assemble(SimpleContainer pContainer, RegistryAccess pRegistryAccess) {
        return this.output.m_41777_();
    }

    public boolean m_8004_(int pWidth, int pHeight) {
        return false;
    }

    public ItemStack m_8043_(RegistryAccess pRegistryAccess) {
        return this.output.m_41777_();
    }

    public int getPurity(RegistryAccess pRegistryAccess) {
        return this.purity;
    }

    public int getAdditionalTime(RegistryAccess pRegistryAccess) {
        return this.additionalTime;
    }

    public float getMalChance(RegistryAccess pRegistryAccess) {
        return this.malChance;
    }

    public ItemStack getPotionStack() {
        return this.potionStack;
    }

    public FluidStack getFluidStack() {
        return this.fluidStack;
    }

    public List<MobEffectInstance> getEffects() {
        return PotionUtils.m_43547_((ItemStack)this.potionStack);
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public RecipeSerializer<?> m_7707_() {
        return Serializer.INSTANCE;
    }

    public RecipeType<?> m_6671_() {
        return Type.INSTANCE;
    }

    public static class Serializer
    implements RecipeSerializer<PurgenFactoryRecipe> {
        public static final Serializer INSTANCE = new Serializer();
        public static final ResourceLocation ID = new ResourceLocation("jigsaw_pp", "purgen_factory");

        public PurgenFactoryRecipe fromJson(ResourceLocation pRecipeId, JsonObject pSerializedRecipe) {
            int purity = pSerializedRecipe.get("purity").getAsInt() * 4;
            int additionalTime = pSerializedRecipe.get("additionalTime").getAsInt();
            float malChance = pSerializedRecipe.get("malChance").getAsFloat();
            ItemStack output = ShapedRecipe.m_151274_((JsonObject)GsonHelper.m_13930_((JsonObject)pSerializedRecipe, (String)"result"));
            JsonObject fluidObj = GsonHelper.m_13930_((JsonObject)pSerializedRecipe, (String)"fluid");
            Fluid fluid = (Fluid)ForgeRegistries.FLUIDS.getValue(new ResourceLocation(fluidObj.get("fluid_name").getAsString()));
            FluidStack fstack = new FluidStack(fluid, fluidObj.get("amount").getAsInt());
            JsonArray ingredients = GsonHelper.m_13933_((JsonObject)pSerializedRecipe, (String)"ingredients");
            NonNullList inputs = NonNullList.m_122780_((int)2, (Object)Ingredient.f_43901_);
            for (int i = 0; i < inputs.size(); ++i) {
                inputs.set(i, (Object)Ingredient.m_43917_((JsonElement)ingredients.get(i)));
            }
            return new PurgenFactoryRecipe((NonNullList<Ingredient>)inputs, output, pRecipeId, purity, additionalTime, malChance, ParsePotion.parseFromJson(pSerializedRecipe), fstack);
        }

        @Nullable
        public PurgenFactoryRecipe fromNetwork(ResourceLocation pRecipeId, FriendlyByteBuf pBuffer) {
            NonNullList inputs = NonNullList.m_122780_((int)pBuffer.readInt(), (Object)Ingredient.f_43901_);
            for (int i = 0; i < inputs.size(); ++i) {
                inputs.set(i, (Object)Ingredient.m_43940_((FriendlyByteBuf)pBuffer));
            }
            ItemStack output = pBuffer.m_130267_();
            int purity = pBuffer.readInt();
            int additionalTime = pBuffer.readInt();
            float malChance = pBuffer.readFloat();
            ItemStack potion = pBuffer.m_130267_();
            FluidStack fstack = pBuffer.readFluidStack();
            return new PurgenFactoryRecipe((NonNullList<Ingredient>)inputs, output, pRecipeId, purity, additionalTime, malChance, potion, fstack);
        }

        public void toNetwork(FriendlyByteBuf pBuffer, PurgenFactoryRecipe pRecipe) {
            pBuffer.writeInt(pRecipe.inputItems.size());
            for (Ingredient ingredient : pRecipe.m_7527_()) {
                ingredient.m_43923_(pBuffer);
            }
            pBuffer.writeItemStack(pRecipe.m_8043_(null), false);
            pBuffer.writeFloat((float)pRecipe.getPurity(null));
            pBuffer.writeFloat((float)pRecipe.getAdditionalTime(null));
            pBuffer.writeFloat(pRecipe.getMalChance(null));
            pBuffer.writeItemStack(pRecipe.getPotionStack(), false);
            pBuffer.writeFluidStack(pRecipe.getFluidStack());
        }
    }

    public static class Type
    implements RecipeType<PurgenFactoryRecipe> {
        public static final Type INSTANCE = new Type();
        public static final String ID = "purgen_factory";
    }
}

