/*
 * Decompiled with CFR 0.152.
 */
package im.ghosty.kamoof;

import im.ghosty.kamoof.KamoofAPI;
import im.ghosty.kamoof.commands.GiveHeadCMD;
import im.ghosty.kamoof.commands.KamoofCMD;
import im.ghosty.kamoof.commands.UndisguiseCMD;
import im.ghosty.kamoof.deps.com.samjakob.spigui.SpiGUI;
import im.ghosty.kamoof.deps.xyz.haoshoku.nick.NickAPI;
import im.ghosty.kamoof.features.FeatureManager;
import im.ghosty.kamoof.features.disguise.DisguiseListener;
import im.ghosty.kamoof.features.disguise.DisguiseRestaurer;
import im.ghosty.kamoof.features.drophead.HeadDropper;
import im.ghosty.kamoof.features.macelimiter.MaceLimiter;
import im.ghosty.kamoof.features.macelimiter.MaceNoEnderChest;
import im.ghosty.kamoof.features.other.JoinMessages;
import im.ghosty.kamoof.features.other.UpdateChecker;
import im.ghosty.kamoof.features.ritual.RitualListener;
import im.ghosty.kamoof.features.ritual.RitualSetup;
import im.ghosty.kamoof.utils.Lang;
import im.ghosty.kamoof.utils.Message;
import im.ghosty.kamoof.utils.Metrics;
import java.io.File;
import java.io.IOException;
import lombok.Generated;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public final class KamoofPlugin
extends JavaPlugin {
    private static KamoofPlugin instance;
    private static YamlConfiguration data;
    private static File dataFile;
    private static SpiGUI spiGUI;
    private Metrics metrics;

    public static FileConfiguration config() {
        return instance.getConfig();
    }

    public static YamlConfiguration data() {
        return data;
    }

    public static void saveData() {
        if (data == null) {
            return;
        }
        data.save(dataFile);
        data = YamlConfiguration.loadConfiguration((File)dataFile);
    }

    public static void log(String msg, Object ... args) {
        Message.send((CommandSender)Bukkit.getConsoleSender(), String.format(msg, args));
    }

    public void onEnable() {
        super.onEnable();
        try {
            NickAPI.setupConfig(new File(this.getDataFolder(), "nickapi.yml"));
        }
        catch (IOException e) {
            NickAPI.setupConfig((ConfigurationSection)null);
        }
        NickAPI.setPlugin((Plugin)this);
        instance = this;
        this.saveDefaultConfig();
        spiGUI = new SpiGUI(this);
        Lang.init();
        new KamoofAPI();
        try {
            dataFile = new File(this.getDataFolder(), "data.yml");
            if (!dataFile.exists()) {
                dataFile.getParentFile().mkdirs();
                dataFile.createNewFile();
            }
            data = YamlConfiguration.loadConfiguration((File)dataFile);
        }
        catch (Throwable exc) {
            exc.printStackTrace();
            KamoofPlugin.log(Lang.get("DATA_FILE_FAILED"), new Object[0]);
        }
        FeatureManager.add(new DisguiseRestaurer(), new DisguiseListener(), new RitualSetup(), new RitualListener(), new HeadDropper(), new MaceLimiter(), new MaceNoEnderChest(), new UpdateChecker(), new JoinMessages());
        this.registerCommand("kamoofsmp", new KamoofCMD());
        this.registerCommand("givehead", new GiveHeadCMD());
        this.registerCommand("undisguise", new UndisguiseCMD());
        if (this.getConfig().getBoolean("metrics")) {
            this.metrics = new Metrics((Plugin)this, 23302);
        }
    }

    public void onDisable() {
        super.onDisable();
        FeatureManager.disable();
        NickAPI.onDisable();
        this.metrics.shutdown();
    }

    private void registerCommand(String name, CommandExecutor cmd) {
        this.getCommand(name).setExecutor(cmd);
        if (cmd instanceof TabCompleter) {
            TabCompleter tc = (TabCompleter)cmd;
            this.getCommand(name).setTabCompleter(tc);
        }
    }

    @Generated
    public static KamoofPlugin getInstance() {
        return instance;
    }

    @Generated
    public static SpiGUI getSpiGUI() {
        return spiGUI;
    }
}

