/*
 * Decompiled with CFR 0.152.
 */
package im.ghosty.kamoof.commands;

import im.ghosty.kamoof.features.drophead.SkullManager;
import im.ghosty.kamoof.utils.Lang;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public final class GiveHeadCMD
implements CommandExecutor,
TabCompleter {
    private static final Pattern usernamePattern = Pattern.compile("^[a-zA-Z0-9_]{1,16}$");

    public static void execute(Player player, String user) {
        if (!usernamePattern.matcher(user).matches()) {
            Lang.send((CommandSender)player, "INVALID_USERNAME", user);
            return;
        }
        ItemStack item = SkullManager.getSkull(user);
        if (player.getInventory().addItem(new ItemStack[]{item}).isEmpty()) {
            Lang.send((CommandSender)player, "HEAD_GIVEN", user);
        } else {
            Lang.send((CommandSender)player, "INVENTORY_FULL", new Object[0]);
        }
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!(sender instanceof Player)) {
            Lang.send(sender, "PLAYER_ONLY", new Object[0]);
            return true;
        }
        Player player = (Player)sender;
        if (args.length == 0) {
            player.sendMessage(String.format("\u00a7cUsage: /%s <username>", label.toLowerCase()));
            return true;
        }
        GiveHeadCMD.execute(player, args[0]);
        return true;
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String label, String[] args) {
        if (args.length > 1) {
            return List.of();
        }
        ArrayList<String> values = new ArrayList<String>();
        for (OfflinePlayer player2 : Bukkit.getOfflinePlayers()) {
            if (player2 == null || player2.getName() == null) continue;
            values.add(player2.getName());
        }
        if (args.length == 1) {
            String toCheck = args[0].toLowerCase().trim();
            values.removeIf(player -> !player.toLowerCase().trim().contains(toCheck));
        }
        return values;
    }
}

