/*
 * Decompiled with CFR 0.152.
 */
package im.ghosty.kamoof.deps.com.samjakob.spigui.menu;

import im.ghosty.kamoof.deps.com.samjakob.spigui.SpiGUI;
import im.ghosty.kamoof.deps.com.samjakob.spigui.buttons.SGButton;
import im.ghosty.kamoof.deps.com.samjakob.spigui.menu.SGMenu;
import im.ghosty.kamoof.deps.com.samjakob.spigui.toolbar.SGToolbarBuilder;
import im.ghosty.kamoof.deps.com.samjakob.spigui.toolbar.SGToolbarButtonType;
import java.util.Objects;
import java.util.Set;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryView;
import org.bukkit.plugin.java.JavaPlugin;

public class SGMenuListener
implements Listener {
    private final JavaPlugin owner;
    private final SpiGUI spiGUI;

    public SGMenuListener(JavaPlugin owner, SpiGUI spiGUI) {
        this.owner = owner;
        this.spiGUI = spiGUI;
    }

    private static boolean shouldIgnoreInventoryEvent(Inventory inventory) {
        return inventory == null || inventory.getHolder() == null || !(inventory.getHolder() instanceof SGMenu);
    }

    public static boolean willHandleInventoryEvent(JavaPlugin plugin, Inventory inventory) {
        return !SGMenuListener.shouldIgnoreInventoryEvent(inventory) && Objects.equals(((SGMenu)inventory.getHolder()).getOwner(), plugin);
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        boolean shouldCancel;
        if (SGMenuListener.shouldIgnoreInventoryEvent(event.getClickedInventory())) {
            return;
        }
        SGMenu clickedGui = (SGMenu)event.getClickedInventory().getHolder();
        if (clickedGui.getPermittedMenuClickTypes().stream().noneMatch(type -> type == event.getClick())) {
            event.setResult(Event.Result.DENY);
            return;
        }
        if (clickedGui.getBlockedMenuActions().stream().anyMatch(action -> action == event.getAction())) {
            event.setResult(Event.Result.DENY);
        }
        if (!clickedGui.getOwner().equals((Object)this.owner)) {
            return;
        }
        boolean bl = shouldCancel = clickedGui.areDefaultInteractionsBlocked() != null && clickedGui.areDefaultInteractionsBlocked() != false || this.spiGUI.areDefaultInteractionsBlocked();
        if (shouldCancel) {
            event.setResult(Event.Result.DENY);
        }
        if (event.getSlot() > clickedGui.getPageSize()) {
            int offset = event.getSlot() - clickedGui.getPageSize();
            SGToolbarBuilder paginationButtonBuilder = this.spiGUI.getDefaultToolbarBuilder();
            if (clickedGui.getToolbarBuilder() != null) {
                paginationButtonBuilder = clickedGui.getToolbarBuilder();
            }
            SGToolbarButtonType buttonType = SGToolbarButtonType.getDefaultForSlot(offset);
            SGButton paginationButton = paginationButtonBuilder.buildToolbarButton(offset, clickedGui.getCurrentPage(), buttonType, clickedGui);
            if (paginationButton != null) {
                paginationButton.getListener().onClick(event);
            }
            return;
        }
        if (clickedGui.isStickiedSlot(event.getSlot())) {
            SGButton button = clickedGui.getButton(0, event.getSlot());
            if (button != null && button.getListener() != null) {
                button.getListener().onClick(event);
            }
            return;
        }
        SGButton button = clickedGui.getButton(clickedGui.getCurrentPage(), event.getSlot());
        if (button != null && button.getListener() != null) {
            button.getListener().onClick(event);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onAdjacentInventoryClick(InventoryClickEvent event) {
        if (event.getView().getTopInventory() == null || SGMenuListener.shouldIgnoreInventoryEvent(event.getView().getTopInventory())) {
            return;
        }
        if (event.getClickedInventory() == event.getView().getTopInventory()) {
            return;
        }
        SGMenu clickedGui = (SGMenu)event.getView().getTopInventory().getHolder();
        if (clickedGui == null) {
            return;
        }
        if (clickedGui.getBlockedAdjacentActions().stream().anyMatch(action -> action == event.getAction())) {
            event.setResult(Event.Result.DENY);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onInventoryDrag(InventoryDragEvent event) {
        if (SGMenuListener.shouldIgnoreInventoryEvent(event.getInventory())) {
            return;
        }
        SGMenu clickedGui = (SGMenu)event.getInventory().getHolder();
        if (this.slotsIncludeTopInventory(event.getView(), event.getRawSlots())) {
            event.setResult(Event.Result.DENY);
        }
    }

    @EventHandler
    public void onInventoryClose(InventoryCloseEvent event) {
        if (SGMenuListener.shouldIgnoreInventoryEvent(event.getInventory())) {
            return;
        }
        SGMenu clickedGui = (SGMenu)event.getInventory().getHolder();
        if (!Objects.equals(clickedGui.getOwner(), this.owner)) {
            return;
        }
        if (clickedGui.getOnClose() != null) {
            clickedGui.getOnClose().accept(clickedGui);
        }
    }

    private boolean slotsIncludeTopInventory(InventoryView view, Set<Integer> slots) {
        return slots.stream().anyMatch(slot -> {
            if (slot >= view.getTopInventory().getSize()) {
                return false;
            }
            return slot.intValue() == view.convertSlot(slot.intValue());
        });
    }
}

