/*
 * Decompiled with CFR 0.152.
 */
package im.ghosty.kamoof.deps.xyz.haoshoku.nick;

import im.ghosty.kamoof.deps.xyz.haoshoku.nick.NickConfig;
import im.ghosty.kamoof.deps.xyz.haoshoku.nick.NickListener;
import im.ghosty.kamoof.deps.xyz.haoshoku.nick.handler.Handler;
import im.ghosty.kamoof.deps.xyz.haoshoku.nick.impl.AImplement;
import im.ghosty.kamoof.deps.xyz.haoshoku.nick.utils.SkinFetcher;
import im.ghosty.kamoof.deps.xyz.haoshoku.nick.utils.UUIDFetcher;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Map;
import java.util.UUID;
import lombok.Generated;
import org.bukkit.Bukkit;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class NickAPI {
    private static NickConfig config;
    private static UUIDFetcher uuidFetcher;
    private static SkinFetcher skinFetcher;
    private static Plugin plugin;
    private static Handler handler;
    private static AImplement implementation;

    public static void setPlugin(@NotNull Plugin plugin) {
        if (config == null) {
            NickAPI.setupConfig((ConfigurationSection)null);
        }
        NickAPI.plugin = plugin;
        handler = new Handler();
        handler.executeReloadOnEnable();
        implementation = handler.getAImplement();
        Bukkit.getPluginManager().registerEvents((Listener)new NickListener(), plugin);
    }

    public static void setupConfig(@Nullable ConfigurationSection section) {
        config = section == null ? new NickConfig() : new NickConfig(section);
        uuidFetcher = new UUIDFetcher();
        skinFetcher = new SkinFetcher();
    }

    public static void setupConfig(@Nullable File file) throws IOException {
        if (file == null) {
            NickAPI.setupConfig((ConfigurationSection)null);
            return;
        }
        if (!file.exists()) {
            file.getParentFile().mkdirs();
            file.createNewFile();
            InputStream stream = NickAPI.class.getClassLoader().getResourceAsStream("nickapi.yml");
            if (stream != null) {
                int len;
                FileOutputStream out = new FileOutputStream(file);
                byte[] buf = new byte[1024];
                while ((len = stream.read(buf)) > 0) {
                    ((OutputStream)out).write(buf, 0, len);
                }
                ((OutputStream)out).close();
                stream.close();
            }
        }
        NickAPI.setupConfig((ConfigurationSection)YamlConfiguration.loadConfiguration((File)file));
    }

    public static void onDisable() {
        handler.executeReloadOnDisable();
    }

    public static void nick(@NotNull Player player, @NotNull String toNick) {
        implementation.nick(player, toNick);
    }

    public static void resetNick(@NotNull Player player) {
        implementation.resetNick(player);
    }

    public static boolean isNicked(@NotNull Player player) {
        return implementation.isNicked(player);
    }

    public static boolean isSkinChanged(@NotNull Player player) {
        return implementation.isSkinChanged(player);
    }

    public static void setSkin(@NotNull Player player, @NotNull String toSkin) {
        implementation.setSkin(player, toSkin);
    }

    public static void setSkin(@NotNull Player player, @NotNull String value, @NotNull String signature) {
        implementation.setSkin(player, value, signature);
    }

    public static void resetSkin(@NotNull Player player) {
        implementation.resetSkin(player);
    }

    public static String[] getSkinData(@NotNull Player player) {
        return implementation.getSkinData(player);
    }

    public static String getOriginalGameProfileName(@NotNull Player player) {
        return implementation.getOriginalGameProfileName(player);
    }

    public static String getOriginalName(@NotNull Player player) {
        return implementation.getOriginalGameProfileName(player);
    }

    public static String getGameProfileName(@NotNull Player player) {
        return implementation.getGameProfileName(player);
    }

    public static void setGameProfileName(@NotNull Player player, @NotNull String name) {
        implementation.setGameProfileName(player, name);
    }

    public static void resetGameProfileName(@NotNull Player player) {
        implementation.resetGameProfileName(player);
    }

    public static UUID getUniqueId(@NotNull Player player) {
        return implementation.getUniqueId(player);
    }

    public static void setUniqueId(@NotNull Player player, @NotNull UUID uuid) {
        implementation.setUniqueId(player, uuid);
    }

    public static void setUniqueId(@NotNull Player player, @NotNull String name) {
        implementation.setUniqueId(player, name);
    }

    public static void resetUniqueId(@NotNull Player player) {
        implementation.resetUniqueId(player);
    }

    public static void refreshPlayer(@NotNull Player player) {
        implementation.refreshPlayer(player);
    }

    public static void refreshPlayerSync(@NotNull Player player) {
        implementation.refreshPlayerSync(player, false);
    }

    public static Player getPlayerOfOriginalName(@NotNull String name) {
        return implementation.getPlayerOfOriginalName(name);
    }

    public static Player getPlayerOfNickedName(@NotNull String name) {
        return implementation.getPlayerOfNickedName(name);
    }

    public static boolean nickExists(@NotNull String name) {
        return implementation.nickExists(name);
    }

    public static boolean isNickedName(@NotNull String name) {
        return implementation.isNickedName(name);
    }

    public static Map<UUID, String> getNickedPlayers() {
        return implementation.getNickedPlayers();
    }

    public static String getName(@NotNull Player player) {
        return implementation.getName(player);
    }

    public static void hidePlayer(@NotNull Player player, @NotNull Player toHide) {
        implementation.hidePlayerDelayed(player, toHide);
    }

    public static void hidePlayer(@NotNull Player player, @NotNull Collection<? extends Player> playersToHide) {
        implementation.hidePlayer(player, playersToHide);
    }

    public static void showPlayer(@NotNull Player player, @NotNull Player toShow) {
        implementation.showPlayerDelayed(player, toShow);
    }

    public static void showPlayer(@NotNull Player player, @NotNull Collection<? extends Player> playersToShow) {
        implementation.showPlayer(player, playersToShow);
    }

    public static UUIDFetcher getUUIDFetcher() {
        return uuidFetcher;
    }

    public static SkinFetcher getSkinFetcher() {
        return skinFetcher;
    }

    public static NickConfig getConfig() {
        return config;
    }

    @Generated
    public static Plugin getPlugin() {
        return plugin;
    }

    @Generated
    public static Handler getHandler() {
        return handler;
    }
}

