/*
 * Decompiled with CFR 0.152.
 */
package im.ghosty.kamoof.deps.xyz.haoshoku.nick;

import im.ghosty.kamoof.deps.xyz.haoshoku.nick.NickAPI;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;
import org.bukkit.scoreboard.Scoreboard;
import org.bukkit.scoreboard.Team;
import org.jetbrains.annotations.NotNull;

public class NickScoreboard {
    private static final Map<String, Object[]> SCOREBOARD_MAP = new HashMap<String, Object[]>();

    public static void write(@NotNull String nickedName, @NotNull String teamName, @NotNull String prefix, @NotNull String suffix) {
        NickScoreboard.write(nickedName, teamName, prefix, suffix, true, ChatColor.BLUE);
    }

    public static void write(@NotNull String nickedName, @NotNull String teamName, @NotNull String prefix, @NotNull String suffix, boolean newScoreboard, ChatColor color) {
        SCOREBOARD_MAP.put(nickedName, new Object[]{teamName, prefix, suffix, newScoreboard, color});
    }

    public static void write(@NotNull String nickedName, @NotNull String teamName, @NotNull String prefix, @NotNull String suffix, ChatColor color) {
        SCOREBOARD_MAP.put(nickedName, new Object[]{teamName, prefix, suffix, true, color});
    }

    public static void delete(String nickedName) {
        SCOREBOARD_MAP.remove(nickedName);
    }

    public static void updateAllScoreboard() {
        for (Map.Entry<String, Object[]> entry : SCOREBOARD_MAP.entrySet()) {
            String teamName = (String)entry.getValue()[0];
            String prefix = (String)entry.getValue()[1];
            String suffix = (String)entry.getValue()[2];
            boolean newScoreboard = (Boolean)entry.getValue()[3];
            ChatColor color = (ChatColor)entry.getValue()[4];
            for (Player player : Bukkit.getOnlinePlayers()) {
                Scoreboard scoreboard;
                if (newScoreboard && player.getScoreboard() == Bukkit.getScoreboardManager().getMainScoreboard()) {
                    player.setScoreboard(Bukkit.getScoreboardManager().getNewScoreboard());
                }
                Team team = (scoreboard = player.getScoreboard()).getTeam(teamName) != null ? scoreboard.getTeam(teamName) : scoreboard.registerNewTeam(teamName);
                team.setPrefix(prefix);
                team.setSuffix(suffix);
                try {
                    if (color != null) {
                        team.setColor(color);
                    }
                }
                catch (NoSuchMethodError noSuchMethodError) {
                    // empty catch block
                }
                team.addEntry(entry.getKey());
            }
        }
    }

    public static void updateScoreboard(@NotNull String nickedName) {
        if (!SCOREBOARD_MAP.containsKey(nickedName)) {
            return;
        }
        Bukkit.getScheduler().runTask(NickAPI.getPlugin(), () -> {
            Object[] values = SCOREBOARD_MAP.get(nickedName);
            String teamName = (String)values[0];
            String prefix = (String)values[1];
            String suffix = (String)values[2];
            boolean newScoreboard = (Boolean)values[3];
            ChatColor color = (ChatColor)values[4];
            Bukkit.getOnlinePlayers().iterator();
            Iterator iterator = null;
            while (iterator.hasNext()) {
                Scoreboard scoreboard;
                Player player = (Player)iterator.next();
                if (newScoreboard && player.getScoreboard() == Bukkit.getScoreboardManager().getMainScoreboard()) {
                    player.setScoreboard(Bukkit.getScoreboardManager().getNewScoreboard());
                }
                Team team = (scoreboard = player.getScoreboard()).getTeam(teamName) != null ? scoreboard.getTeam(teamName) : scoreboard.registerNewTeam(teamName);
                team.setPrefix(prefix);
                team.setSuffix(suffix);
                try {
                    team.setColor(color);
                }
                catch (NoSuchMethodError noSuchMethodError) {
                    // empty catch block
                }
                team.addEntry(nickedName);
            }
        });
    }
}

