/*
 * Decompiled with CFR 0.152.
 */
package im.ghosty.kamoof.features;

import im.ghosty.kamoof.KamoofPlugin;
import im.ghosty.kamoof.features.Feature;
import im.ghosty.kamoof.utils.Lang;
import java.util.ArrayList;
import lombok.Generated;

public final class FeatureManager {
    private static final ArrayList<Feature> features = new ArrayList();

    public static void add(Feature ... features) {
        for (Feature feature : features) {
            try {
                FeatureManager.features.add(feature);
                if (!feature.isEnabled()) continue;
                feature.onEnable();
            }
            catch (Throwable e) {
                e.printStackTrace();
                FeatureManager.features.remove(feature);
                KamoofPlugin.log(Lang.get("FEATURE_FAILED"), feature.getClass().getSimpleName());
            }
        }
    }

    public static void refresh() {
        for (Feature feature : features) {
            boolean shouldEnable = feature.isEnabled();
            if (shouldEnable && !feature.enabled) {
                feature.onEnable();
                continue;
            }
            if (shouldEnable || !feature.enabled) continue;
            feature.onDisable();
        }
    }

    public static void disable() {
        for (Feature feature : features) {
            if (feature.enabled) {
                feature.onDisable();
            }
            feature.onStop();
        }
    }

    @Generated
    private FeatureManager() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

