/*
 * Decompiled with CFR 0.152.
 */
package im.ghosty.kamoof.features.disguise;

import im.ghosty.kamoof.KamoofPlugin;
import im.ghosty.kamoof.api.KamoofSMP;
import im.ghosty.kamoof.api.events.KamoofDisguiseEvent;
import im.ghosty.kamoof.deps.xyz.haoshoku.nick.NickAPI;
import im.ghosty.kamoof.features.Feature;
import im.ghosty.kamoof.features.disguise.DisguiseManager;
import im.ghosty.kamoof.features.disguise.DisguiseRestaurer;
import im.ghosty.kamoof.features.drophead.SkullManager;
import im.ghosty.kamoof.utils.Message;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.player.AsyncPlayerPreLoginEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public final class DisguiseListener
extends Feature {
    @Override
    public boolean isEnabled() {
        return true;
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onInteract(PlayerInteractEvent event) {
        Player player = event.getPlayer();
        OfflinePlayer target = SkullManager.getOwner(event.getItem());
        if (target == null) {
            return;
        }
        switch (event.getAction()) {
            case LEFT_CLICK_BLOCK: 
            case LEFT_CLICK_AIR: 
            case PHYSICAL: {
                return;
            }
            case RIGHT_CLICK_BLOCK: {
                if (!KamoofPlugin.config().getBoolean("disguise.place-head")) {
                    event.setCancelled(true);
                }
                return;
            }
        }
        String name = KamoofSMP.getInstance().getName(target);
        if (name == null) {
            name = SkullManager.getName(event.getItem());
        }
        KamoofDisguiseEvent disguiseEvent = new KamoofDisguiseEvent(player, name);
        Bukkit.getPluginManager().callEvent((Event)disguiseEvent);
        if (disguiseEvent.isCancelled()) {
            return;
        }
        if (player.getGameMode() != GameMode.CREATIVE) {
            event.getItem().setAmount(event.getItem().getAmount() - 1);
        }
        if (KamoofPlugin.config().getBoolean("disguise.give-back") && NickAPI.isNicked(player)) {
            ItemStack item = SkullManager.getSkull(NickAPI.getName(player));
            if (!player.getInventory().addItem(new ItemStack[]{item}).isEmpty()) {
                player.getWorld().dropItem(player.getLocation(), item);
            }
        }
        DisguiseManager.disguise(player, name);
        Message.send((CommandSender)player, "messages.disguised", Map.of("player", KamoofSMP.getInstance().getName((OfflinePlayer)player), "nick", name));
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onDeath(PlayerDeathEvent event) {
        Player player = event.getEntity();
        if (!NickAPI.isNicked(player)) {
            return;
        }
        String disguise = NickAPI.getName(player);
        KamoofSMP.getInstance().disguise((OfflinePlayer)player, null);
        Message.send((CommandSender)player, "messages.lostdisguise", Map.of("player", KamoofSMP.getInstance().getName((OfflinePlayer)player), "nick", disguise));
        DisguiseRestaurer.set(player.getUniqueId(), null);
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onRequestJoin(AsyncPlayerPreLoginEvent event) {
        if (event.getLoginResult() != AsyncPlayerPreLoginEvent.Result.ALLOWED) {
            return;
        }
        Bukkit.getScheduler().runTask((Plugin)KamoofPlugin.getInstance(), () -> {
            Player player = NickAPI.getPlayerOfNickedName(event.getName());
            if (player == null) {
                return;
            }
            NickAPI.setGameProfileName(player, NickAPI.getOriginalGameProfileName(player));
            NickAPI.refreshPlayer(player);
            Bukkit.getScheduler().runTaskLater((Plugin)KamoofPlugin.getInstance(), () -> {
                if (!player.isOnline()) {
                    return;
                }
                NickAPI.setGameProfileName(player, event.getName());
                NickAPI.refreshPlayer(player);
            }, 1L);
        });
    }
}

