/*
 * Decompiled with CFR 0.152.
 */
package im.ghosty.kamoof.features.drophead;

import im.ghosty.kamoof.KamoofPlugin;
import im.ghosty.kamoof.api.KamoofSMP;
import im.ghosty.kamoof.utils.Placeholder;
import java.util.Map;
import lombok.Generated;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.OfflinePlayer;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.persistence.PersistentDataType;

public final class SkullManager {
    private static final NamespacedKey keyTimestamp = new NamespacedKey("kamoofsmp", "timestamp");
    private static final NamespacedKey keyPlayer = new NamespacedKey("kamoofsmp", "player");

    public static ItemStack getSkull(String player) {
        ItemStack item = new ItemStack(Material.PLAYER_HEAD);
        SkullMeta meta = (SkullMeta)item.getItemMeta();
        OfflinePlayer target = Bukkit.getOfflinePlayer((String)player);
        meta.setOwnerProfile(target.getPlayerProfile());
        String itemName = Placeholder.apply(KamoofPlugin.config().getString("drophead.name"), Map.of("player", player));
        meta.setDisplayName(itemName);
        try {
            meta.setItemName(itemName);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        meta.setLore(Placeholder.apply(KamoofPlugin.config().getStringList("drophead.lore"), Map.of("player", player)));
        boolean stackable = KamoofPlugin.config().getBoolean("drophead.stackable");
        meta.getPersistentDataContainer().set(keyTimestamp, PersistentDataType.LONG, (Object)(stackable ? -1L : System.currentTimeMillis()));
        meta.getPersistentDataContainer().set(keyPlayer, PersistentDataType.STRING, (Object)player);
        item.setItemMeta((ItemMeta)meta);
        return item;
    }

    public static OfflinePlayer getOwner(ItemStack item) {
        if (item == null || !item.hasItemMeta()) {
            return null;
        }
        ItemMeta itemMeta = item.getItemMeta();
        if (!(itemMeta instanceof SkullMeta)) {
            return null;
        }
        SkullMeta meta = (SkullMeta)itemMeta;
        return meta.getOwningPlayer();
    }

    public static String getName(ItemStack item) {
        if (item == null || !item.hasItemMeta()) {
            return null;
        }
        ItemMeta itemMeta = item.getItemMeta();
        if (!(itemMeta instanceof SkullMeta)) {
            return null;
        }
        SkullMeta meta = (SkullMeta)itemMeta;
        String name = (String)meta.getPersistentDataContainer().get(keyPlayer, PersistentDataType.STRING);
        if (name != null) {
            return name;
        }
        if (meta.getOwningPlayer() != null) {
            return KamoofSMP.getInstance().getName(meta.getOwningPlayer());
        }
        name = meta.getOwnerProfile().getName();
        if (name != null) {
            return name;
        }
        name = meta.getOwningPlayer().getName();
        return name;
    }

    @Generated
    private SkullManager() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

